/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.authorization.infinispan;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.authorization.infinispan.InfinispanStoreFactoryProvider;
import org.keycloak.models.authorization.infinispan.entities.CachedPolicy;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Logic;

public class CachedPolicyStore
implements PolicyStore {
    private static final String POLICY_ID_CACHE_PREFIX = "policy-id-";
    private final Cache<String, List> cache;
    private final KeycloakSession session;
    private final InfinispanStoreFactoryProvider.CacheTransaction transaction;
    private StoreFactory storeFactory;
    private PolicyStore delegate;

    public CachedPolicyStore(KeycloakSession session, InfinispanStoreFactoryProvider.CacheTransaction transaction) {
        this.session = session;
        this.transaction = transaction;
        InfinispanConnectionProvider provider = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        this.cache = provider.getCache("authorization");
    }

    public Policy create(String name, String type, ResourceServer resourceServer) {
        Policy policy = this.getDelegate().create(name, type, this.getStoreFactory().getResourceServerStore().findById(resourceServer.getId()));
        this.transaction.whenRollback(() -> {
            List cfr_ignored_0 = (List)this.cache.remove((Object)this.getCacheKeyForPolicy(policy.getId()));
        });
        return this.createAdapter(new CachedPolicy(policy));
    }

    public void delete(String id) {
        this.getDelegate().delete(id);
        this.transaction.whenCommit(() -> {
            List cfr_ignored_0 = (List)this.cache.remove((Object)this.getCacheKeyForPolicy(id));
        });
    }

    public Policy findById(String id) {
        String cacheKeyForPolicy = this.getCacheKeyForPolicy(id);
        List cached = (List)this.cache.get((Object)cacheKeyForPolicy);
        if (cached == null) {
            Policy policy = this.getDelegate().findById(id);
            if (policy != null) {
                return this.createAdapter(this.updatePolicyCache(policy));
            }
            return null;
        }
        return this.createAdapter((CachedPolicy)cached.get(0));
    }

    public Policy findByName(String name, String resourceServerId) {
        return this.getDelegate().findByName(name, resourceServerId);
    }

    public List<Policy> findByResourceServer(String resourceServerId) {
        return this.getDelegate().findByResourceServer(resourceServerId).stream().map(policy -> this.findById(policy.getId())).collect(Collectors.toList());
    }

    public List<Policy> findByResource(String resourceId) {
        ArrayList<Policy> cache = new ArrayList<Policy>();
        for (Map.Entry entry : this.cache.entrySet()) {
            List value;
            CachedPolicy policy2;
            String cacheKey = (String)entry.getKey();
            if (!cacheKey.startsWith(POLICY_ID_CACHE_PREFIX) || !(policy2 = (CachedPolicy)(value = (List)entry.getValue()).get(0)).getResourcesIds().contains(resourceId)) continue;
            cache.add(this.findById(policy2.getId()));
        }
        if (cache.isEmpty()) {
            this.getDelegate().findByResource(resourceId).forEach(policy -> cache.add(this.findById(this.updatePolicyCache((Policy)policy).getId())));
        }
        return cache;
    }

    public List<Policy> findByResourceType(String resourceType, String resourceServerId) {
        ArrayList<Policy> cache = new ArrayList<Policy>();
        for (Map.Entry entry : this.cache.entrySet()) {
            List value;
            CachedPolicy policy2;
            String cacheKey = (String)entry.getKey();
            if (!cacheKey.startsWith(POLICY_ID_CACHE_PREFIX) || !(policy2 = (CachedPolicy)(value = (List)entry.getValue()).get(0)).getResourceServerId().equals(resourceServerId) || !policy2.getConfig().getOrDefault("defaultResourceType", "").equals(resourceType)) continue;
            cache.add(this.findById(policy2.getId()));
        }
        if (cache.isEmpty()) {
            this.getDelegate().findByResourceType(resourceType, resourceServerId).forEach(policy -> cache.add(this.findById(this.updatePolicyCache((Policy)policy).getId())));
        }
        return cache;
    }

    public List<Policy> findByScopeIds(List<String> scopeIds, String resourceServerId) {
        ArrayList<Policy> cache = new ArrayList<Policy>();
        block0: for (Map.Entry entry : this.cache.entrySet()) {
            String cacheKey = (String)entry.getKey();
            if (!cacheKey.startsWith(POLICY_ID_CACHE_PREFIX)) continue;
            List value = (List)entry.getValue();
            CachedPolicy policy2 = (CachedPolicy)value.get(0);
            for (String scopeId : policy2.getScopesIds()) {
                if (!scopeIds.contains(scopeId)) continue;
                cache.add(this.findById(policy2.getId()));
                continue block0;
            }
        }
        if (cache.isEmpty()) {
            this.getDelegate().findByScopeIds(scopeIds, resourceServerId).forEach(policy -> cache.add(this.findById(this.updatePolicyCache((Policy)policy).getId())));
        }
        return cache;
    }

    public List<Policy> findByType(String type) {
        return this.getDelegate().findByType(type).stream().map(policy -> this.findById(policy.getId())).collect(Collectors.toList());
    }

    public List<Policy> findDependentPolicies(String id) {
        return this.getDelegate().findDependentPolicies(id).stream().map(policy -> this.findById(policy.getId())).collect(Collectors.toList());
    }

    private String getCacheKeyForPolicy(String policyId) {
        return POLICY_ID_CACHE_PREFIX + policyId;
    }

    private StoreFactory getStoreFactory() {
        if (this.storeFactory == null) {
            this.storeFactory = (StoreFactory)this.session.getProvider(StoreFactory.class);
        }
        return this.storeFactory;
    }

    private PolicyStore getDelegate() {
        if (this.delegate == null) {
            this.delegate = this.getStoreFactory().getPolicyStore();
        }
        return this.delegate;
    }

    private Policy createAdapter(final CachedPolicy cached) {
        return new Policy(){
            private Policy updated;

            public String getId() {
                return cached.getId();
            }

            public String getType() {
                return cached.getType();
            }

            public DecisionStrategy getDecisionStrategy() {
                return cached.getDecisionStrategy();
            }

            public void setDecisionStrategy(DecisionStrategy decisionStrategy) {
                this.getDelegateForUpdate().setDecisionStrategy(decisionStrategy);
                cached.setDecisionStrategy(decisionStrategy);
            }

            public Logic getLogic() {
                return cached.getLogic();
            }

            public void setLogic(Logic logic) {
                this.getDelegateForUpdate().setLogic(logic);
                cached.setLogic(logic);
            }

            public Map<String, String> getConfig() {
                return cached.getConfig();
            }

            public void setConfig(Map<String, String> config) {
                this.getDelegateForUpdate().setConfig(config);
                cached.setConfig(config);
            }

            public String getName() {
                return cached.getName();
            }

            public void setName(String name) {
                this.getDelegateForUpdate().setName(name);
                cached.setName(name);
            }

            public String getDescription() {
                return cached.getDescription();
            }

            public void setDescription(String description) {
                this.getDelegateForUpdate().setDescription(description);
                cached.setDescription(description);
            }

            public ResourceServer getResourceServer() {
                return CachedPolicyStore.this.getStoreFactory().getResourceServerStore().findById(cached.getResourceServerId());
            }

            public void addScope(Scope scope) {
                this.getDelegateForUpdate().addScope(CachedPolicyStore.this.getStoreFactory().getScopeStore().findById(scope.getId()));
                cached.addScope(scope);
            }

            public void removeScope(Scope scope) {
                this.getDelegateForUpdate().removeScope(CachedPolicyStore.this.getStoreFactory().getScopeStore().findById(scope.getId()));
                cached.removeScope(scope);
            }

            public void addAssociatedPolicy(Policy associatedPolicy) {
                this.getDelegateForUpdate().addAssociatedPolicy(CachedPolicyStore.this.getStoreFactory().getPolicyStore().findById(associatedPolicy.getId()));
                cached.addAssociatedPolicy(associatedPolicy);
            }

            public void removeAssociatedPolicy(Policy associatedPolicy) {
                this.getDelegateForUpdate().removeAssociatedPolicy(CachedPolicyStore.this.getStoreFactory().getPolicyStore().findById(associatedPolicy.getId()));
                cached.removeAssociatedPolicy(associatedPolicy);
            }

            public void addResource(Resource resource) {
                this.getDelegateForUpdate().addResource(CachedPolicyStore.this.getStoreFactory().getResourceStore().findById(resource.getId()));
                cached.addResource(resource);
            }

            public void removeResource(Resource resource) {
                this.getDelegateForUpdate().removeResource(CachedPolicyStore.this.getStoreFactory().getResourceStore().findById(resource.getId()));
                cached.removeResource(resource);
            }

            public Set<Policy> getAssociatedPolicies() {
                HashSet<Policy> associatedPolicies = new HashSet<Policy>();
                for (String id : cached.getAssociatedPoliciesIds()) {
                    Policy cached2 = CachedPolicyStore.this.findById(id);
                    if (cached2 == null) continue;
                    associatedPolicies.add(cached2);
                }
                return associatedPolicies;
            }

            public Set<Resource> getResources() {
                HashSet<Resource> resources = new HashSet<Resource>();
                for (String id : cached.getResourcesIds()) {
                    Resource cached2 = CachedPolicyStore.this.getStoreFactory().getResourceStore().findById(id);
                    if (cached2 == null) continue;
                    resources.add(cached2);
                }
                return resources;
            }

            public Set<Scope> getScopes() {
                HashSet<Scope> scopes = new HashSet<Scope>();
                for (String id : cached.getScopesIds()) {
                    Scope cached2 = CachedPolicyStore.this.getStoreFactory().getScopeStore().findById(id);
                    if (cached2 == null) continue;
                    scopes.add(cached2);
                }
                return scopes;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (this.getId() == null) {
                    return false;
                }
                if (!Policy.class.isInstance(o)) {
                    return false;
                }
                Policy that = (Policy)o;
                return this.getId().equals(that.getId());
            }

            public int hashCode() {
                return this.getId() != null ? this.getId().hashCode() : super.hashCode();
            }

            private Policy getDelegateForUpdate() {
                if (this.updated == null) {
                    this.updated = CachedPolicyStore.this.getDelegate().findById(this.getId());
                    if (this.updated == null) {
                        throw new IllegalStateException("Not found in database");
                    }
                    CachedPolicyStore.this.transaction.whenCommit(() -> CachedPolicyStore.this.cache.evict((Object)CachedPolicyStore.this.getCacheKeyForPolicy(this.getId())));
                }
                return this.updated;
            }
        };
    }

    private CachedPolicy updatePolicyCache(Policy policy) {
        CachedPolicy cached = new CachedPolicy(policy);
        ArrayList<CachedPolicy> cache = new ArrayList<CachedPolicy>();
        cache.add(cached);
        this.cache.put((Object)this.getCacheKeyForPolicy(policy.getId()), cache);
        return cached;
    }
}

