/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.infinispan.notifications.cachelistener.annotation.CacheEntriesEvicted;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryInvalidated;
import org.infinispan.notifications.cachelistener.event.CacheEntriesEvictedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryInvalidatedEvent;
import org.jboss.logging.Logger;
import org.keycloak.models.cache.infinispan.RealmCacheManager;
import org.keycloak.models.cache.infinispan.UpdateCounter;
import org.keycloak.models.cache.infinispan.entities.AbstractRevisioned;
import org.keycloak.models.cache.infinispan.entities.Revisioned;

public abstract class CacheManager {
    protected static final Logger logger = Logger.getLogger(CacheManager.class);
    protected final Cache<String, Long> revisions;
    protected final Cache<String, Revisioned> cache;
    protected final UpdateCounter counter = new UpdateCounter();

    public CacheManager(Cache<String, Revisioned> cache, Cache<String, Long> revisions) {
        this.cache = cache;
        this.revisions = revisions;
        this.cache.addListener((Object)this);
    }

    public Cache<String, Revisioned> getCache() {
        return this.cache;
    }

    public long getCurrentCounter() {
        return this.counter.current();
    }

    public Long getCurrentRevision(String id) {
        Long revision = (Long)this.revisions.get((Object)id);
        if (revision == null) {
            revision = this.counter.current();
        }
        String invalidationKey = "invalidation.key" + id;
        this.cache.putForExternalRead((Object)invalidationKey, (Object)new AbstractRevisioned(-1L, invalidationKey));
        return revision;
    }

    public void endRevisionBatch() {
        try {
            this.revisions.endBatch(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public <T> T get(String id, Class<T> type) {
        long oRev;
        Revisioned o = (Revisioned)this.cache.get((Object)id);
        if (o == null) {
            return null;
        }
        Long rev = (Long)this.revisions.get((Object)id);
        if (rev == null) {
            RealmCacheManager.logger.tracev("get() missing rev", new Object[0]);
            return null;
        }
        long l = oRev = o.getRevision() == null ? -1L : o.getRevision();
        if (rev > oRev) {
            RealmCacheManager.logger.tracev("get() rev: {0} o.rev: {1}", (Object)rev, (Object)oRev);
            return null;
        }
        return o != null && type.isInstance(o) ? (T)type.cast(o) : null;
    }

    public Object invalidateObject(String id) {
        Revisioned removed = (Revisioned)this.cache.remove((Object)id);
        this.cache.remove((Object)("invalidation.key" + id));
        this.bumpVersion(id);
        return removed;
    }

    protected void bumpVersion(String id) {
        long next = this.counter.next();
        Object rev = this.revisions.put((Object)id, (Object)next);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRevisioned(Revisioned object, long startupRevision) {
        String id = object.getId();
        try {
            Long rev = (Long)this.revisions.get((Object)id);
            if (rev == null) {
                if (id.endsWith("realm.clients")) {
                    RealmCacheManager.logger.trace((Object)"addRevisioned rev == null realm.clients");
                }
                rev = this.counter.current();
                this.revisions.put((Object)id, (Object)rev);
            }
            this.revisions.startBatch();
            if (!this.revisions.getAdvancedCache().lock((Object[])new String[]{id})) {
                RealmCacheManager.logger.trace((Object)"Could not obtain version lock");
                return;
            }
            rev = (Long)this.revisions.get((Object)id);
            if (rev == null) {
                if (id.endsWith("realm.clients")) {
                    RealmCacheManager.logger.trace((Object)"addRevisioned rev2 == null realm.clients");
                }
                return;
            }
            if (rev > startupRevision) {
                if (RealmCacheManager.logger.isTraceEnabled()) {
                    RealmCacheManager.logger.tracev("Skipped cache. Current revision {0}, Transaction start revision {1}", (Object)object.getRevision(), (Object)startupRevision);
                }
                return;
            }
            if (rev.equals(object.getRevision())) {
                if (id.endsWith("realm.clients")) {
                    RealmCacheManager.logger.tracev("adding Object.revision {0} rev {1}", (Object)object.getRevision(), (Object)rev);
                }
                this.cache.putForExternalRead((Object)id, (Object)object);
                return;
            }
            if (rev > object.getRevision()) {
                if (id.endsWith("realm.clients")) {
                    RealmCacheManager.logger.trace((Object)"addRevisioned revision is ahead realm.clients");
                }
                return;
            }
            if (id.endsWith("realm.clients")) {
                RealmCacheManager.logger.tracev("adding Object.revision {0} rev {1}", (Object)object.getRevision(), (Object)rev);
            }
            this.revisions.put((Object)id, (Object)object.getRevision());
            this.cache.putForExternalRead((Object)id, (Object)object);
        }
        finally {
            this.endRevisionBatch();
        }
    }

    public void clear() {
        this.cache.clear();
        this.revisions.clear();
    }

    public void addInvalidations(Predicate<Map.Entry<String, Revisioned>> predicate, Set<String> invalidations) {
        Iterator<Map.Entry<String, Revisioned>> it = this.getEntryIterator(predicate);
        while (it.hasNext()) {
            invalidations.add(it.next().getKey());
        }
    }

    private Iterator<Map.Entry<String, Revisioned>> getEntryIterator(Predicate<Map.Entry<String, Revisioned>> predicate) {
        return this.cache.entrySet().stream().filter(predicate).iterator();
    }

    @CacheEntryInvalidated
    public void cacheInvalidated(CacheEntryInvalidatedEvent<String, Object> event) {
        if (event.isPre()) {
            String key = (String)event.getKey();
            if (key.startsWith("invalidation.key")) {
                String bump = key.substring("invalidation.key".length());
                RealmCacheManager.logger.tracev("bumping invalidation key {0}", (Object)bump);
                this.bumpVersion(bump);
                return;
            }
        } else {
            String key = (String)event.getKey();
            if (key.startsWith("invalidation.key")) {
                String bump = key.substring("invalidation.key".length());
                this.bumpVersion(bump);
                RealmCacheManager.logger.tracev("bumping invalidation key {0}", (Object)bump);
                return;
            }
            this.bumpVersion(key);
            Object object = event.getValue();
            if (object != null) {
                this.bumpVersion(key);
                Predicate<Map.Entry<String, Revisioned>> predicate = this.getInvalidationPredicate(object);
                if (predicate != null) {
                    this.runEvictions(predicate);
                }
                RealmCacheManager.logger.tracev("invalidating: {0}" + object.getClass().getName(), new Object[0]);
            }
        }
    }

    @CacheEntriesEvicted
    public void cacheEvicted(CacheEntriesEvictedEvent<String, Object> event) {
        if (!event.isPre()) {
            for (Map.Entry entry : event.getEntries().entrySet()) {
                Object object = entry.getValue();
                this.bumpVersion((String)entry.getKey());
                if (object == null) continue;
                RealmCacheManager.logger.tracev("evicting: {0}" + object.getClass().getName(), new Object[0]);
                Predicate<Map.Entry<String, Revisioned>> predicate = this.getInvalidationPredicate(object);
                if (predicate == null) continue;
                this.runEvictions(predicate);
            }
        }
    }

    public void runEvictions(Predicate<Map.Entry<String, Revisioned>> current) {
        HashSet<String> evictions = new HashSet<String>();
        this.addInvalidations(current, evictions);
        RealmCacheManager.logger.tracev("running evictions size: {0}", (Object)evictions.size());
        for (String key : evictions) {
            this.cache.evict((Object)key);
            this.bumpVersion(key);
        }
    }

    protected abstract Predicate<Map.Entry<String, Revisioned>> getInvalidationPredicate(Object var1);
}

