/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.cluster.infinispan;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterListener;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.cluster.ClusterProviderFactory;
import org.keycloak.cluster.infinispan.InfinispanClusterProvider;
import org.keycloak.cluster.infinispan.LockEntry;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;

public class InfinispanClusterProviderFactory
implements ClusterProviderFactory {
    public static final String PROVIDER_ID = "infinispan";
    protected static final Logger logger = Logger.getLogger(InfinispanClusterProviderFactory.class);
    private volatile Cache<String, Serializable> workCache;
    private Map<String, ClusterListener> listeners = new HashMap<String, ClusterListener>();

    public ClusterProvider create(KeycloakSession session) {
        this.lazyInit(session);
        return new InfinispanClusterProvider(this, session, this.workCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit(KeycloakSession session) {
        if (this.workCache == null) {
            InfinispanClusterProviderFactory infinispanClusterProviderFactory = this;
            synchronized (infinispanClusterProviderFactory) {
                if (this.workCache == null) {
                    this.workCache = ((InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class)).getCache("work");
                    this.workCache.getCacheManager().addListener((Object)new ViewChangeListener());
                    this.workCache.addListener((Object)new CacheEntryListener());
                }
            }
        }
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    <T> void registerListener(String taskKey, ClusterListener task) {
        this.listeners.put(taskKey, task);
    }

    @Listener
    public class CacheEntryListener {
        @CacheEntryCreated
        public void cacheEntryCreated(CacheEntryCreatedEvent<String, Object> event) {
            if (!event.isPre()) {
                this.trigger((String)event.getKey(), event.getValue());
            }
        }

        @CacheEntryModified
        public void cacheEntryModified(CacheEntryModifiedEvent<String, Object> event) {
            if (!event.isPre()) {
                this.trigger((String)event.getKey(), event.getValue());
            }
        }

        private void trigger(String key, Object value) {
            ClusterListener task = (ClusterListener)InfinispanClusterProviderFactory.this.listeners.get(key);
            if (task != null) {
                ClusterEvent event = (ClusterEvent)value;
                task.run(event);
            }
        }
    }

    @Listener
    public class ViewChangeListener {
        @ViewChanged
        public void viewChanged(ViewChangedEvent event) {
            EmbeddedCacheManager cacheManager = event.getCacheManager();
            Transport transport = cacheManager.getTransport();
            if (transport != null && transport.isCoordinator()) {
                Set<String> newAddresses = this.convertAddresses(event.getNewMembers());
                final Set<String> removedNodesAddresses = this.convertAddresses(event.getOldMembers());
                removedNodesAddresses.removeAll(newAddresses);
                if (removedNodesAddresses.isEmpty()) {
                    return;
                }
                logger.debugf("Nodes %s removed from cluster. Removing tasks locked by this nodes", (Object)removedNodesAddresses.toString());
                Cache cache = cacheManager.getCache("work");
                Iterator toRemove = cache.entrySet().stream().filter((Predicate)new Predicate<Map.Entry<String, Serializable>>(){

                    @Override
                    public boolean test(Map.Entry<String, Serializable> entry) {
                        if (!(entry.getValue() instanceof LockEntry)) {
                            return false;
                        }
                        LockEntry lock = (LockEntry)entry.getValue();
                        return removedNodesAddresses.contains(lock.getNode());
                    }
                }).map(new Function<Map.Entry<String, Serializable>, String>(){

                    @Override
                    public String apply(Map.Entry<String, Serializable> entry) {
                        return entry.getKey();
                    }
                }).iterator();
                while (toRemove.hasNext()) {
                    String rem = (String)toRemove.next();
                    if (logger.isTraceEnabled()) {
                        logger.tracef("Removing task %s due it's node left cluster", (Object)rem);
                    }
                    cache.remove((Object)rem);
                }
            }
        }

        private Set<String> convertAddresses(Collection<Address> addresses) {
            return addresses.stream().map(new Function<Address, String>(){

                @Override
                public String apply(Address address) {
                    return address.toString();
                }
            }).collect(Collectors.toSet());
        }
    }
}

