/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.cluster.infinispan;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryModified;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryCreatedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryModifiedEvent;
import org.infinispan.context.Flag;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.persistence.remote.RemoteStore;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterListener;
import org.keycloak.cluster.infinispan.WrapperClusterEvent;
import org.keycloak.common.util.MultivaluedHashMap;

public class InfinispanNotificationsManager {
    protected static final Logger logger = Logger.getLogger(InfinispanNotificationsManager.class);
    private final MultivaluedHashMap<String, ClusterListener> listeners = new MultivaluedHashMap();
    private final Cache<String, Serializable> workCache;
    private final String myAddress;

    protected InfinispanNotificationsManager(Cache<String, Serializable> workCache, String myAddress) {
        this.workCache = workCache;
        this.myAddress = myAddress;
    }

    public static InfinispanNotificationsManager create(Cache<String, Serializable> workCache, String myAddress, Set<RemoteStore> remoteStores) {
        InfinispanNotificationsManager manager = new InfinispanNotificationsManager(workCache, myAddress);
        if (remoteStores.isEmpty()) {
            workCache.addListener((Object)manager.new CacheEntryListener());
            logger.debugf("Added listener for infinispan cache: %s", (Object)workCache.getName());
        } else {
            for (RemoteStore remoteStore : remoteStores) {
                RemoteCache remoteCache = remoteStore.getRemoteCache();
                InfinispanNotificationsManager infinispanNotificationsManager = manager;
                infinispanNotificationsManager.getClass();
                remoteCache.addClientListener((Object)infinispanNotificationsManager.new HotRodListener((RemoteCache<Object, Object>)remoteCache));
                logger.debugf("Added listener for HotRod remoteStore cache: %s", (Object)remoteCache.getName());
            }
        }
        return manager;
    }

    void registerListener(String taskKey, ClusterListener task) {
        this.listeners.add((Object)taskKey, (Object)task);
    }

    void notify(String taskKey, ClusterEvent event, boolean ignoreSender) {
        WrapperClusterEvent wrappedEvent = new WrapperClusterEvent();
        wrappedEvent.setDelegateEvent(event);
        wrappedEvent.setIgnoreSender(ignoreSender);
        wrappedEvent.setSender(this.myAddress);
        if (logger.isTraceEnabled()) {
            logger.tracef("Sending event %s: %s", (Object)taskKey, (Object)event);
        }
        this.workCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)taskKey, (Object)wrappedEvent, 120L, TimeUnit.SECONDS);
    }

    private void eventReceived(String key, Serializable obj) {
        if (!(obj instanceof WrapperClusterEvent)) {
            return;
        }
        WrapperClusterEvent event = (WrapperClusterEvent)((Object)obj);
        if (event.isIgnoreSender() && this.myAddress.equals(event.getSender())) {
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.tracef("Received event %s: %s", (Object)key, (Object)event);
        }
        ClusterEvent wrappedEvent = event.getDelegateEvent();
        List myListeners = (List)this.listeners.get((Object)key);
        if (myListeners != null) {
            for (ClusterListener listener : myListeners) {
                listener.eventReceived(wrappedEvent);
            }
        }
        if ((myListeners = (List)this.listeners.get((Object)"ALL")) != null) {
            for (ClusterListener listener : myListeners) {
                listener.eventReceived(wrappedEvent);
            }
        }
    }

    @ClientListener
    public class HotRodListener {
        private final RemoteCache<Object, Object> remoteCache;

        public HotRodListener(RemoteCache<Object, Object> remoteCache) {
            this.remoteCache = remoteCache;
        }

        @ClientCacheEntryCreated
        public void created(ClientCacheEntryCreatedEvent event) {
            String key = event.getKey().toString();
            this.hotrodEventReceived(key);
        }

        @ClientCacheEntryModified
        public void updated(ClientCacheEntryModifiedEvent event) {
            String key = event.getKey().toString();
            this.hotrodEventReceived(key);
        }

        private void hotrodEventReceived(String key) {
            Serializable rawValue;
            Object value = this.remoteCache.get((Object)key);
            if (value instanceof MarshalledEntry) {
                Object rw = ((MarshalledEntry)value).getValue();
                rawValue = (Serializable)rw;
            } else {
                rawValue = (Serializable)value;
            }
            InfinispanNotificationsManager.this.eventReceived(key, rawValue);
        }
    }

    @Listener(observation=Listener.Observation.POST)
    public class CacheEntryListener {
        @CacheEntryCreated
        public void cacheEntryCreated(CacheEntryCreatedEvent<String, Serializable> event) {
            InfinispanNotificationsManager.this.eventReceived((String)event.getKey(), (Serializable)event.getValue());
        }

        @CacheEntryModified
        public void cacheEntryModified(CacheEntryModifiedEvent<String, Serializable> event) {
            InfinispanNotificationsManager.this.eventReceived((String)event.getKey(), (Serializable)event.getValue());
        }
    }
}

