/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.util.Set;
import org.keycloak.models.cache.infinispan.RealmCacheManager;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.RealmCacheInvalidationEvent;

public class ClientUpdatedEvent
extends InvalidationEvent
implements RealmCacheInvalidationEvent {
    private String clientUuid;
    private String clientId;
    private String realmId;

    public static ClientUpdatedEvent create(String clientUuid, String clientId, String realmId) {
        ClientUpdatedEvent event = new ClientUpdatedEvent();
        event.clientUuid = clientUuid;
        event.clientId = clientId;
        event.realmId = realmId;
        return event;
    }

    @Override
    public String getId() {
        return this.clientUuid;
    }

    public String toString() {
        return String.format("ClientUpdatedEvent [ realmId=%s, clientUuid=%s, clientId=%s ]", this.realmId, this.clientUuid, this.clientId);
    }

    @Override
    public void addInvalidations(RealmCacheManager realmCache, Set<String> invalidations) {
        realmCache.clientUpdated(this.realmId, this.clientUuid, this.clientId, invalidations);
    }
}

