/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.authorization.infinispan;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.Cache;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.authorization.infinispan.InfinispanStoreFactoryProvider;
import org.keycloak.models.authorization.infinispan.entities.CachedResourceServer;
import org.keycloak.representations.idm.authorization.PolicyEnforcementMode;

public class CachedResourceServerStore
implements ResourceServerStore {
    private static final String RS_ID_CACHE_PREFIX = "rs-id-";
    private static final String RS_CLIENT_ID_CACHE_PREFIX = "rs-client-id-";
    private final KeycloakSession session;
    private final InfinispanStoreFactoryProvider.CacheTransaction transaction;
    private StoreFactory storeFactory;
    private ResourceServerStore delegate;
    private final Cache<String, Map<String, List<CachedResourceServer>>> cache;

    public CachedResourceServerStore(KeycloakSession session, InfinispanStoreFactoryProvider.CacheTransaction transaction, StoreFactory storeFactory) {
        this.session = session;
        this.transaction = transaction;
        InfinispanConnectionProvider provider = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        this.cache = provider.getCache("authorization");
        this.storeFactory = storeFactory;
    }

    public ResourceServer create(String clientId) {
        ResourceServer resourceServer = this.getDelegate().create(clientId);
        this.transaction.whenRollback(() -> this.resolveResourceServerCache(resourceServer.getId()).remove(this.getCacheKeyForResourceServer(resourceServer.getId())));
        return this.createAdapter(new CachedResourceServer(resourceServer));
    }

    public void delete(String id) {
        ResourceServer resourceServer = this.getDelegate().findById(id);
        this.getDelegate().delete(id);
        this.transaction.whenCommit(() -> {
            this.cache.remove((Object)id);
            this.cache.remove((Object)resourceServer.getClientId());
        });
    }

    public ResourceServer findById(String id) {
        String cacheKeyForResourceServer = this.getCacheKeyForResourceServer(id);
        List<CachedResourceServer> cached = this.resolveResourceServerCache(id).get(cacheKeyForResourceServer);
        if (cached == null) {
            ResourceServer resourceServer = this.getDelegate().findById(id);
            if (resourceServer != null) {
                CachedResourceServer cachedResourceServer = new CachedResourceServer(resourceServer);
                this.resolveResourceServerCache(id).put(cacheKeyForResourceServer, Arrays.asList(cachedResourceServer));
                return this.createAdapter(cachedResourceServer);
            }
            return null;
        }
        return this.createAdapter(cached.get(0));
    }

    public ResourceServer findByClient(String id) {
        String cacheKeyForResourceServer = this.getCacheKeyForResourceServerClientId(id);
        List<CachedResourceServer> cached = this.resolveResourceServerCache(id).get(cacheKeyForResourceServer);
        if (cached == null) {
            ResourceServer resourceServer = this.getDelegate().findByClient(id);
            if (resourceServer != null) {
                this.resolveResourceServerCache(cacheKeyForResourceServer).put(cacheKeyForResourceServer, Arrays.asList(new CachedResourceServer(resourceServer)));
                return this.findById(resourceServer.getId());
            }
            return null;
        }
        return this.createAdapter(cached.get(0));
    }

    private String getCacheKeyForResourceServer(String id) {
        return RS_ID_CACHE_PREFIX + id;
    }

    private String getCacheKeyForResourceServerClientId(String id) {
        return RS_CLIENT_ID_CACHE_PREFIX + id;
    }

    private ResourceServerStore getDelegate() {
        if (this.delegate == null) {
            this.delegate = this.getStoreFactory().getResourceServerStore();
        }
        return this.delegate;
    }

    private StoreFactory getStoreFactory() {
        return this.storeFactory;
    }

    private ResourceServer createAdapter(final ResourceServer cached) {
        return new ResourceServer(){
            private ResourceServer updated;

            public String getId() {
                return cached.getId();
            }

            public String getClientId() {
                return cached.getClientId();
            }

            public boolean isAllowRemoteResourceManagement() {
                return cached.isAllowRemoteResourceManagement();
            }

            public void setAllowRemoteResourceManagement(boolean allowRemoteResourceManagement) {
                this.getDelegateForUpdate().setAllowRemoteResourceManagement(allowRemoteResourceManagement);
                cached.setAllowRemoteResourceManagement(allowRemoteResourceManagement);
            }

            public PolicyEnforcementMode getPolicyEnforcementMode() {
                return cached.getPolicyEnforcementMode();
            }

            public void setPolicyEnforcementMode(PolicyEnforcementMode enforcementMode) {
                this.getDelegateForUpdate().setPolicyEnforcementMode(enforcementMode);
                cached.setPolicyEnforcementMode(enforcementMode);
            }

            private ResourceServer getDelegateForUpdate() {
                if (this.updated == null) {
                    this.updated = CachedResourceServerStore.this.getDelegate().findById(this.getId());
                    if (this.updated == null) {
                        throw new IllegalStateException("Not found in database");
                    }
                    CachedResourceServerStore.this.transaction.whenCommit(() -> {
                        CachedResourceServerStore.this.cache.remove((Object)this.getId());
                        CachedResourceServerStore.this.cache.remove((Object)this.getClientId());
                    });
                }
                return this.updated;
            }
        };
    }

    private Map<String, List<CachedResourceServer>> resolveResourceServerCache(String id) {
        return (Map)this.cache.computeIfAbsent((Object)id, key -> new HashMap());
    }
}

