/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.keycloak.Config;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.CibaConfig;
import org.keycloak.models.ClientInitialAccessModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OAuth2DeviceConfig;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.ParConfig;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.WebAuthnPolicy;
import org.keycloak.models.cache.CachedRealmModel;
import org.keycloak.models.cache.UserCache;
import org.keycloak.models.cache.infinispan.RealmCacheSession;
import org.keycloak.models.cache.infinispan.entities.CachedRealm;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageUtil;
import org.keycloak.storage.client.ClientStorageProvider;

public class RealmAdapter
implements CachedRealmModel {
    protected CachedRealm cached;
    protected RealmCacheSession cacheSession;
    protected volatile RealmModel updated;
    protected KeycloakSession session;
    private final Supplier<RealmModel> modelSupplier;
    protected volatile boolean invalidated;

    public RealmAdapter(KeycloakSession session, CachedRealm cached, RealmCacheSession cacheSession) {
        this.cached = cached;
        this.cacheSession = cacheSession;
        this.session = session;
        this.modelSupplier = this::getRealm;
    }

    public RealmModel getDelegateForUpdate() {
        if (this.updated == null) {
            this.cacheSession.registerRealmInvalidation(this.cached.getId(), this.cached.getName());
            this.updated = this.modelSupplier.get();
            if (this.updated == null) {
                throw new IllegalStateException("Not found in database");
            }
        }
        return this.updated;
    }

    protected void invalidateFlag() {
        this.invalidated = true;
    }

    public void invalidate() {
        this.invalidated = true;
        this.getDelegateForUpdate();
    }

    public long getCacheTimestamp() {
        return this.cached.getCacheTimestamp();
    }

    public ConcurrentHashMap getCachedWith() {
        return this.cached.getCachedWith();
    }

    protected boolean isUpdated() {
        if (this.updated != null) {
            return true;
        }
        if (!this.invalidated) {
            return false;
        }
        this.updated = this.cacheSession.getRealmDelegate().getRealm(this.cached.getId());
        if (this.updated == null) {
            throw new IllegalStateException("Not found in database");
        }
        return true;
    }

    public String getId() {
        if (this.isUpdated()) {
            return this.updated.getId();
        }
        return this.cached.getId();
    }

    public String getName() {
        if (this.isUpdated()) {
            return this.updated.getName();
        }
        return this.cached.getName();
    }

    public void setName(String name) {
        this.getDelegateForUpdate();
        this.updated.setName(name);
    }

    public String getDisplayName() {
        if (this.isUpdated()) {
            return this.updated.getDisplayName();
        }
        return this.cached.getDisplayName();
    }

    public void setDisplayName(String displayName) {
        this.getDelegateForUpdate();
        this.updated.setDisplayName(displayName);
    }

    public String getDisplayNameHtml() {
        if (this.isUpdated()) {
            return this.updated.getDisplayNameHtml();
        }
        return this.cached.getDisplayNameHtml();
    }

    public void setDisplayNameHtml(String displayNameHtml) {
        this.getDelegateForUpdate();
        this.updated.setDisplayNameHtml(displayNameHtml);
    }

    public boolean isEnabled() {
        if (this.isUpdated()) {
            return this.updated.isEnabled();
        }
        return this.cached.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.getDelegateForUpdate();
        this.updated.setEnabled(enabled);
    }

    public boolean isUserManagedAccessAllowed() {
        if (this.isUpdated()) {
            return this.updated.isEnabled();
        }
        return this.cached.isAllowUserManagedAccess();
    }

    public void setUserManagedAccessAllowed(boolean userManagedAccessAllowed) {
        this.getDelegateForUpdate();
        this.updated.setUserManagedAccessAllowed(userManagedAccessAllowed);
    }

    public SslRequired getSslRequired() {
        if (this.isUpdated()) {
            return this.updated.getSslRequired();
        }
        return this.cached.getSslRequired();
    }

    public void setSslRequired(SslRequired sslRequired) {
        this.getDelegateForUpdate();
        this.updated.setSslRequired(sslRequired);
    }

    public boolean isRegistrationAllowed() {
        if (this.isUpdated()) {
            return this.updated.isRegistrationAllowed();
        }
        return this.cached.isRegistrationAllowed();
    }

    public void setRegistrationAllowed(boolean registrationAllowed) {
        this.getDelegateForUpdate();
        this.updated.setRegistrationAllowed(registrationAllowed);
    }

    public boolean isRegistrationEmailAsUsername() {
        if (this.isUpdated()) {
            return this.updated.isRegistrationEmailAsUsername();
        }
        return this.cached.isRegistrationEmailAsUsername();
    }

    public void setRegistrationEmailAsUsername(boolean registrationEmailAsUsername) {
        this.getDelegateForUpdate();
        this.updated.setRegistrationEmailAsUsername(registrationEmailAsUsername);
    }

    public boolean isRememberMe() {
        if (this.isUpdated()) {
            return this.updated.isRememberMe();
        }
        return this.cached.isRememberMe();
    }

    public void setRememberMe(boolean rememberMe) {
        this.getDelegateForUpdate();
        this.updated.setRememberMe(rememberMe);
    }

    public String getDefaultSignatureAlgorithm() {
        if (this.isUpdated()) {
            return this.updated.getDefaultSignatureAlgorithm();
        }
        return this.cached.getDefaultSignatureAlgorithm();
    }

    public void setDefaultSignatureAlgorithm(String defaultSignatureAlgorithm) {
        this.getDelegateForUpdate();
        this.updated.setDefaultSignatureAlgorithm(defaultSignatureAlgorithm);
    }

    public boolean isBruteForceProtected() {
        if (this.isUpdated()) {
            return this.updated.isBruteForceProtected();
        }
        return this.cached.isBruteForceProtected();
    }

    public void setBruteForceProtected(boolean value) {
        this.getDelegateForUpdate();
        this.updated.setBruteForceProtected(value);
    }

    public boolean isPermanentLockout() {
        if (this.isUpdated()) {
            return this.updated.isPermanentLockout();
        }
        return this.cached.isPermanentLockout();
    }

    public void setPermanentLockout(boolean val) {
        this.getDelegateForUpdate();
        this.updated.setPermanentLockout(val);
    }

    public int getMaxFailureWaitSeconds() {
        if (this.isUpdated()) {
            return this.updated.getMaxFailureWaitSeconds();
        }
        return this.cached.getMaxFailureWaitSeconds();
    }

    public void setMaxFailureWaitSeconds(int val) {
        this.getDelegateForUpdate();
        this.updated.setMaxFailureWaitSeconds(val);
    }

    public int getWaitIncrementSeconds() {
        if (this.isUpdated()) {
            return this.updated.getWaitIncrementSeconds();
        }
        return this.cached.getWaitIncrementSeconds();
    }

    public void setWaitIncrementSeconds(int val) {
        this.getDelegateForUpdate();
        this.updated.setWaitIncrementSeconds(val);
    }

    public int getMinimumQuickLoginWaitSeconds() {
        if (this.isUpdated()) {
            return this.updated.getMinimumQuickLoginWaitSeconds();
        }
        return this.cached.getMinimumQuickLoginWaitSeconds();
    }

    public void setMinimumQuickLoginWaitSeconds(int val) {
        this.getDelegateForUpdate();
        this.updated.setMinimumQuickLoginWaitSeconds(val);
    }

    public long getQuickLoginCheckMilliSeconds() {
        if (this.isUpdated()) {
            return this.updated.getQuickLoginCheckMilliSeconds();
        }
        return this.cached.getQuickLoginCheckMilliSeconds();
    }

    public void setQuickLoginCheckMilliSeconds(long val) {
        this.getDelegateForUpdate();
        this.updated.setQuickLoginCheckMilliSeconds(val);
    }

    public int getMaxDeltaTimeSeconds() {
        if (this.isUpdated()) {
            return this.updated.getMaxDeltaTimeSeconds();
        }
        return this.cached.getMaxDeltaTimeSeconds();
    }

    public void setMaxDeltaTimeSeconds(int val) {
        this.getDelegateForUpdate();
        this.updated.setMaxDeltaTimeSeconds(val);
    }

    public int getFailureFactor() {
        if (this.isUpdated()) {
            return this.updated.getFailureFactor();
        }
        return this.cached.getFailureFactor();
    }

    public void setFailureFactor(int failureFactor) {
        this.getDelegateForUpdate();
        this.updated.setFailureFactor(failureFactor);
    }

    public boolean isVerifyEmail() {
        if (this.isUpdated()) {
            return this.updated.isVerifyEmail();
        }
        return this.cached.isVerifyEmail();
    }

    public void setVerifyEmail(boolean verifyEmail) {
        this.getDelegateForUpdate();
        this.updated.setVerifyEmail(verifyEmail);
    }

    public boolean isLoginWithEmailAllowed() {
        if (this.isUpdated()) {
            return this.updated.isLoginWithEmailAllowed();
        }
        return this.cached.isLoginWithEmailAllowed();
    }

    public void setLoginWithEmailAllowed(boolean loginWithEmailAllowed) {
        this.getDelegateForUpdate();
        this.updated.setLoginWithEmailAllowed(loginWithEmailAllowed);
    }

    public boolean isDuplicateEmailsAllowed() {
        if (this.isUpdated()) {
            return this.updated.isDuplicateEmailsAllowed();
        }
        return this.cached.isDuplicateEmailsAllowed();
    }

    public void setDuplicateEmailsAllowed(boolean duplicateEmailsAllowed) {
        this.getDelegateForUpdate();
        this.updated.setDuplicateEmailsAllowed(duplicateEmailsAllowed);
    }

    public boolean isResetPasswordAllowed() {
        if (this.isUpdated()) {
            return this.updated.isResetPasswordAllowed();
        }
        return this.cached.isResetPasswordAllowed();
    }

    public void setResetPasswordAllowed(boolean resetPasswordAllowed) {
        this.getDelegateForUpdate();
        this.updated.setResetPasswordAllowed(resetPasswordAllowed);
    }

    public boolean isEditUsernameAllowed() {
        if (this.isUpdated()) {
            return this.updated.isEditUsernameAllowed();
        }
        return this.cached.isEditUsernameAllowed();
    }

    public void setEditUsernameAllowed(boolean editUsernameAllowed) {
        this.getDelegateForUpdate();
        this.updated.setEditUsernameAllowed(editUsernameAllowed);
    }

    public boolean isRevokeRefreshToken() {
        if (this.isUpdated()) {
            return this.updated.isRevokeRefreshToken();
        }
        return this.cached.isRevokeRefreshToken();
    }

    public void setRevokeRefreshToken(boolean revokeRefreshToken) {
        this.getDelegateForUpdate();
        this.updated.setRevokeRefreshToken(revokeRefreshToken);
    }

    public int getRefreshTokenMaxReuse() {
        if (this.isUpdated()) {
            return this.updated.getRefreshTokenMaxReuse();
        }
        return this.cached.getRefreshTokenMaxReuse();
    }

    public void setRefreshTokenMaxReuse(int refreshTokenMaxReuse) {
        this.getDelegateForUpdate();
        this.updated.setRefreshTokenMaxReuse(refreshTokenMaxReuse);
    }

    public int getSsoSessionIdleTimeout() {
        if (this.isUpdated()) {
            return this.updated.getSsoSessionIdleTimeout();
        }
        return this.cached.getSsoSessionIdleTimeout();
    }

    public void setSsoSessionIdleTimeout(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setSsoSessionIdleTimeout(seconds);
    }

    public int getSsoSessionMaxLifespan() {
        if (this.isUpdated()) {
            return this.updated.getSsoSessionMaxLifespan();
        }
        return this.cached.getSsoSessionMaxLifespan();
    }

    public void setSsoSessionMaxLifespan(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setSsoSessionMaxLifespan(seconds);
    }

    public int getSsoSessionIdleTimeoutRememberMe() {
        if (this.updated != null) {
            return this.updated.getSsoSessionIdleTimeoutRememberMe();
        }
        return this.cached.getSsoSessionIdleTimeoutRememberMe();
    }

    public void setSsoSessionIdleTimeoutRememberMe(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setSsoSessionIdleTimeoutRememberMe(seconds);
    }

    public int getSsoSessionMaxLifespanRememberMe() {
        if (this.updated != null) {
            return this.updated.getSsoSessionMaxLifespanRememberMe();
        }
        return this.cached.getSsoSessionMaxLifespanRememberMe();
    }

    public void setSsoSessionMaxLifespanRememberMe(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setSsoSessionMaxLifespanRememberMe(seconds);
    }

    public int getOfflineSessionIdleTimeout() {
        if (this.isUpdated()) {
            return this.updated.getOfflineSessionIdleTimeout();
        }
        return this.cached.getOfflineSessionIdleTimeout();
    }

    public void setOfflineSessionIdleTimeout(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setOfflineSessionIdleTimeout(seconds);
    }

    public boolean isOfflineSessionMaxLifespanEnabled() {
        if (this.isUpdated()) {
            return this.updated.isOfflineSessionMaxLifespanEnabled();
        }
        return this.cached.isOfflineSessionMaxLifespanEnabled();
    }

    public void setOfflineSessionMaxLifespanEnabled(boolean offlineSessionMaxLifespanEnabled) {
        this.getDelegateForUpdate();
        this.updated.setOfflineSessionMaxLifespanEnabled(offlineSessionMaxLifespanEnabled);
    }

    public int getOfflineSessionMaxLifespan() {
        if (this.isUpdated()) {
            return this.updated.getOfflineSessionMaxLifespan();
        }
        return this.cached.getOfflineSessionMaxLifespan();
    }

    public void setOfflineSessionMaxLifespan(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setOfflineSessionMaxLifespan(seconds);
    }

    public int getClientSessionIdleTimeout() {
        if (this.isUpdated()) {
            return this.updated.getClientSessionIdleTimeout();
        }
        return this.cached.getClientSessionIdleTimeout();
    }

    public void setClientSessionIdleTimeout(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setClientSessionIdleTimeout(seconds);
    }

    public int getClientSessionMaxLifespan() {
        if (this.isUpdated()) {
            return this.updated.getClientSessionMaxLifespan();
        }
        return this.cached.getClientSessionMaxLifespan();
    }

    public void setClientSessionMaxLifespan(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setClientSessionMaxLifespan(seconds);
    }

    public int getClientOfflineSessionIdleTimeout() {
        if (this.isUpdated()) {
            return this.updated.getClientOfflineSessionIdleTimeout();
        }
        return this.cached.getClientOfflineSessionIdleTimeout();
    }

    public void setClientOfflineSessionIdleTimeout(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setClientOfflineSessionIdleTimeout(seconds);
    }

    public int getClientOfflineSessionMaxLifespan() {
        if (this.isUpdated()) {
            return this.updated.getClientOfflineSessionMaxLifespan();
        }
        return this.cached.getClientOfflineSessionMaxLifespan();
    }

    public void setClientOfflineSessionMaxLifespan(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setClientOfflineSessionMaxLifespan(seconds);
    }

    public int getAccessTokenLifespan() {
        if (this.isUpdated()) {
            return this.updated.getAccessTokenLifespan();
        }
        return this.cached.getAccessTokenLifespan();
    }

    public void setAccessTokenLifespan(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setAccessTokenLifespan(seconds);
    }

    public int getAccessTokenLifespanForImplicitFlow() {
        if (this.isUpdated()) {
            return this.updated.getAccessTokenLifespanForImplicitFlow();
        }
        return this.cached.getAccessTokenLifespanForImplicitFlow();
    }

    public void setAccessTokenLifespanForImplicitFlow(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setAccessTokenLifespanForImplicitFlow(seconds);
    }

    public int getAccessCodeLifespan() {
        if (this.isUpdated()) {
            return this.updated.getAccessCodeLifespan();
        }
        return this.cached.getAccessCodeLifespan();
    }

    public void setAccessCodeLifespan(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setAccessCodeLifespan(seconds);
    }

    public int getAccessCodeLifespanUserAction() {
        if (this.isUpdated()) {
            return this.updated.getAccessCodeLifespanUserAction();
        }
        return this.cached.getAccessCodeLifespanUserAction();
    }

    public void setAccessCodeLifespanUserAction(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setAccessCodeLifespanUserAction(seconds);
    }

    public Map<String, Integer> getUserActionTokenLifespans() {
        if (this.isUpdated()) {
            return this.updated.getUserActionTokenLifespans();
        }
        return this.cached.getUserActionTokenLifespans();
    }

    public int getAccessCodeLifespanLogin() {
        if (this.isUpdated()) {
            return this.updated.getAccessCodeLifespanLogin();
        }
        return this.cached.getAccessCodeLifespanLogin();
    }

    public void setAccessCodeLifespanLogin(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setAccessCodeLifespanLogin(seconds);
    }

    public int getActionTokenGeneratedByAdminLifespan() {
        if (this.isUpdated()) {
            return this.updated.getActionTokenGeneratedByAdminLifespan();
        }
        return this.cached.getActionTokenGeneratedByAdminLifespan();
    }

    public void setActionTokenGeneratedByAdminLifespan(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setActionTokenGeneratedByAdminLifespan(seconds);
    }

    public int getActionTokenGeneratedByUserLifespan() {
        if (this.isUpdated()) {
            return this.updated.getActionTokenGeneratedByUserLifespan();
        }
        return this.cached.getActionTokenGeneratedByUserLifespan();
    }

    public void setActionTokenGeneratedByUserLifespan(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setActionTokenGeneratedByUserLifespan(seconds);
    }

    public int getActionTokenGeneratedByUserLifespan(String actionTokenId) {
        if (this.isUpdated()) {
            return this.updated.getActionTokenGeneratedByUserLifespan(actionTokenId);
        }
        return this.cached.getActionTokenGeneratedByUserLifespan(actionTokenId);
    }

    public void setActionTokenGeneratedByUserLifespan(String actionTokenId, Integer seconds) {
        if (seconds != null) {
            this.getDelegateForUpdate();
            this.updated.setActionTokenGeneratedByUserLifespan(actionTokenId, seconds);
        }
    }

    public Stream<RequiredCredentialModel> getRequiredCredentialsStream() {
        if (this.isUpdated()) {
            return this.updated.getRequiredCredentialsStream();
        }
        return this.cached.getRequiredCredentials().stream();
    }

    public OAuth2DeviceConfig getOAuth2DeviceConfig() {
        if (this.isUpdated()) {
            return this.updated.getOAuth2DeviceConfig();
        }
        return this.cached.getOAuth2DeviceConfig(this.modelSupplier);
    }

    public CibaConfig getCibaPolicy() {
        if (this.isUpdated()) {
            return this.updated.getCibaPolicy();
        }
        return this.cached.getCibaConfig(this.modelSupplier);
    }

    public ParConfig getParPolicy() {
        if (this.isUpdated()) {
            return this.updated.getParPolicy();
        }
        return this.cached.getParConfig(this.modelSupplier);
    }

    public void addRequiredCredential(String cred) {
        this.getDelegateForUpdate();
        this.updated.addRequiredCredential(cred);
    }

    public PasswordPolicy getPasswordPolicy() {
        if (this.isUpdated()) {
            return this.updated.getPasswordPolicy();
        }
        return this.cached.getPasswordPolicy();
    }

    public void setPasswordPolicy(PasswordPolicy policy) {
        this.getDelegateForUpdate();
        this.updated.setPasswordPolicy(policy);
    }

    public OTPPolicy getOTPPolicy() {
        if (this.isUpdated()) {
            return this.updated.getOTPPolicy();
        }
        return this.cached.getOtpPolicy();
    }

    public void setOTPPolicy(OTPPolicy policy) {
        this.getDelegateForUpdate();
        this.updated.setOTPPolicy(policy);
    }

    public WebAuthnPolicy getWebAuthnPolicy() {
        if (this.isUpdated()) {
            return this.updated.getWebAuthnPolicy();
        }
        return this.cached.getWebAuthnPolicy();
    }

    public void setWebAuthnPolicy(WebAuthnPolicy policy) {
        this.getDelegateForUpdate();
        this.updated.setWebAuthnPolicy(policy);
    }

    public WebAuthnPolicy getWebAuthnPolicyPasswordless() {
        if (this.isUpdated()) {
            return this.updated.getWebAuthnPolicyPasswordless();
        }
        return this.cached.getWebAuthnPasswordlessPolicy();
    }

    public void setWebAuthnPolicyPasswordless(WebAuthnPolicy policy) {
        this.getDelegateForUpdate();
        this.updated.setWebAuthnPolicyPasswordless(policy);
    }

    public RoleModel getRoleById(String id) {
        if (this.isUpdated()) {
            return this.updated.getRoleById(id);
        }
        return this.cacheSession.getRoleById((RealmModel)this, id);
    }

    public Stream<GroupModel> getDefaultGroupsStream() {
        if (this.isUpdated()) {
            return this.updated.getDefaultGroupsStream();
        }
        return this.cached.getDefaultGroups().stream().map(this::getGroupById);
    }

    public void addDefaultGroup(GroupModel group) {
        this.getDelegateForUpdate();
        this.updated.addDefaultGroup(group);
    }

    public void removeDefaultGroup(GroupModel group) {
        this.getDelegateForUpdate();
        this.updated.removeDefaultGroup(group);
    }

    @Deprecated
    public Stream<String> getDefaultRolesStream() {
        if (this.isUpdated()) {
            return this.updated.getDefaultRolesStream();
        }
        return this.getDefaultRole().getCompositesStream().filter(this::isRealmRole).map(RoleModel::getName);
    }

    private boolean isRealmRole(RoleModel role) {
        return !role.isClientRole();
    }

    @Deprecated
    public void addDefaultRole(String name) {
        this.getDelegateForUpdate();
        this.updated.addDefaultRole(name);
    }

    @Deprecated
    public void removeDefaultRoles(String ... defaultRoles) {
        this.getDelegateForUpdate();
        this.updated.removeDefaultRoles(defaultRoles);
    }

    public void addToDefaultRoles(RoleModel role) {
        this.getDelegateForUpdate();
        this.updated.addToDefaultRoles(role);
    }

    public Stream<ClientModel> getClientsStream() {
        return this.cacheSession.getClientsStream((RealmModel)this);
    }

    public Stream<ClientModel> getAlwaysDisplayInConsoleClientsStream() {
        return this.cacheSession.getAlwaysDisplayInConsoleClientsStream((RealmModel)this);
    }

    public ClientModel addClient(String name) {
        return this.cacheSession.addClient((RealmModel)this, name);
    }

    public ClientModel addClient(String id, String clientId) {
        return this.cacheSession.addClient((RealmModel)this, id, clientId);
    }

    public boolean removeClient(String id) {
        return this.cacheSession.removeClient((RealmModel)this, id);
    }

    public ClientModel getClientById(String id) {
        if (this.isUpdated()) {
            return this.updated.getClientById(id);
        }
        return this.cacheSession.getClientById((RealmModel)this, id);
    }

    public ClientModel getClientByClientId(String clientId) {
        return this.cacheSession.getClientByClientId((RealmModel)this, clientId);
    }

    public Stream<ClientModel> searchClientByClientIdStream(String clientId, Integer firstResult, Integer maxResults) {
        return this.cacheSession.searchClientsByClientIdStream((RealmModel)this, clientId, firstResult, maxResults);
    }

    public Stream<ClientModel> searchClientByAttributes(Map<String, String> attributes, Integer firstResult, Integer maxResults) {
        return this.cacheSession.searchClientsByAttributes((RealmModel)this, attributes, firstResult, maxResults);
    }

    public Stream<ClientModel> getClientsStream(Integer firstResult, Integer maxResults) {
        return this.cacheSession.getClientsStream((RealmModel)this, firstResult, maxResults);
    }

    public Long getClientsCount() {
        return this.cacheSession.getClientsCount((RealmModel)this);
    }

    public void updateRequiredCredentials(Set<String> creds) {
        this.getDelegateForUpdate();
        this.updated.updateRequiredCredentials(creds);
    }

    public Map<String, String> getBrowserSecurityHeaders() {
        if (this.isUpdated()) {
            return this.updated.getBrowserSecurityHeaders();
        }
        return this.cached.getBrowserSecurityHeaders();
    }

    public void setBrowserSecurityHeaders(Map<String, String> headers) {
        this.getDelegateForUpdate();
        this.updated.setBrowserSecurityHeaders(headers);
    }

    public Map<String, String> getSmtpConfig() {
        if (this.isUpdated()) {
            return this.updated.getSmtpConfig();
        }
        return this.cached.getSmtpConfig();
    }

    public void setSmtpConfig(Map<String, String> smtpConfig) {
        this.getDelegateForUpdate();
        this.updated.setSmtpConfig(smtpConfig);
    }

    public Stream<IdentityProviderModel> getIdentityProvidersStream() {
        if (this.isUpdated()) {
            return this.updated.getIdentityProvidersStream();
        }
        return this.cached.getIdentityProviders().stream();
    }

    public IdentityProviderModel getIdentityProviderByAlias(String alias) {
        if (this.isUpdated()) {
            return this.updated.getIdentityProviderByAlias(alias);
        }
        return this.getIdentityProvidersStream().filter(model -> Objects.equals(model.getAlias(), alias)).findFirst().orElse(null);
    }

    public void addIdentityProvider(IdentityProviderModel identityProvider) {
        this.getDelegateForUpdate();
        this.updated.addIdentityProvider(identityProvider);
    }

    public void updateIdentityProvider(IdentityProviderModel identityProvider) {
        this.getDelegateForUpdate();
        this.updated.updateIdentityProvider(identityProvider);
    }

    public void removeIdentityProviderByAlias(String alias) {
        this.getDelegateForUpdate();
        this.updated.removeIdentityProviderByAlias(alias);
    }

    public String getLoginTheme() {
        if (this.isUpdated()) {
            return this.updated.getLoginTheme();
        }
        return this.cached.getLoginTheme();
    }

    public void setLoginTheme(String name) {
        this.getDelegateForUpdate();
        this.updated.setLoginTheme(name);
    }

    public String getAccountTheme() {
        if (this.isUpdated()) {
            return this.updated.getAccountTheme();
        }
        return this.cached.getAccountTheme();
    }

    public void setAccountTheme(String name) {
        this.getDelegateForUpdate();
        this.updated.setAccountTheme(name);
    }

    public String getAdminTheme() {
        if (this.isUpdated()) {
            return this.updated.getAdminTheme();
        }
        return this.cached.getAdminTheme();
    }

    public void setAdminTheme(String name) {
        this.getDelegateForUpdate();
        this.updated.setAdminTheme(name);
    }

    public String getEmailTheme() {
        if (this.isUpdated()) {
            return this.updated.getEmailTheme();
        }
        return this.cached.getEmailTheme();
    }

    public void setEmailTheme(String name) {
        this.getDelegateForUpdate();
        this.updated.setEmailTheme(name);
    }

    public int getNotBefore() {
        if (this.isUpdated()) {
            return this.updated.getNotBefore();
        }
        return this.cached.getNotBefore();
    }

    public void setNotBefore(int notBefore) {
        this.getDelegateForUpdate();
        this.updated.setNotBefore(notBefore);
    }

    public boolean isEventsEnabled() {
        if (this.isUpdated()) {
            return this.updated.isEventsEnabled();
        }
        return this.cached.isEventsEnabled();
    }

    public void setEventsEnabled(boolean enabled) {
        this.getDelegateForUpdate();
        this.updated.setEventsEnabled(enabled);
    }

    public long getEventsExpiration() {
        if (this.isUpdated()) {
            return this.updated.getEventsExpiration();
        }
        return this.cached.getEventsExpiration();
    }

    public void setEventsExpiration(long expiration) {
        this.getDelegateForUpdate();
        this.updated.setEventsExpiration(expiration);
    }

    public Stream<String> getEventsListenersStream() {
        if (this.isUpdated()) {
            return this.updated.getEventsListenersStream();
        }
        return this.cached.getEventsListeners().stream();
    }

    public void setEventsListeners(Set<String> listeners) {
        this.getDelegateForUpdate();
        this.updated.setEventsListeners(listeners);
    }

    public Stream<String> getEnabledEventTypesStream() {
        if (this.isUpdated()) {
            return this.updated.getEnabledEventTypesStream();
        }
        return this.cached.getEnabledEventTypes().stream();
    }

    public void setEnabledEventTypes(Set<String> enabledEventTypes) {
        this.getDelegateForUpdate();
        this.updated.setEnabledEventTypes(enabledEventTypes);
    }

    public boolean isAdminEventsEnabled() {
        if (this.isUpdated()) {
            return this.updated.isAdminEventsEnabled();
        }
        return this.cached.isAdminEventsEnabled();
    }

    public void setAdminEventsEnabled(boolean enabled) {
        this.getDelegateForUpdate();
        this.updated.setAdminEventsEnabled(enabled);
    }

    public boolean isAdminEventsDetailsEnabled() {
        if (this.isUpdated()) {
            return this.updated.isAdminEventsDetailsEnabled();
        }
        return this.cached.isAdminEventsDetailsEnabled();
    }

    public void setAdminEventsDetailsEnabled(boolean enabled) {
        this.getDelegateForUpdate();
        this.updated.setAdminEventsDetailsEnabled(enabled);
    }

    public ClientModel getMasterAdminClient() {
        return this.cached.getMasterAdminClient() == null ? null : this.cacheSession.getRealmByName(Config.getAdminRealm()).getClientById(this.cached.getMasterAdminClient());
    }

    public void setMasterAdminClient(ClientModel client) {
        this.getDelegateForUpdate();
        this.updated.setMasterAdminClient(client);
    }

    public void setDefaultRole(RoleModel role) {
        this.getDelegateForUpdate();
        this.updated.setDefaultRole(role);
    }

    public RoleModel getDefaultRole() {
        return this.cached.getDefaultRoleId() == null ? null : this.cacheSession.getRoleById((RealmModel)this, this.cached.getDefaultRoleId());
    }

    public RoleModel getRole(String name) {
        return this.cacheSession.getRealmRole((RealmModel)this, name);
    }

    public Stream<RoleModel> getRolesStream() {
        return this.cacheSession.getRealmRolesStream((RealmModel)this);
    }

    public Stream<RoleModel> getRolesStream(Integer first, Integer max) {
        return this.cacheSession.getRealmRolesStream((RealmModel)this, first, max);
    }

    public Stream<RoleModel> searchForRolesStream(String search, Integer first, Integer max) {
        return this.cacheSession.searchForRolesStream((RealmModel)this, search, first, max);
    }

    public RoleModel addRole(String name) {
        return this.cacheSession.addRealmRole((RealmModel)this, name);
    }

    public RoleModel addRole(String id, String name) {
        return this.cacheSession.addRealmRole((RealmModel)this, id, name);
    }

    public boolean removeRole(RoleModel role) {
        return this.cacheSession.removeRole(role);
    }

    public boolean isIdentityFederationEnabled() {
        if (this.isUpdated()) {
            return this.updated.isIdentityFederationEnabled();
        }
        return this.cached.isIdentityFederationEnabled();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RealmModel)) {
            return false;
        }
        RealmModel that = (RealmModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean isInternationalizationEnabled() {
        if (this.isUpdated()) {
            return this.updated.isInternationalizationEnabled();
        }
        return this.cached.isInternationalizationEnabled();
    }

    public void setInternationalizationEnabled(boolean enabled) {
        this.getDelegateForUpdate();
        this.updated.setInternationalizationEnabled(enabled);
    }

    public Stream<String> getSupportedLocalesStream() {
        if (this.isUpdated()) {
            return this.updated.getSupportedLocalesStream();
        }
        return this.cached.getSupportedLocales().stream();
    }

    public void setSupportedLocales(Set<String> locales) {
        this.getDelegateForUpdate();
        this.updated.setSupportedLocales(locales);
    }

    public String getDefaultLocale() {
        if (this.isUpdated()) {
            return this.updated.getDefaultLocale();
        }
        return this.cached.getDefaultLocale();
    }

    public void setDefaultLocale(String locale) {
        this.updated.setDefaultLocale(locale);
    }

    public Stream<IdentityProviderMapperModel> getIdentityProviderMappersStream() {
        if (this.isUpdated()) {
            return this.updated.getIdentityProviderMappersStream();
        }
        return this.cached.getIdentityProviderMapperSet().stream();
    }

    public Stream<IdentityProviderMapperModel> getIdentityProviderMappersByAliasStream(String brokerAlias) {
        if (this.isUpdated()) {
            return this.updated.getIdentityProviderMappersByAliasStream(brokerAlias);
        }
        HashSet mappings = new HashSet(this.cached.getIdentityProviderMappers().getList((Object)brokerAlias));
        return mappings.stream();
    }

    public IdentityProviderMapperModel addIdentityProviderMapper(IdentityProviderMapperModel model) {
        this.getDelegateForUpdate();
        return this.updated.addIdentityProviderMapper(model);
    }

    public void removeIdentityProviderMapper(IdentityProviderMapperModel mapping) {
        this.getDelegateForUpdate();
        this.updated.removeIdentityProviderMapper(mapping);
    }

    public void updateIdentityProviderMapper(IdentityProviderMapperModel mapping) {
        this.getDelegateForUpdate();
        this.updated.updateIdentityProviderMapper(mapping);
    }

    public IdentityProviderMapperModel getIdentityProviderMapperById(String id) {
        if (this.isUpdated()) {
            return this.updated.getIdentityProviderMapperById(id);
        }
        for (List models : this.cached.getIdentityProviderMappers().values()) {
            for (IdentityProviderMapperModel model : models) {
                if (!model.getId().equals(id)) continue;
                return model;
            }
        }
        return null;
    }

    public IdentityProviderMapperModel getIdentityProviderMapperByName(String alias, String name) {
        if (this.isUpdated()) {
            return this.updated.getIdentityProviderMapperByName(alias, name);
        }
        List models = this.cached.getIdentityProviderMappers().getList((Object)alias);
        if (models == null) {
            return null;
        }
        for (IdentityProviderMapperModel model : models) {
            if (!model.getName().equals(name)) continue;
            return model;
        }
        return null;
    }

    public AuthenticationFlowModel getBrowserFlow() {
        if (this.isUpdated()) {
            return this.updated.getBrowserFlow();
        }
        return this.cached.getBrowserFlow();
    }

    public void setBrowserFlow(AuthenticationFlowModel flow) {
        this.getDelegateForUpdate();
        this.updated.setBrowserFlow(flow);
    }

    public AuthenticationFlowModel getRegistrationFlow() {
        if (this.isUpdated()) {
            return this.updated.getRegistrationFlow();
        }
        return this.cached.getRegistrationFlow();
    }

    public void setRegistrationFlow(AuthenticationFlowModel flow) {
        this.getDelegateForUpdate();
        this.updated.setRegistrationFlow(flow);
    }

    public AuthenticationFlowModel getDirectGrantFlow() {
        if (this.isUpdated()) {
            return this.updated.getDirectGrantFlow();
        }
        return this.cached.getDirectGrantFlow();
    }

    public void setDirectGrantFlow(AuthenticationFlowModel flow) {
        this.getDelegateForUpdate();
        this.updated.setDirectGrantFlow(flow);
    }

    public AuthenticationFlowModel getResetCredentialsFlow() {
        if (this.isUpdated()) {
            return this.updated.getResetCredentialsFlow();
        }
        return this.cached.getResetCredentialsFlow();
    }

    public void setResetCredentialsFlow(AuthenticationFlowModel flow) {
        this.getDelegateForUpdate();
        this.updated.setResetCredentialsFlow(flow);
    }

    public AuthenticationFlowModel getClientAuthenticationFlow() {
        if (this.isUpdated()) {
            return this.updated.getClientAuthenticationFlow();
        }
        return this.cached.getClientAuthenticationFlow();
    }

    public void setClientAuthenticationFlow(AuthenticationFlowModel flow) {
        this.getDelegateForUpdate();
        this.updated.setClientAuthenticationFlow(flow);
    }

    public AuthenticationFlowModel getDockerAuthenticationFlow() {
        if (this.isUpdated()) {
            return this.updated.getDockerAuthenticationFlow();
        }
        return this.cached.getDockerAuthenticationFlow();
    }

    public void setDockerAuthenticationFlow(AuthenticationFlowModel flow) {
        this.getDelegateForUpdate();
        this.updated.setDockerAuthenticationFlow(flow);
    }

    public Stream<AuthenticationFlowModel> getAuthenticationFlowsStream() {
        if (this.isUpdated()) {
            return this.updated.getAuthenticationFlowsStream();
        }
        return this.cached.getAuthenticationFlowList().stream();
    }

    public AuthenticationFlowModel getFlowByAlias(String alias) {
        return this.getAuthenticationFlowsStream().filter(flow -> Objects.equals(flow.getAlias(), alias)).findFirst().orElse(null);
    }

    public AuthenticatorConfigModel getAuthenticatorConfigByAlias(String alias) {
        return this.getAuthenticatorConfigsStream().filter(config -> Objects.equals(config.getAlias(), alias)).findFirst().orElse(null);
    }

    public AuthenticationFlowModel addAuthenticationFlow(AuthenticationFlowModel model) {
        this.getDelegateForUpdate();
        return this.updated.addAuthenticationFlow(model);
    }

    public AuthenticationFlowModel getAuthenticationFlowById(String id) {
        if (this.isUpdated()) {
            return this.updated.getAuthenticationFlowById(id);
        }
        return this.cached.getAuthenticationFlows().get(id);
    }

    public void removeAuthenticationFlow(AuthenticationFlowModel model) {
        this.getDelegateForUpdate();
        this.updated.removeAuthenticationFlow(model);
    }

    public void updateAuthenticationFlow(AuthenticationFlowModel model) {
        this.getDelegateForUpdate();
        this.updated.updateAuthenticationFlow(model);
    }

    public Stream<AuthenticationExecutionModel> getAuthenticationExecutionsStream(String flowId) {
        if (this.isUpdated()) {
            return this.updated.getAuthenticationExecutionsStream(flowId);
        }
        return ((List)this.cached.getAuthenticationExecutions().get((Object)flowId)).stream();
    }

    public AuthenticationExecutionModel getAuthenticationExecutionById(String id) {
        if (this.isUpdated()) {
            return this.updated.getAuthenticationExecutionById(id);
        }
        return this.cached.getExecutionsById().get(id);
    }

    public AuthenticationExecutionModel getAuthenticationExecutionByFlowId(String flowId) {
        if (this.isUpdated()) {
            return this.updated.getAuthenticationExecutionByFlowId(flowId);
        }
        return this.cached.getAuthenticationExecutionByFlowId(flowId);
    }

    public AuthenticationExecutionModel addAuthenticatorExecution(AuthenticationExecutionModel model) {
        this.getDelegateForUpdate();
        return this.updated.addAuthenticatorExecution(model);
    }

    public void updateAuthenticatorExecution(AuthenticationExecutionModel model) {
        this.getDelegateForUpdate();
        this.updated.updateAuthenticatorExecution(model);
    }

    public void removeAuthenticatorExecution(AuthenticationExecutionModel model) {
        this.getDelegateForUpdate();
        this.updated.removeAuthenticatorExecution(model);
    }

    public Stream<AuthenticatorConfigModel> getAuthenticatorConfigsStream() {
        if (this.isUpdated()) {
            return this.updated.getAuthenticatorConfigsStream();
        }
        return this.cached.getAuthenticatorConfigs().values().stream();
    }

    public AuthenticatorConfigModel addAuthenticatorConfig(AuthenticatorConfigModel model) {
        this.getDelegateForUpdate();
        return this.updated.addAuthenticatorConfig(model);
    }

    public void updateAuthenticatorConfig(AuthenticatorConfigModel model) {
        this.getDelegateForUpdate();
        this.updated.updateAuthenticatorConfig(model);
    }

    public void removeAuthenticatorConfig(AuthenticatorConfigModel model) {
        this.getDelegateForUpdate();
        this.updated.removeAuthenticatorConfig(model);
    }

    public AuthenticatorConfigModel getAuthenticatorConfigById(String id) {
        if (this.isUpdated()) {
            return this.updated.getAuthenticatorConfigById(id);
        }
        return this.cached.getAuthenticatorConfigs().get(id);
    }

    public Stream<RequiredActionProviderModel> getRequiredActionProvidersStream() {
        if (this.isUpdated()) {
            return this.updated.getRequiredActionProvidersStream();
        }
        return this.cached.getRequiredActionProviderList().stream();
    }

    public RequiredActionProviderModel addRequiredActionProvider(RequiredActionProviderModel model) {
        this.getDelegateForUpdate();
        return this.updated.addRequiredActionProvider(model);
    }

    public void updateRequiredActionProvider(RequiredActionProviderModel model) {
        this.getDelegateForUpdate();
        this.updated.updateRequiredActionProvider(model);
    }

    public void removeRequiredActionProvider(RequiredActionProviderModel model) {
        this.getDelegateForUpdate();
        this.updated.removeRequiredActionProvider(model);
    }

    public RequiredActionProviderModel getRequiredActionProviderById(String id) {
        if (this.isUpdated()) {
            return this.updated.getRequiredActionProviderById(id);
        }
        return this.cached.getRequiredActionProviders().get(id);
    }

    public RequiredActionProviderModel getRequiredActionProviderByAlias(String alias) {
        if (this.isUpdated()) {
            return this.updated.getRequiredActionProviderByAlias(alias);
        }
        return this.cached.getRequiredActionProvidersByAlias().get(alias);
    }

    public GroupModel createGroup(String id, String name, GroupModel toParent) {
        return this.cacheSession.createGroup((RealmModel)this, id, name, toParent);
    }

    public void moveGroup(GroupModel group, GroupModel toParent) {
        this.cacheSession.moveGroup((RealmModel)this, group, toParent);
    }

    public GroupModel getGroupById(String id) {
        return this.cacheSession.getGroupById((RealmModel)this, id);
    }

    public Stream<GroupModel> getGroupsStream() {
        return this.cacheSession.getGroupsStream((RealmModel)this);
    }

    public Long getGroupsCount(Boolean onlyTopGroups) {
        return this.cacheSession.getGroupsCount((RealmModel)this, onlyTopGroups);
    }

    public Long getGroupsCountByNameContaining(String search) {
        return this.cacheSession.getGroupsCountByNameContaining((RealmModel)this, search);
    }

    public Stream<GroupModel> getTopLevelGroupsStream() {
        return this.cacheSession.getTopLevelGroupsStream((RealmModel)this);
    }

    public Stream<GroupModel> getTopLevelGroupsStream(Integer first, Integer max) {
        return this.cacheSession.getTopLevelGroupsStream((RealmModel)this, first, max);
    }

    @Deprecated
    public Stream<GroupModel> searchForGroupByNameStream(String search, Integer first, Integer max) {
        return this.cacheSession.searchForGroupByNameStream((RealmModel)this, search, false, first, max);
    }

    public boolean removeGroup(GroupModel group) {
        return this.cacheSession.removeGroup((RealmModel)this, group);
    }

    public Stream<ClientScopeModel> getClientScopesStream() {
        if (this.isUpdated()) {
            return this.updated.getClientScopesStream();
        }
        return this.cached.getClientScopes().stream().map(scope -> {
            ClientScopeModel model = this.cacheSession.getClientScopeById((RealmModel)this, (String)scope);
            if (model == null) {
                throw new IllegalStateException("Cached clientScope not found: " + scope);
            }
            return model;
        });
    }

    public ClientScopeModel addClientScope(String name) {
        RealmModel realm = this.getDelegateForUpdate();
        ClientScopeModel clientScope = this.updated.addClientScope(name);
        this.cacheSession.registerClientScopeInvalidation(clientScope.getId(), realm.getId());
        return clientScope;
    }

    public ClientScopeModel addClientScope(String id, String name) {
        RealmModel realm = this.getDelegateForUpdate();
        ClientScopeModel clientScope = this.updated.addClientScope(id, name);
        this.cacheSession.registerClientScopeInvalidation(clientScope.getId(), realm.getId());
        return clientScope;
    }

    public boolean removeClientScope(String id) {
        RealmModel realm = this.getDelegateForUpdate();
        this.cacheSession.registerClientScopeInvalidation(id, realm.getId());
        return this.updated.removeClientScope(id);
    }

    public ClientScopeModel getClientScopeById(String id) {
        if (this.isUpdated()) {
            return this.updated.getClientScopeById(id);
        }
        return this.cacheSession.getClientScopeById((RealmModel)this, id);
    }

    public void addDefaultClientScope(ClientScopeModel clientScope, boolean defaultScope) {
        this.getDelegateForUpdate();
        this.updated.addDefaultClientScope(clientScope, defaultScope);
    }

    public void removeDefaultClientScope(ClientScopeModel clientScope) {
        this.getDelegateForUpdate();
        this.updated.removeDefaultClientScope(clientScope);
    }

    public Stream<ClientScopeModel> getDefaultClientScopesStream(boolean defaultScope) {
        if (this.isUpdated()) {
            return this.updated.getDefaultClientScopesStream(defaultScope);
        }
        List<String> clientScopeIds = defaultScope ? this.cached.getDefaultDefaultClientScopes() : this.cached.getOptionalDefaultClientScopes();
        return clientScopeIds.stream().map(scope -> this.cacheSession.getClientScopeById((RealmModel)this, (String)scope)).filter(Objects::nonNull);
    }

    public ComponentModel addComponentModel(ComponentModel model) {
        this.getDelegateForUpdate();
        this.executeEvictions(model);
        return this.updated.addComponentModel(model);
    }

    public ComponentModel importComponentModel(ComponentModel model) {
        this.getDelegateForUpdate();
        this.executeEvictions(model);
        return this.updated.importComponentModel(model);
    }

    public void executeEvictions(ComponentModel model) {
        if (model == null) {
            return;
        }
        UserCache userCache = UserStorageUtil.userCache((KeycloakSession)this.session);
        if (userCache != null) {
            if (model.getParentId() != null && !model.getParentId().equals(this.getId())) {
                ComponentModel parent = this.getComponent(model.getParentId());
                if (parent != null && UserStorageProvider.class.getName().equals(parent.getProviderType())) {
                    userCache.evict((RealmModel)this);
                }
                return;
            }
            if (UserStorageProvider.class.getName().equals(model.getProviderType())) {
                userCache.evict((RealmModel)this);
            }
        }
        if (ClientStorageProvider.class.getName().equals(model.getProviderType())) {
            this.cacheSession.evictRealmOnRemoval((RealmModel)this);
        }
    }

    public void updateComponent(ComponentModel component) {
        this.getDelegateForUpdate();
        this.executeEvictions(component);
        this.updated.updateComponent(component);
    }

    public void removeComponent(ComponentModel component) {
        this.getDelegateForUpdate();
        this.executeEvictions(component);
        this.updated.removeComponent(component);
    }

    public void removeComponents(String parentId) {
        this.getDelegateForUpdate();
        this.updated.removeComponents(parentId);
    }

    public Stream<ComponentModel> getComponentsStream(String parentId, String providerType) {
        if (this.isUpdated()) {
            return this.updated.getComponentsStream(parentId, providerType);
        }
        return this.cached.getComponentsByParentAndType().getList((Object)(parentId + providerType)).stream();
    }

    public Stream<ComponentModel> getComponentsStream(String parentId) {
        if (this.isUpdated()) {
            return this.updated.getComponentsStream(parentId);
        }
        return this.cached.getComponentsByParent().getList((Object)parentId).stream();
    }

    public Stream<ComponentModel> getComponentsStream() {
        if (this.isUpdated()) {
            return this.updated.getComponentsStream();
        }
        return this.cached.getComponents().values().stream();
    }

    public ComponentModel getComponent(String id) {
        if (this.isUpdated()) {
            return this.updated.getComponent(id);
        }
        return this.cached.getComponents().get(id);
    }

    public void setAttribute(String name, String value) {
        this.getDelegateForUpdate();
        this.updated.setAttribute(name, value);
    }

    public void setAttribute(String name, Boolean value) {
        this.getDelegateForUpdate();
        this.updated.setAttribute(name, value);
    }

    public void setAttribute(String name, Integer value) {
        this.getDelegateForUpdate();
        this.updated.setAttribute(name, value);
    }

    public void setAttribute(String name, Long value) {
        this.getDelegateForUpdate();
        this.updated.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.getDelegateForUpdate();
        this.updated.removeAttribute(name);
    }

    public String getAttribute(String name) {
        if (this.isUpdated()) {
            return this.updated.getAttribute(name);
        }
        return this.cached.getAttribute(name);
    }

    public Integer getAttribute(String name, Integer defaultValue) {
        if (this.isUpdated()) {
            return this.updated.getAttribute(name, defaultValue);
        }
        return this.cached.getAttribute(name, defaultValue);
    }

    public Long getAttribute(String name, Long defaultValue) {
        if (this.isUpdated()) {
            return this.updated.getAttribute(name, defaultValue);
        }
        return this.cached.getAttribute(name, defaultValue);
    }

    public Boolean getAttribute(String name, Boolean defaultValue) {
        if (this.isUpdated()) {
            return this.updated.getAttribute(name, defaultValue);
        }
        return this.cached.getAttribute(name, defaultValue);
    }

    public Map<String, String> getAttributes() {
        if (this.isUpdated()) {
            return this.updated.getAttributes();
        }
        return this.cached.getAttributes();
    }

    public void createOrUpdateRealmLocalizationTexts(String locale, Map<String, String> localizationTexts) {
        this.getDelegateForUpdate();
        this.updated.createOrUpdateRealmLocalizationTexts(locale, localizationTexts);
    }

    public boolean removeRealmLocalizationTexts(String locale) {
        this.getDelegateForUpdate();
        return this.updated.removeRealmLocalizationTexts(locale);
    }

    public Map<String, Map<String, String>> getRealmLocalizationTexts() {
        if (this.isUpdated()) {
            return this.updated.getRealmLocalizationTexts();
        }
        return this.cached.getRealmLocalizationTexts();
    }

    public Map<String, String> getRealmLocalizationTextsByLocale(String locale) {
        if (this.isUpdated()) {
            return this.updated.getRealmLocalizationTextsByLocale(locale);
        }
        Map<Object, Object> localizationTexts = Collections.emptyMap();
        if (this.cached.getRealmLocalizationTexts() != null && this.cached.getRealmLocalizationTexts().containsKey(locale)) {
            localizationTexts = this.cached.getRealmLocalizationTexts().get(locale);
        }
        return Collections.unmodifiableMap(localizationTexts);
    }

    private RealmModel getRealm() {
        return this.cacheSession.getRealmDelegate().getRealm(this.cached.getId());
    }

    public ClientInitialAccessModel createClientInitialAccessModel(int expiration, int count) {
        this.getDelegateForUpdate();
        return this.updated.createClientInitialAccessModel(expiration, count);
    }

    public ClientInitialAccessModel getClientInitialAccessModel(String id) {
        return this.getDelegateForUpdate().getClientInitialAccessModel(id);
    }

    public void removeClientInitialAccessModel(String id) {
        this.getDelegateForUpdate().removeClientInitialAccessModel(id);
    }

    public Stream<ClientInitialAccessModel> getClientInitialAccesses() {
        return this.getDelegateForUpdate().getClientInitialAccesses();
    }

    public void decreaseRemainingCount(ClientInitialAccessModel clientInitialAccess) {
        this.getDelegateForUpdate().decreaseRemainingCount(clientInitialAccess);
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), this.hashCode());
    }
}

