/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes.sessions;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.sessions.infinispan.util.KeycloakMarshallUtil;

@SerializeWith(value=ExternalizerImpl.class)
public class SessionData {
    private final String realmId;
    private final int lastSessionRefresh;

    public SessionData(String realmId, int lastSessionRefresh) {
        this.realmId = realmId;
        this.lastSessionRefresh = lastSessionRefresh;
    }

    public String getRealmId() {
        return this.realmId;
    }

    public int getLastSessionRefresh() {
        return this.lastSessionRefresh;
    }

    public String toString() {
        return String.format("realmId: %s, lastSessionRefresh: %d", this.realmId, this.lastSessionRefresh);
    }

    public static class ExternalizerImpl
    implements Externalizer<SessionData> {
        public void writeObject(ObjectOutput output, SessionData obj) throws IOException {
            MarshallUtil.marshallString((String)obj.realmId, (ObjectOutput)output);
            KeycloakMarshallUtil.marshall(obj.lastSessionRefresh, output);
        }

        public SessionData readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            String realmId = MarshallUtil.unmarshallString((ObjectInput)input);
            int lastSessionRefresh = KeycloakMarshallUtil.unmarshallInteger(input);
            return new SessionData(realmId, lastSessionRefresh);
        }
    }
}

