/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.util;

import java.util.concurrent.TimeUnit;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureEntity;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;
import org.keycloak.models.utils.SessionExpirationUtils;

public class SessionTimeouts {
    public static final long ENTRY_EXPIRED_FLAG = -2L;

    public static long getUserSessionLifespanMs(RealmModel realm, ClientModel client, UserSessionEntity userSessionEntity) {
        long lifespan = SessionExpirationUtils.calculateUserSessionMaxLifespanTimestamp((boolean)false, (boolean)userSessionEntity.isRememberMe(), (long)TimeUnit.SECONDS.toMillis(userSessionEntity.getStarted()), (RealmModel)realm);
        if ((lifespan -= Time.currentTimeMillis()) <= 0L) {
            return -2L;
        }
        return lifespan;
    }

    public static long getUserSessionMaxIdleMs(RealmModel realm, ClientModel client, UserSessionEntity userSessionEntity) {
        long idle = SessionExpirationUtils.calculateUserSessionIdleTimestamp((boolean)false, (boolean)userSessionEntity.isRememberMe(), (long)TimeUnit.SECONDS.toMillis(userSessionEntity.getLastSessionRefresh()), (RealmModel)realm);
        if ((idle -= Time.currentTimeMillis()) <= 0L) {
            return -2L;
        }
        return idle;
    }

    public static long getClientSessionLifespanMs(RealmModel realm, ClientModel client, AuthenticatedClientSessionEntity clientSessionEntity) {
        long lifespan = SessionExpirationUtils.calculateClientSessionMaxLifespanTimestamp((boolean)false, (boolean)clientSessionEntity.isUserSessionRememberMe(), (long)TimeUnit.SECONDS.toMillis(clientSessionEntity.getStarted()), (long)TimeUnit.SECONDS.toMillis(clientSessionEntity.getUserSessionStarted()), (RealmModel)realm, (ClientModel)client);
        if ((lifespan -= Time.currentTimeMillis()) <= 0L) {
            return -2L;
        }
        return lifespan;
    }

    public static long getClientSessionMaxIdleMs(RealmModel realm, ClientModel client, AuthenticatedClientSessionEntity clientSessionEntity) {
        long idle = SessionExpirationUtils.calculateClientSessionIdleTimestamp((boolean)false, (boolean)clientSessionEntity.isUserSessionRememberMe(), (long)TimeUnit.SECONDS.toMillis(clientSessionEntity.getTimestamp()), (RealmModel)realm, (ClientModel)client);
        if ((idle -= Time.currentTimeMillis()) <= 0L) {
            return -2L;
        }
        return idle;
    }

    public static long getOfflineSessionLifespanMs(RealmModel realm, ClientModel client, UserSessionEntity userSessionEntity) {
        long lifespan = SessionExpirationUtils.calculateUserSessionMaxLifespanTimestamp((boolean)true, (boolean)userSessionEntity.isRememberMe(), (long)TimeUnit.SECONDS.toMillis(userSessionEntity.getStarted()), (RealmModel)realm);
        if (lifespan == -1L) {
            return lifespan;
        }
        if ((lifespan -= Time.currentTimeMillis()) <= 0L) {
            return -2L;
        }
        return lifespan;
    }

    public static long getOfflineSessionMaxIdleMs(RealmModel realm, ClientModel client, UserSessionEntity userSessionEntity) {
        long idle = SessionExpirationUtils.calculateUserSessionIdleTimestamp((boolean)true, (boolean)userSessionEntity.isRememberMe(), (long)TimeUnit.SECONDS.toMillis(userSessionEntity.getLastSessionRefresh()), (RealmModel)realm);
        if ((idle -= Time.currentTimeMillis()) <= 0L) {
            return -2L;
        }
        return idle;
    }

    public static long getOfflineClientSessionLifespanMs(RealmModel realm, ClientModel client, AuthenticatedClientSessionEntity authenticatedClientSessionEntity) {
        long lifespan = SessionExpirationUtils.calculateClientSessionMaxLifespanTimestamp((boolean)true, (boolean)authenticatedClientSessionEntity.isUserSessionRememberMe(), (long)TimeUnit.SECONDS.toMillis(authenticatedClientSessionEntity.getStarted()), (long)TimeUnit.SECONDS.toMillis(authenticatedClientSessionEntity.getUserSessionStarted()), (RealmModel)realm, (ClientModel)client);
        if (lifespan == -1L) {
            return lifespan;
        }
        if ((lifespan -= Time.currentTimeMillis()) <= 0L) {
            return -2L;
        }
        return lifespan;
    }

    public static long getOfflineClientSessionMaxIdleMs(RealmModel realm, ClientModel client, AuthenticatedClientSessionEntity authenticatedClientSessionEntity) {
        long idle = SessionExpirationUtils.calculateClientSessionIdleTimestamp((boolean)true, (boolean)authenticatedClientSessionEntity.isUserSessionRememberMe(), (long)TimeUnit.SECONDS.toMillis(authenticatedClientSessionEntity.getTimestamp()), (RealmModel)realm, (ClientModel)client);
        if ((idle -= Time.currentTimeMillis()) <= 0L) {
            return -2L;
        }
        return idle;
    }

    public static long getLoginFailuresLifespanMs(RealmModel realm, ClientModel client, LoginFailureEntity loginFailureEntity) {
        return -1L;
    }

    public static long getLoginFailuresMaxIdleMs(RealmModel realm, ClientModel client, LoginFailureEntity loginFailureEntity) {
        return -1L;
    }
}

