/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.infinispan;

import java.net.InetSocketAddress;
import java.security.SecureRandom;
import java.util.Objects;
import org.infinispan.Cache;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.LocalModeAddress;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.jboss.logging.Logger;
import org.jgroups.JChannel;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.NameCache;
import org.keycloak.Config;

public class TopologyInfo {
    private static final Logger logger = Logger.getLogger(TopologyInfo.class);
    private final String myNodeName;
    private final String mySiteName;
    private final boolean isGeneratedNodeName;

    public TopologyInfo(EmbeddedCacheManager cacheManager, Config.Scope config, boolean embedded, String providerId) {
        String siteName;
        String nodeName;
        boolean isGeneratedNodeName = false;
        if (System.getProperty("jboss.site.name") != null) {
            throw new IllegalArgumentException(String.format("System property %s is in use. Use --spi-connections-infinispan-%s-site-name config option instead", "jboss.site.name", providerId));
        }
        if (!embedded) {
            Address addr = cacheManager.getAddress();
            if (addr != null) {
                nodeName = addr.toString();
                siteName = cacheManager.getCacheManagerConfiguration().transport().siteId();
                if (siteName == null) {
                    siteName = config.get("siteName");
                }
            } else {
                nodeName = System.getProperty("jboss.node.name");
                siteName = config.get("siteName");
            }
            if (nodeName == null || nodeName.equals("localhost")) {
                isGeneratedNodeName = true;
                nodeName = this.generateNodeName();
            }
        } else {
            boolean clustered = config.getBoolean("clustered", Boolean.valueOf(false));
            nodeName = config.get("nodeName", System.getProperty("jboss.node.name"));
            if (nodeName != null && nodeName.isEmpty()) {
                nodeName = null;
            }
            if ((siteName = config.get("siteName")) != null && siteName.isEmpty()) {
                siteName = null;
            }
            if (nodeName == null) {
                if (!clustered) {
                    isGeneratedNodeName = true;
                    nodeName = this.generateNodeName();
                } else {
                    throw new IllegalStateException("You must set jboss.node.name if you use clustered mode for InfinispanConnectionProvider");
                }
            }
        }
        this.myNodeName = nodeName;
        this.mySiteName = siteName;
        this.isGeneratedNodeName = isGeneratedNodeName;
    }

    private String generateNodeName() {
        return "node_" + new SecureRandom().nextInt(1000000);
    }

    public String getMyNodeName() {
        return this.myNodeName;
    }

    public String getMySiteName() {
        return this.mySiteName;
    }

    public String toString() {
        return String.format("Node name: %s, Site name: %s", this.myNodeName, this.mySiteName);
    }

    public boolean amIOwner(Cache<?, ?> cache, Object key) {
        Address myAddress = cache.getCacheManager().getAddress();
        Address objectOwnerAddress = this.getOwnerAddress(cache, key);
        return Objects.equals(myAddress, objectOwnerAddress);
    }

    public String getRouteName(Cache<?, ?> cache, Object key) {
        if (cache.getCacheConfiguration().clustering().cacheMode().isClustered() && this.isGeneratedNodeName) {
            logger.warn((Object)"Clustered configuration used, but node name is not properly set. Make sure to start server with jboss.node.name property identifying cluster node");
        }
        if (this.isGeneratedNodeName) {
            return null;
        }
        Address address = this.getOwnerAddress(cache, key);
        if (address == null || address == LocalModeAddress.INSTANCE) {
            return this.myNodeName;
        }
        org.jgroups.Address jgroupsAddress = TopologyInfo.toJGroupsAddress(address);
        String name = NameCache.get((org.jgroups.Address)jgroupsAddress);
        if (name == null) {
            Transport transport = (Transport)GlobalComponentRegistry.componentOf((EmbeddedCacheManager)cache.getCacheManager(), Transport.class);
            JChannel channel = ((JGroupsTransport)transport).getChannel();
            IpAddress ipAddress = (IpAddress)channel.getProtocolStack().getTransport().localPhysicalAddress();
            InetSocketAddress socketAddress = ipAddress != null ? new InetSocketAddress(ipAddress.getIpAddress(), ipAddress.getPort()) : new InetSocketAddress(0);
            name = String.format("%s:%s", socketAddress.getHostString(), socketAddress.getPort());
            logger.debugf("Address not found in NameCache. Fallback to %s", (Object)name);
        }
        return name;
    }

    private Address getOwnerAddress(Cache<?, ?> cache, Object key) {
        DistributionManager dist = cache.getAdvancedCache().getDistributionManager();
        return dist == null ? cache.getCacheManager().getAddress() : dist.getCacheTopology().getDistribution(key).primary();
    }

    private static org.jgroups.Address toJGroupsAddress(Address address) {
        if (address == null || address == LocalModeAddress.INSTANCE) {
            return null;
        }
        if (address instanceof JGroupsAddress) {
            JGroupsAddress jgroupsAddress = (JGroupsAddress)address;
            return jgroupsAddress.getJGroupsAddress();
        }
        throw new IllegalArgumentException(address.toString());
    }
}

