/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.models.AbstractKeycloakTransaction;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.sessions.infinispan.SessionFunction;
import org.keycloak.models.sessions.infinispan.changes.EmbeddedCachesChangesPerformer;
import org.keycloak.models.sessions.infinispan.changes.JpaChangesPerformer;
import org.keycloak.models.sessions.infinispan.changes.MergedUpdate;
import org.keycloak.models.sessions.infinispan.changes.PersistentSessionUpdateTask;
import org.keycloak.models.sessions.infinispan.changes.PersistentUpdate;
import org.keycloak.models.sessions.infinispan.changes.RemoteCachesChangesPerformer;
import org.keycloak.models.sessions.infinispan.changes.SerializeExecutionsByKey;
import org.keycloak.models.sessions.infinispan.changes.SessionChangesPerformer;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdateTask;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdatesList;
import org.keycloak.models.sessions.infinispan.changes.SessionsChangelogBasedTransaction;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.remotestore.RemoteCacheInvoker;
import org.keycloak.models.utils.KeycloakModelUtils;

public abstract class PersistentSessionsChangelogBasedTransaction<K, V extends SessionEntity>
extends AbstractKeycloakTransaction
implements SessionsChangelogBasedTransaction<K, V> {
    private static final Logger LOG = Logger.getLogger(PersistentSessionsChangelogBasedTransaction.class);
    protected final KeycloakSession kcSession;
    protected final Map<K, SessionUpdatesList<V>> updates = new HashMap<K, SessionUpdatesList<V>>();
    protected final Map<K, SessionUpdatesList<V>> offlineUpdates = new HashMap<K, SessionUpdatesList<V>>();
    private final String cacheName;
    private final Cache<K, SessionEntityWrapper<V>> cache;
    private final Cache<K, SessionEntityWrapper<V>> offlineCache;
    private final RemoteCacheInvoker remoteCacheInvoker;
    private final SessionFunction<V> lifespanMsLoader;
    private final SessionFunction<V> maxIdleTimeMsLoader;
    private final SessionFunction<V> offlineLifespanMsLoader;
    private final SessionFunction<V> offlineMaxIdleTimeMsLoader;
    private final ArrayBlockingQueue<PersistentUpdate> batchingQueue;
    private final SerializeExecutionsByKey<K> serializerOnline;
    private final SerializeExecutionsByKey<K> serializerOffline;

    public PersistentSessionsChangelogBasedTransaction(KeycloakSession session, String cacheName, Cache<K, SessionEntityWrapper<V>> cache, Cache<K, SessionEntityWrapper<V>> offlineCache, RemoteCacheInvoker remoteCacheInvoker, SessionFunction<V> lifespanMsLoader, SessionFunction<V> maxIdleTimeMsLoader, SessionFunction<V> offlineLifespanMsLoader, SessionFunction<V> offlineMaxIdleTimeMsLoader, ArrayBlockingQueue<PersistentUpdate> batchingQueue, SerializeExecutionsByKey<K> serializerOnline, SerializeExecutionsByKey<K> serializerOffline) {
        this.kcSession = session;
        this.cacheName = cacheName;
        this.cache = cache;
        this.offlineCache = offlineCache;
        this.remoteCacheInvoker = remoteCacheInvoker;
        this.lifespanMsLoader = lifespanMsLoader;
        this.maxIdleTimeMsLoader = maxIdleTimeMsLoader;
        this.offlineLifespanMsLoader = offlineLifespanMsLoader;
        this.offlineMaxIdleTimeMsLoader = offlineMaxIdleTimeMsLoader;
        this.batchingQueue = batchingQueue;
        this.serializerOnline = serializerOnline;
        this.serializerOffline = serializerOffline;
    }

    protected Cache<K, SessionEntityWrapper<V>> getCache(boolean offline) {
        if (offline) {
            return this.offlineCache;
        }
        return this.cache;
    }

    protected SessionFunction<V> getLifespanMsLoader(boolean offline) {
        if (offline) {
            return this.offlineLifespanMsLoader;
        }
        return this.lifespanMsLoader;
    }

    protected SessionFunction<V> getMaxIdleMsLoader(boolean offline) {
        if (offline) {
            return this.offlineMaxIdleTimeMsLoader;
        }
        return this.maxIdleTimeMsLoader;
    }

    protected Map<K, SessionUpdatesList<V>> getUpdates(boolean offline) {
        if (offline) {
            return this.offlineUpdates;
        }
        return this.updates;
    }

    public SessionEntityWrapper<V> get(K key, boolean offline) {
        SessionUpdatesList<Object> myUpdates = this.getUpdates(offline).get(key);
        if (myUpdates == null) {
            SessionEntityWrapper wrappedEntity = (SessionEntityWrapper)this.getCache(offline).get(key);
            if (wrappedEntity == null) {
                return null;
            }
            ((SessionEntity)wrappedEntity.getEntity()).setOffline(offline);
            RealmModel realm = this.kcSession.realms().getRealm(((SessionEntity)wrappedEntity.getEntity()).getRealmId());
            myUpdates = new SessionUpdatesList(realm, wrappedEntity);
            this.getUpdates(offline).put(key, myUpdates);
            return wrappedEntity;
        }
        V entity = myUpdates.getEntityWrapper().getEntity();
        boolean scheduledForRemove = myUpdates.getUpdateTasks().stream().map(SessionUpdateTask::getOperation).anyMatch(SessionUpdateTask.CacheOperation.REMOVE::equals);
        return scheduledForRemove ? null : myUpdates.getEntityWrapper();
    }

    List<SessionChangesPerformer<K, V>> prepareChangesPerformers() {
        LinkedList<SessionChangesPerformer<K, V>> changesPerformers = new LinkedList<SessionChangesPerformer<K, V>>();
        if (this.batchingQueue != null) {
            changesPerformers.add(new JpaChangesPerformer(this.cacheName, this.batchingQueue));
        } else {
            changesPerformers.add(new JpaChangesPerformer<K, V>(this.cacheName, null){

                @Override
                public void applyChanges() {
                    KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)PersistentSessionsChangelogBasedTransaction.this.kcSession.getKeycloakSessionFactory(), x$0 -> super.applyChangesSynchronously(x$0));
                }
            });
        }
        if (this.cache != null) {
            changesPerformers.add(new EmbeddedCachesChangesPerformer<K, V>(this.cache, this.serializerOnline){

                @Override
                public boolean shouldConsumeChange(V entity) {
                    return !((SessionEntity)entity).isOffline();
                }
            });
            changesPerformers.add(new RemoteCachesChangesPerformer<K, V>(this.kcSession, this.cache, this.remoteCacheInvoker){

                @Override
                public boolean shouldConsumeChange(V entity) {
                    return !((SessionEntity)entity).isOffline();
                }
            });
        }
        if (this.offlineCache != null) {
            changesPerformers.add(new EmbeddedCachesChangesPerformer<K, V>(this.offlineCache, this.serializerOffline){

                @Override
                public boolean shouldConsumeChange(V entity) {
                    return ((SessionEntity)entity).isOffline();
                }
            });
            changesPerformers.add(new RemoteCachesChangesPerformer<K, V>(this.kcSession, this.offlineCache, this.remoteCacheInvoker){

                @Override
                public boolean shouldConsumeChange(V entity) {
                    return ((SessionEntity)entity).isOffline();
                }
            });
        }
        return changesPerformers;
    }

    protected void commitImpl() {
        List<SessionChangesPerformer<K, V>> changesPerformers = null;
        for (Map.Entry entry : Stream.concat(this.updates.entrySet().stream(), this.offlineUpdates.entrySet().stream()).toList()) {
            SessionUpdatesList sessionUpdates = (SessionUpdatesList)entry.getValue();
            SessionEntityWrapper sessionWrapper = sessionUpdates.getEntityWrapper();
            Object entity = sessionWrapper.getEntity();
            boolean isOffline = ((SessionEntity)entity).isOffline();
            if (sessionUpdates.getPersistenceState() == UserSessionModel.SessionPersistenceState.TRANSIENT) continue;
            RealmModel realm = sessionUpdates.getRealm();
            long lifespanMs = this.getLifespanMsLoader(isOffline).apply(realm, sessionUpdates.getClient(), entity);
            long maxIdleTimeMs = this.getMaxIdleMsLoader(isOffline).apply(realm, sessionUpdates.getClient(), entity);
            MergedUpdate merged = MergedUpdate.computeUpdate(sessionUpdates.getUpdateTasks(), sessionWrapper, lifespanMs, maxIdleTimeMs);
            if (merged == null) continue;
            if (changesPerformers == null) {
                changesPerformers = this.prepareChangesPerformers();
            }
            changesPerformers.stream().filter(performer -> performer.shouldConsumeChange(entity)).forEach(p -> p.registerChange(entry, merged));
        }
        if (changesPerformers != null) {
            changesPerformers.forEach(SessionChangesPerformer::applyChanges);
        }
    }

    @Override
    public void addTask(K key, SessionUpdateTask<V> originalTask) {
        if (!(originalTask instanceof PersistentSessionUpdateTask)) {
            throw new IllegalArgumentException("Task must be instance of PersistentSessionUpdateTask");
        }
        PersistentSessionUpdateTask task = (PersistentSessionUpdateTask)originalTask;
        SessionUpdatesList<Object> myUpdates = this.getUpdates(task.isOffline()).get(key);
        if (myUpdates == null) {
            SessionEntityWrapper wrappedEntity = (SessionEntityWrapper)this.getCache(task.isOffline()).get(key);
            if (wrappedEntity == null) {
                LOG.tracef("Not present cache item for key %s", key);
                return;
            }
            ((SessionEntity)wrappedEntity.getEntity()).setOffline(task.isOffline());
            RealmModel realm = this.kcSession.realms().getRealm(((SessionEntity)wrappedEntity.getEntity()).getRealmId());
            myUpdates = new SessionUpdatesList(realm, wrappedEntity);
            this.getUpdates(task.isOffline()).put(key, myUpdates);
        }
        task.runUpdate(myUpdates.getEntityWrapper().getEntity());
        myUpdates.add(task);
    }

    public void addTask(K key, SessionUpdateTask<V> task, V entity, UserSessionModel.SessionPersistenceState persistenceState) {
        if (entity == null) {
            throw new IllegalArgumentException("Null entity not allowed");
        }
        RealmModel realm = this.kcSession.realms().getRealm(((SessionEntity)entity).getRealmId());
        SessionEntityWrapper<V> wrappedEntity = new SessionEntityWrapper<V>(entity);
        SessionUpdatesList<V> myUpdates = new SessionUpdatesList<V>(realm, wrappedEntity, persistenceState);
        this.getUpdates(((SessionEntity)entity).isOffline()).put(key, myUpdates);
        if (task != null) {
            task.runUpdate(entity);
            myUpdates.add(task);
        }
    }

    public void reloadEntityInCurrentTransaction(RealmModel realm, K key, SessionEntityWrapper<V> entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Null entity not allowed");
        }
        boolean offline = ((SessionEntity)entity.getEntity()).isOffline();
        SessionEntityWrapper latestEntity = (SessionEntityWrapper)this.getCache(offline).get(key);
        if (latestEntity == null) {
            return;
        }
        SessionUpdatesList newUpdates = new SessionUpdatesList(realm, latestEntity);
        SessionUpdatesList<V> existingUpdates = this.getUpdates(((SessionEntity)entity.getEntity()).isOffline()).get(key);
        if (existingUpdates != null) {
            newUpdates.setUpdateTasks(existingUpdates.getUpdateTasks());
        }
        this.getUpdates(((SessionEntity)entity.getEntity()).isOffline()).put(key, newUpdates);
    }

    protected void rollbackImpl() {
    }
}

