/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes.remote.updater;

import java.util.Objects;
import org.keycloak.models.sessions.infinispan.changes.remote.updater.Updater;

public abstract class BaseUpdater<K, V>
implements Updater<K, V> {
    private final K cacheKey;
    private final V cacheValue;
    private final long versionRead;
    private UpdaterState state;

    protected BaseUpdater(K cacheKey, V cacheValue, long versionRead, UpdaterState state) {
        this.cacheKey = Objects.requireNonNull(cacheKey);
        this.cacheValue = cacheValue;
        this.versionRead = versionRead;
        this.state = Objects.requireNonNull(state);
    }

    @Override
    public final K getKey() {
        return this.cacheKey;
    }

    @Override
    public final V getValue() {
        return this.cacheValue;
    }

    @Override
    public final long getVersionRead() {
        return this.versionRead;
    }

    @Override
    public final boolean isDeleted() {
        return this.state == UpdaterState.DELETED;
    }

    @Override
    public final boolean isCreated() {
        return this.state == UpdaterState.CREATED;
    }

    @Override
    public final boolean isReadOnly() {
        return this.state == UpdaterState.READ && this.isUnchanged();
    }

    @Override
    public final void markDeleted() {
        this.state = UpdaterState.DELETED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseUpdater that = (BaseUpdater)o;
        return this.cacheKey.equals(that.cacheKey);
    }

    public int hashCode() {
        return this.cacheKey.hashCode();
    }

    public String toString() {
        return "BaseUpdater{cacheKey=" + this.cacheKey + ", cacheValue=" + this.cacheValue + ", state=" + this.state + ", versionRead=" + this.versionRead + "}";
    }

    protected abstract boolean isUnchanged();

    protected static enum UpdaterState {
        CREATED,
        DELETED,
        READ;

    }
}

