/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.remote;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.cache.infinispan.events.AuthenticationSessionAuthNoteUpdateEvent;
import org.keycloak.models.sessions.infinispan.RootAuthenticationSessionAdapter;
import org.keycloak.models.sessions.infinispan.SessionEntityUpdater;
import org.keycloak.models.sessions.infinispan.entities.RootAuthenticationSessionEntity;
import org.keycloak.models.sessions.infinispan.remote.transaction.AuthenticationSessionTransaction;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.SessionExpiration;
import org.keycloak.sessions.AuthenticationSessionCompoundId;
import org.keycloak.sessions.AuthenticationSessionProvider;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public class RemoteInfinispanAuthenticationSessionProvider
implements AuthenticationSessionProvider {
    private final KeycloakSession session;
    private final AuthenticationSessionTransaction transaction;
    private final int authSessionsLimit;

    public RemoteInfinispanAuthenticationSessionProvider(KeycloakSession session, int authSessionsLimit, AuthenticationSessionTransaction transaction) {
        this.session = Objects.requireNonNull(session);
        this.authSessionsLimit = authSessionsLimit;
        this.transaction = Objects.requireNonNull(transaction);
    }

    public void close() {
    }

    public RootAuthenticationSessionModel createRootAuthenticationSession(RealmModel realm) {
        return this.createRootAuthenticationSession(realm, KeycloakModelUtils.generateId());
    }

    public RootAuthenticationSessionModel createRootAuthenticationSession(RealmModel realm, String id) {
        RootAuthenticationSessionEntity entity = new RootAuthenticationSessionEntity(id);
        entity.setRealmId(realm.getId());
        entity.setTimestamp(Time.currentTime());
        int expirationSeconds = SessionExpiration.getAuthSessionLifespan((RealmModel)realm);
        this.transaction.put(id, entity, (long)expirationSeconds, TimeUnit.SECONDS);
        return this.wrap(realm, entity);
    }

    public RootAuthenticationSessionModel getRootAuthenticationSession(RealmModel realm, String authenticationSessionId) {
        return this.wrap(realm, (RootAuthenticationSessionEntity)this.transaction.get(authenticationSessionId));
    }

    public void removeRootAuthenticationSession(RealmModel realm, RootAuthenticationSessionModel authenticationSession) {
        this.transaction.remove(authenticationSession.getId());
    }

    public void removeAllExpired() {
    }

    public void removeExpired(RealmModel realm) {
    }

    public void onRealmRemoved(RealmModel realm) {
        this.transaction.removeByRealmId(realm.getId());
    }

    public void onClientRemoved(RealmModel realm, ClientModel client) {
    }

    public void updateNonlocalSessionAuthNotes(AuthenticationSessionCompoundId compoundId, Map<String, String> authNotesFragment) {
        if (compoundId == null) {
            return;
        }
        ((ClusterProvider)this.session.getProvider(ClusterProvider.class)).notify("AUTHENTICATION_SESSION_EVENTS", (ClusterEvent)AuthenticationSessionAuthNoteUpdateEvent.create(compoundId.getRootSessionId(), compoundId.getTabId(), authNotesFragment), true, ClusterProvider.DCNotify.ALL_BUT_LOCAL_DC);
    }

    private RootAuthenticationSessionAdapter wrap(RealmModel realm, RootAuthenticationSessionEntity entity) {
        return entity == null ? null : new RootAuthenticationSessionAdapter(this.session, new RootAuthenticationSessionUpdater(realm, entity, this.transaction), realm, this.authSessionsLimit);
    }

    private record RootAuthenticationSessionUpdater(RealmModel realm, RootAuthenticationSessionEntity entity, AuthenticationSessionTransaction transaction) implements SessionEntityUpdater<RootAuthenticationSessionEntity>
    {
        @Override
        public RootAuthenticationSessionEntity getEntity() {
            return this.entity;
        }

        @Override
        public void onEntityUpdated() {
            int expirationSeconds = this.entity.getTimestamp() - Time.currentTime() + SessionExpiration.getAuthSessionLifespan((RealmModel)this.realm);
            this.transaction.replace(this.entity.getId(), this.entity, expirationSeconds, TimeUnit.SECONDS);
        }

        @Override
        public void onEntityRemoved() {
            this.transaction.remove(this.entity.getId());
        }
    }
}

