/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.cache.infinispan.UpdateCounter;
import org.keycloak.models.cache.infinispan.entities.Revisioned;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;

public abstract class CacheManager {
    protected final Cache<String, Long> revisions;
    protected final Cache<String, Revisioned> cache;
    protected final UpdateCounter counter = new UpdateCounter();

    public CacheManager(Cache<String, Revisioned> cache, Cache<String, Long> revisions) {
        this.cache = cache;
        this.revisions = revisions;
    }

    protected abstract Logger getLogger();

    public Cache<String, Revisioned> getCache() {
        return this.cache;
    }

    public long getCurrentCounter() {
        return this.counter.current();
    }

    public Long getCurrentRevision(String id) {
        Long revision = (Long)this.revisions.get((Object)id);
        if (revision == null) {
            revision = this.counter.current();
        }
        return revision;
    }

    public void endRevisionBatch() {
        try {
            this.revisions.endBatch(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public <T> T get(String id, Class<T> type) {
        long oRev;
        Revisioned o = (Revisioned)this.cache.get((Object)id);
        if (o == null) {
            return null;
        }
        Long rev = (Long)this.revisions.get((Object)id);
        if (rev == null) {
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().tracev("get() missing rev {0}", (Object)id);
            }
            return null;
        }
        long l = oRev = o.getRevision() == null ? -1L : o.getRevision();
        if (rev > oRev) {
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().tracev("get() rev: {0} o.rev: {1}", (Object)rev, (Object)oRev);
            }
            return null;
        }
        return o != null && type.isInstance(o) ? (T)type.cast(o) : null;
    }

    public Object invalidateObject(String id) {
        Revisioned removed = (Revisioned)this.cache.remove((Object)id);
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().tracef("Removed key='%s', value='%s' from cache", (Object)id, (Object)removed);
        }
        this.bumpVersion(id);
        return removed;
    }

    protected void bumpVersion(String id) {
        long next = this.counter.next();
        Object rev = this.revisions.put((Object)id, (Object)next);
    }

    public void addRevisioned(Revisioned object, long startupRevision) {
        this.addRevisioned(object, startupRevision, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRevisioned(Revisioned object, long startupRevision, long lifespan) {
        String id = object.getId();
        try {
            Long rev = (Long)this.revisions.get((Object)id);
            if (rev == null) {
                rev = this.counter.current();
                this.revisions.put((Object)id, (Object)rev);
            }
            this.revisions.startBatch();
            if (!this.revisions.getAdvancedCache().lock((Object[])new String[]{id})) {
                if (this.getLogger().isTraceEnabled()) {
                    this.getLogger().tracev("Could not obtain version lock: {0}", (Object)id);
                }
                return;
            }
            rev = (Long)this.revisions.get((Object)id);
            if (rev == null) {
                return;
            }
            if (rev > startupRevision) {
                if (this.getLogger().isTraceEnabled()) {
                    this.getLogger().tracev("Skipped cache. Current revision {0}, Transaction start revision {1}", (Object)object.getRevision(), (Object)startupRevision);
                }
                return;
            }
            if (rev.equals(object.getRevision())) {
                this.cache.putForExternalRead((Object)id, (Object)object);
                return;
            }
            if (rev > object.getRevision()) {
                if (this.getLogger().isTraceEnabled()) {
                    this.getLogger().tracev("Skipped cache. Object revision {0}, Cache revision {1}", (Object)object.getRevision(), (Object)rev);
                }
                return;
            }
            this.revisions.put((Object)id, (Object)object.getRevision());
            if (lifespan < 0L) {
                this.cache.putForExternalRead((Object)id, (Object)object);
            } else {
                this.cache.putForExternalRead((Object)id, (Object)object, lifespan, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this.endRevisionBatch();
        }
    }

    public void clear() {
        this.cache.clear();
        this.revisions.clear();
    }

    public void addInvalidations(Predicate<Map.Entry<String, Revisioned>> predicate, Set<String> invalidations) {
        Iterator<Map.Entry<String, Revisioned>> it = this.getEntryIterator(predicate);
        while (it.hasNext()) {
            invalidations.add(it.next().getKey());
        }
    }

    private Iterator<Map.Entry<String, Revisioned>> getEntryIterator(Predicate<Map.Entry<String, Revisioned>> predicate) {
        return this.cache.entrySet().stream().filter(predicate).iterator();
    }

    public void sendInvalidationEvents(KeycloakSession session, Collection<InvalidationEvent> invalidationEvents) {
        ClusterProvider clusterProvider = (ClusterProvider)session.getProvider(ClusterProvider.class);
        for (InvalidationEvent event : invalidationEvents) {
            clusterProvider.notify(this.generateEventId(event), (ClusterEvent)event, true);
        }
    }

    protected String generateEventId(InvalidationEvent event) {
        return event.getId() + "_" + event.hashCode();
    }

    public void invalidationEventReceived(InvalidationEvent event) {
        HashSet<String> invalidations = new HashSet<String>();
        this.addInvalidationsFromEvent(event, invalidations);
        this.getLogger().debugf("[%s] Invalidating %d cache items after received event %s", (Object)this.cache.getCacheManager().getAddress(), (Object)invalidations.size(), (Object)event);
        for (String invalidation : invalidations) {
            this.invalidateObject(invalidation);
        }
    }

    protected abstract void addInvalidationsFromEvent(InvalidationEvent var1, Set<String> var2);
}

