/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization.entities;

import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.Scope;
import org.keycloak.models.cache.infinispan.authorization.entities.InResourceServer;
import org.keycloak.models.cache.infinispan.entities.AbstractRevisioned;

public class CachedResource
extends AbstractRevisioned
implements InResourceServer {
    private String resourceServerId;
    private String iconUri;
    private String owner;
    private String type;
    private String name;
    private String uri;
    private Set<String> scopesIds;

    public CachedResource(Long revision, Resource resource) {
        super(revision, resource.getId());
        this.name = resource.getName();
        this.uri = resource.getUri();
        this.type = resource.getType();
        this.owner = resource.getOwner();
        this.iconUri = resource.getIconUri();
        this.resourceServerId = resource.getResourceServer().getId();
        this.scopesIds = resource.getScopes().stream().map(Scope::getId).collect(Collectors.toSet());
    }

    public String getName() {
        return this.name;
    }

    public String getUri() {
        return this.uri;
    }

    public String getType() {
        return this.type;
    }

    public String getIconUri() {
        return this.iconUri;
    }

    public String getOwner() {
        return this.owner;
    }

    @Override
    public String getResourceServerId() {
        return this.resourceServerId;
    }

    public Set<String> getScopesIds() {
        return this.scopesIds;
    }
}

