/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.initializer;

import java.io.Serializable;
import org.infinispan.Cache;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.sessions.infinispan.initializer.BaseCacheInitializer;
import org.keycloak.models.sessions.infinispan.initializer.InitializerState;
import org.keycloak.models.sessions.infinispan.initializer.SessionLoader;

public class SingleWorkerCacheInitializer
extends BaseCacheInitializer {
    private final KeycloakSession session;

    public SingleWorkerCacheInitializer(KeycloakSession session, Cache<String, Serializable> workCache, SessionLoader sessionLoader, String stateKeySuffix) {
        super(session.getKeycloakSessionFactory(), workCache, sessionLoader, stateKeySuffix, Integer.MAX_VALUE);
        this.session = session;
    }

    @Override
    protected void startLoading() {
        InitializerState state = this.getOrCreateInitializerState();
        while (!state.isFinished()) {
            this.sessionLoader.loadSessions(this.session, -1, -1);
            state.markSegmentFinished(0);
            this.saveStateToCache(state);
        }
        this.sessionLoader.afterAllSessionsLoaded(this);
    }
}

