/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.entities;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.sessions.infinispan.util.KeycloakMarshallUtil;

@SerializeWith(value=ExternalizerImpl.class)
public class AuthenticatedClientSessionEntity
implements Serializable {
    private String authMethod;
    private String redirectUri;
    private volatile int timestamp;
    private String action;
    private Set<String> roles;
    private Set<String> protocolMappers;
    private Map<String, String> notes = new ConcurrentHashMap<String, String>();
    private String currentRefreshToken;
    private int currentRefreshTokenUseCount;

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(int timestamp) {
        this.timestamp = timestamp;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public Set<String> getProtocolMappers() {
        return this.protocolMappers;
    }

    public void setProtocolMappers(Set<String> protocolMappers) {
        this.protocolMappers = protocolMappers;
    }

    public Map<String, String> getNotes() {
        return this.notes;
    }

    public void setNotes(Map<String, String> notes) {
        this.notes = notes;
    }

    public String getCurrentRefreshToken() {
        return this.currentRefreshToken;
    }

    public void setCurrentRefreshToken(String currentRefreshToken) {
        this.currentRefreshToken = currentRefreshToken;
    }

    public int getCurrentRefreshTokenUseCount() {
        return this.currentRefreshTokenUseCount;
    }

    public void setCurrentRefreshTokenUseCount(int currentRefreshTokenUseCount) {
        this.currentRefreshTokenUseCount = currentRefreshTokenUseCount;
    }

    public static class ExternalizerImpl
    implements Externalizer<AuthenticatedClientSessionEntity> {
        public void writeObject(ObjectOutput output, AuthenticatedClientSessionEntity session) throws IOException {
            MarshallUtil.marshallString((String)session.getAuthMethod(), (ObjectOutput)output);
            MarshallUtil.marshallString((String)session.getRedirectUri(), (ObjectOutput)output);
            MarshallUtil.marshallInt((ObjectOutput)output, (int)session.getTimestamp());
            MarshallUtil.marshallString((String)session.getAction(), (ObjectOutput)output);
            Map<String, String> notes = session.getNotes();
            KeycloakMarshallUtil.writeMap(notes, KeycloakMarshallUtil.STRING_EXT, KeycloakMarshallUtil.STRING_EXT, output);
            KeycloakMarshallUtil.writeCollection(session.getProtocolMappers(), KeycloakMarshallUtil.STRING_EXT, output);
            KeycloakMarshallUtil.writeCollection(session.getRoles(), KeycloakMarshallUtil.STRING_EXT, output);
            MarshallUtil.marshallString((String)session.getCurrentRefreshToken(), (ObjectOutput)output);
            MarshallUtil.marshallInt((ObjectOutput)output, (int)session.getCurrentRefreshTokenUseCount());
        }

        public AuthenticatedClientSessionEntity readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            AuthenticatedClientSessionEntity sessionEntity = new AuthenticatedClientSessionEntity();
            sessionEntity.setAuthMethod(MarshallUtil.unmarshallString((ObjectInput)input));
            sessionEntity.setRedirectUri(MarshallUtil.unmarshallString((ObjectInput)input));
            sessionEntity.setTimestamp(MarshallUtil.unmarshallInt((ObjectInput)input));
            sessionEntity.setAction(MarshallUtil.unmarshallString((ObjectInput)input));
            Object notes = KeycloakMarshallUtil.readMap(input, KeycloakMarshallUtil.STRING_EXT, KeycloakMarshallUtil.STRING_EXT, new KeycloakMarshallUtil.ConcurrentHashMapBuilder());
            sessionEntity.setNotes((Map<String, String>)notes);
            Set protocolMappers = (Set)KeycloakMarshallUtil.readCollection(input, KeycloakMarshallUtil.STRING_EXT, new KeycloakMarshallUtil.HashSetBuilder());
            sessionEntity.setProtocolMappers(protocolMappers);
            Set roles = (Set)KeycloakMarshallUtil.readCollection(input, KeycloakMarshallUtil.STRING_EXT, new KeycloakMarshallUtil.HashSetBuilder());
            sessionEntity.setRoles(roles);
            sessionEntity.setCurrentRefreshToken(MarshallUtil.unmarshallString((ObjectInput)input));
            sessionEntity.setCurrentRefreshTokenUseCount(MarshallUtil.unmarshallInt((ObjectInput)input));
            return sessionEntity;
        }
    }
}

