/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.remotestore;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.infinispan.client.hotrod.event.ClientCacheEntryCreatedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryModifiedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryRemovedEvent;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.jboss.logging.Logger;
import org.keycloak.common.util.MultivaluedHashMap;

public class ClientListenerExecutorDecorator<K> {
    private static final Logger logger = Logger.getLogger(ClientListenerExecutorDecorator.class);
    private final Object lock = new Object();
    private final ExecutorService decorated;
    private Map<K, MyClientEvent> eventsInProgress = new HashMap<K, MyClientEvent>();
    private MultivaluedHashMap<K, MyClientEventContext> eventsQueue = new MultivaluedHashMap();

    public ClientListenerExecutorDecorator(ExecutorService decorated) {
        this.decorated = decorated;
    }

    public void submit(ClientCacheEntryCreatedEvent<K> cacheEntryCreatedEvent, Runnable r) {
        MyClientEvent event = this.convertIspnClientEvent((ClientEvent)cacheEntryCreatedEvent);
        this.submit(event, r);
    }

    public void submit(ClientCacheEntryModifiedEvent<K> cacheEntryModifiedEvent, Runnable r) {
        MyClientEvent event = this.convertIspnClientEvent((ClientEvent)cacheEntryModifiedEvent);
        this.submit(event, r);
    }

    public void submit(ClientCacheEntryRemovedEvent<K> cacheEntryRemovedEvent, Runnable r) {
        MyClientEvent event = this.convertIspnClientEvent((ClientEvent)cacheEntryRemovedEvent);
        this.submit(event, r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submit(MyClientEvent event, Runnable r) {
        Object key = event.key;
        Object object = this.lock;
        synchronized (object) {
            if (!this.eventsInProgress.containsKey(key)) {
                this.submitImpl(key, event, r);
            } else {
                this.putEventToTheQueue(key, event, r);
            }
        }
    }

    private void submitImpl(K key, MyClientEvent event, Runnable r) {
        logger.debugf("Submitting event to the executor: %s", (Object)event.toString());
        this.eventsInProgress.put(key, event);
        Runnable decoratedRunnable = () -> {
            try {
                r.run();
            }
            finally {
                Object object = this.lock;
                synchronized (object) {
                    logger.debugf("Finished processing event by the executor: %s", (Object)event.toString());
                    this.eventsInProgress.remove(key);
                    this.pollQueue(key);
                }
            }
        };
        this.decorated.submit(decoratedRunnable);
    }

    private void pollQueue(K key) {
        if (this.eventsQueue.containsKey(key)) {
            List events = (List)this.eventsQueue.get(key);
            if (events.size() > 0) {
                MyClientEventContext nextEvent = (MyClientEventContext)events.remove(0);
                if (events.size() == 0) {
                    this.eventsQueue.remove(key);
                }
                this.submitImpl(key, nextEvent.event, nextEvent.r);
            } else {
                throw new IllegalStateException("Illegal state. Size was 0 for key " + key);
            }
        }
    }

    private void putEventToTheQueue(K key, MyClientEvent event, Runnable r) {
        logger.debugf("Calling putEventToTheQueue: %s", (Object)event.toString());
        if (!this.eventsQueue.containsKey(key)) {
            this.eventsQueue.putSingle(key, (Object)new MyClientEventContext(event, r));
        } else {
            List existingEvents = (List)this.eventsQueue.get(key);
            MyClientEventContext myNewEvent = new MyClientEventContext(event, r);
            block0 : switch (event.type) {
                case CLIENT_CACHE_ENTRY_CREATED: {
                    boolean add = true;
                    for (MyClientEventContext ctx : existingEvents) {
                        if (ctx.event.type == ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED) {
                            add = false;
                            break;
                        }
                        if (ctx.event.type != ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED) continue;
                        add = false;
                        break;
                    }
                    if (!add) break;
                    existingEvents.add(0, myNewEvent);
                    break;
                }
                case CLIENT_CACHE_ENTRY_MODIFIED: {
                    boolean addd = true;
                    for (int i = 0; i < existingEvents.size(); ++i) {
                        MyClientEventContext ctx = (MyClientEventContext)existingEvents.get(i);
                        if (ctx.event.type == ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED) {
                            addd = false;
                            break block0;
                        }
                        if (ctx.event.type != ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED) {
                            if (ctx.event.version < myNewEvent.event.version) {
                                existingEvents.remove(i);
                            } else {
                                addd = false;
                            }
                        }
                        if (!addd) continue;
                        existingEvents.add(myNewEvent);
                    }
                    break;
                }
                case CLIENT_CACHE_ENTRY_REMOVED: {
                    this.eventsQueue.putSingle(key, (Object)new MyClientEventContext(event, r));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported event type: " + event.type);
                }
            }
        }
        logger.debugf("Event queued. Current events for the key '%s': %s", (Object)key.toString(), (Object)this.eventsQueue.getList(key));
    }

    public MyClientEvent convertIspnClientEvent(ClientEvent ispnClientEvent) {
        if (ispnClientEvent instanceof ClientCacheEntryCreatedEvent) {
            ClientCacheEntryCreatedEvent ev = (ClientCacheEntryCreatedEvent)ispnClientEvent;
            return new MyClientEvent(ev.getKey(), ev.getVersion(), ev.getType());
        }
        if (ispnClientEvent instanceof ClientCacheEntryModifiedEvent) {
            ClientCacheEntryModifiedEvent ev = (ClientCacheEntryModifiedEvent)ispnClientEvent;
            return new MyClientEvent(ev.getKey(), ev.getVersion(), ev.getType());
        }
        if (ispnClientEvent instanceof ClientCacheEntryRemovedEvent) {
            ClientCacheEntryRemovedEvent ev = (ClientCacheEntryRemovedEvent)ispnClientEvent;
            return new MyClientEvent(ev.getKey(), -1L, ev.getType());
        }
        throw new IllegalStateException("Unsupported event type: " + ispnClientEvent.getType());
    }

    private class MyClientEvent {
        private final K key;
        private final long version;
        private final ClientEvent.Type type;

        private MyClientEvent(K key, long version, ClientEvent.Type type) {
            this.key = key;
            this.version = version;
            this.type = type;
        }

        public String toString() {
            return String.format("ClientEvent [ type=%s, key=%s, version=%d ]", this.type, this.key, this.version);
        }
    }

    private class MyClientEventContext {
        private final MyClientEvent event;
        private final Runnable r;

        private MyClientEventContext(MyClientEvent event, Runnable r) {
            this.event = event;
            this.r = r;
        }

        public String toString() {
            return this.event.toString();
        }
    }
}

