/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.persistence.remote.RemoteStore;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.cluster.ClusterListener;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.UserSessionProviderFactory;
import org.keycloak.models.sessions.infinispan.InfinispanUserSessionProvider;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.changes.sessions.LastSessionRefreshStore;
import org.keycloak.models.sessions.infinispan.changes.sessions.LastSessionRefreshStoreFactory;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.events.AbstractUserSessionClusterListener;
import org.keycloak.models.sessions.infinispan.events.ClientRemovedSessionEvent;
import org.keycloak.models.sessions.infinispan.events.RealmRemovedSessionEvent;
import org.keycloak.models.sessions.infinispan.events.RemoveAllUserLoginFailuresEvent;
import org.keycloak.models.sessions.infinispan.events.RemoveUserSessionsEvent;
import org.keycloak.models.sessions.infinispan.initializer.CacheInitializer;
import org.keycloak.models.sessions.infinispan.initializer.DBLockBasedCacheInitializer;
import org.keycloak.models.sessions.infinispan.initializer.InfinispanCacheInitializer;
import org.keycloak.models.sessions.infinispan.initializer.OfflinePersistentUserSessionLoader;
import org.keycloak.models.sessions.infinispan.remotestore.RemoteCacheInvoker;
import org.keycloak.models.sessions.infinispan.remotestore.RemoteCacheSessionListener;
import org.keycloak.models.sessions.infinispan.remotestore.RemoteCacheSessionsLoader;
import org.keycloak.models.sessions.infinispan.util.InfinispanUtil;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.PostMigrationEvent;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderEventListener;

public class InfinispanUserSessionProviderFactory
implements UserSessionProviderFactory {
    private static final Logger log = Logger.getLogger(InfinispanUserSessionProviderFactory.class);
    public static final String PROVIDER_ID = "infinispan";
    public static final String REALM_REMOVED_SESSION_EVENT = "REALM_REMOVED_EVENT_SESSIONS";
    public static final String CLIENT_REMOVED_SESSION_EVENT = "CLIENT_REMOVED_SESSION_SESSIONS";
    public static final String REMOVE_USER_SESSIONS_EVENT = "REMOVE_USER_SESSIONS_EVENT";
    public static final String REMOVE_ALL_LOGIN_FAILURES_EVENT = "REMOVE_ALL_LOGIN_FAILURES_EVENT";
    private Config.Scope config;
    private RemoteCacheInvoker remoteCacheInvoker;
    private LastSessionRefreshStore lastSessionRefreshStore;
    private LastSessionRefreshStore offlineLastSessionRefreshStore;

    public InfinispanUserSessionProvider create(KeycloakSession session) {
        InfinispanConnectionProvider connections = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        Cache cache = connections.getCache("sessions");
        Cache offlineSessionsCache = connections.getCache("offlineSessions");
        Cache clientSessionCache = connections.getCache("clientSessions");
        Cache offlineClientSessionsCache = connections.getCache("offlineClientSessions");
        Cache loginFailures = connections.getCache("loginFailures");
        return new InfinispanUserSessionProvider(session, this.remoteCacheInvoker, this.lastSessionRefreshStore, this.offlineLastSessionRefreshStore, cache, offlineSessionsCache, clientSessionCache, offlineClientSessionsCache, loginFailures);
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    public void postInit(final KeycloakSessionFactory factory) {
        factory.register(new ProviderEventListener(){

            public void onEvent(ProviderEvent event) {
                if (event instanceof PostMigrationEvent) {
                    KeycloakSession session = ((PostMigrationEvent)event).getSession();
                    InfinispanUserSessionProviderFactory.this.checkRemoteCaches(session);
                    InfinispanUserSessionProviderFactory.this.loadPersistentSessions(factory, InfinispanUserSessionProviderFactory.this.getMaxErrors(), InfinispanUserSessionProviderFactory.this.getSessionsPerSegment());
                    InfinispanUserSessionProviderFactory.this.registerClusterListeners(session);
                    InfinispanUserSessionProviderFactory.this.loadSessionsFromRemoteCaches(session);
                } else if (event instanceof UserModel.UserRemovedEvent) {
                    UserModel.UserRemovedEvent userRemovedEvent = (UserModel.UserRemovedEvent)event;
                    InfinispanUserSessionProvider provider = (InfinispanUserSessionProvider)userRemovedEvent.getKeycloakSession().getProvider(UserSessionProvider.class, InfinispanUserSessionProviderFactory.this.getId());
                    provider.onUserRemoved(userRemovedEvent.getRealm(), userRemovedEvent.getUser());
                }
            }
        });
    }

    private int getMaxErrors() {
        return this.config.getInt("maxErrors", Integer.valueOf(20));
    }

    private int getSessionsPerSegment() {
        return this.config.getInt("sessionsPerSegment", Integer.valueOf(100));
    }

    public void loadPersistentSessions(final KeycloakSessionFactory sessionFactory, final int maxErrors, final int sessionsPerSegment) {
        log.debug((Object)"Start pre-loading userSessions from persistent storage");
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            public void run(KeycloakSession session) {
                InfinispanConnectionProvider connections = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
                Cache workCache = connections.getCache("work");
                InfinispanCacheInitializer ispnInitializer = new InfinispanCacheInitializer(sessionFactory, workCache, new OfflinePersistentUserSessionLoader(), "offlineUserSessions", sessionsPerSegment, maxErrors);
                DBLockBasedCacheInitializer initializer = new DBLockBasedCacheInitializer(session, ispnInitializer);
                ((CacheInitializer)initializer).initCache();
                initializer.loadSessions();
            }
        });
        log.debug((Object)"Pre-loading userSessions from persistent storage finished");
    }

    protected void registerClusterListeners(KeycloakSession session) {
        KeycloakSessionFactory sessionFactory = session.getKeycloakSessionFactory();
        ClusterProvider cluster = (ClusterProvider)session.getProvider(ClusterProvider.class);
        cluster.registerListener(REALM_REMOVED_SESSION_EVENT, (ClusterListener)new AbstractUserSessionClusterListener<RealmRemovedSessionEvent>(sessionFactory){

            @Override
            protected void eventReceived(KeycloakSession session, InfinispanUserSessionProvider provider, RealmRemovedSessionEvent sessionEvent) {
                provider.onRealmRemovedEvent(sessionEvent.getRealmId());
            }
        });
        cluster.registerListener(CLIENT_REMOVED_SESSION_EVENT, (ClusterListener)new AbstractUserSessionClusterListener<ClientRemovedSessionEvent>(sessionFactory){

            @Override
            protected void eventReceived(KeycloakSession session, InfinispanUserSessionProvider provider, ClientRemovedSessionEvent sessionEvent) {
                provider.onClientRemovedEvent(sessionEvent.getRealmId(), sessionEvent.getClientUuid());
            }
        });
        cluster.registerListener(REMOVE_USER_SESSIONS_EVENT, (ClusterListener)new AbstractUserSessionClusterListener<RemoveUserSessionsEvent>(sessionFactory){

            @Override
            protected void eventReceived(KeycloakSession session, InfinispanUserSessionProvider provider, RemoveUserSessionsEvent sessionEvent) {
                provider.onRemoveUserSessionsEvent(sessionEvent.getRealmId());
            }
        });
        cluster.registerListener(REMOVE_ALL_LOGIN_FAILURES_EVENT, (ClusterListener)new AbstractUserSessionClusterListener<RemoveAllUserLoginFailuresEvent>(sessionFactory){

            @Override
            protected void eventReceived(KeycloakSession session, InfinispanUserSessionProvider provider, RemoveAllUserLoginFailuresEvent sessionEvent) {
                provider.onRemoveAllUserLoginFailuresEvent(sessionEvent.getRealmId());
            }
        });
        log.debug((Object)"Registered cluster listeners");
    }

    protected void checkRemoteCaches(KeycloakSession session) {
        this.remoteCacheInvoker = new RemoteCacheInvoker();
        InfinispanConnectionProvider ispn = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        Cache sessionsCache = ispn.getCache("sessions");
        boolean sessionsRemoteCache = this.checkRemoteCache(session, sessionsCache, realm -> realm.getSsoSessionMaxLifespan() * 1000);
        if (sessionsRemoteCache) {
            this.lastSessionRefreshStore = new LastSessionRefreshStoreFactory().createAndInit(session, sessionsCache, false);
        }
        Cache clientSessionsCache = ispn.getCache("clientSessions");
        this.checkRemoteCache(session, clientSessionsCache, realm -> realm.getSsoSessionMaxLifespan() * 1000);
        Cache offlineSessionsCache = ispn.getCache("offlineSessions");
        boolean offlineSessionsRemoteCache = this.checkRemoteCache(session, offlineSessionsCache, realm -> realm.getOfflineSessionIdleTimeout() * 1000);
        if (offlineSessionsRemoteCache) {
            this.offlineLastSessionRefreshStore = new LastSessionRefreshStoreFactory().createAndInit(session, offlineSessionsCache, true);
        }
        Cache offlineClientSessionsCache = ispn.getCache("offlineClientSessions");
        this.checkRemoteCache(session, offlineClientSessionsCache, realm -> realm.getOfflineSessionIdleTimeout() * 1000);
        Cache loginFailuresCache = ispn.getCache("loginFailures");
        this.checkRemoteCache(session, loginFailuresCache, realm -> realm.getMaxDeltaTimeSeconds() * 1000);
    }

    private <K, V extends SessionEntity> boolean checkRemoteCache(KeycloakSession session, Cache<K, SessionEntityWrapper<V>> ispnCache, RemoteCacheInvoker.MaxIdleTimeLoader maxIdleLoader) {
        Set<RemoteStore> remoteStores = InfinispanUtil.getRemoteStores(ispnCache);
        if (remoteStores.isEmpty()) {
            log.debugf("No remote store configured for cache '%s'", (Object)ispnCache.getName());
            return false;
        }
        log.infof("Remote store configured for cache '%s'", (Object)ispnCache.getName());
        RemoteCache remoteCache = remoteStores.iterator().next().getRemoteCache();
        if (remoteCache == null) {
            throw new IllegalStateException("No remote cache available for the infinispan cache: " + ispnCache.getName());
        }
        this.remoteCacheInvoker.addRemoteCache(ispnCache.getName(), remoteCache, maxIdleLoader);
        RemoteCacheSessionListener hotrodListener = RemoteCacheSessionListener.createListener(session, ispnCache, remoteCache);
        remoteCache.addClientListener((Object)hotrodListener);
        return true;
    }

    private void loadSessionsFromRemoteCaches(KeycloakSession session) {
        for (String cacheName : this.remoteCacheInvoker.getRemoteCacheNames()) {
            this.loadSessionsFromRemoteCache(session.getKeycloakSessionFactory(), cacheName, this.getSessionsPerSegment(), this.getMaxErrors());
        }
    }

    private void loadSessionsFromRemoteCache(final KeycloakSessionFactory sessionFactory, final String cacheName, final int sessionsPerSegment, final int maxErrors) {
        log.debugf("Check pre-loading sessions from remote cache '%s'", (Object)cacheName);
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            public void run(KeycloakSession session) {
                InfinispanConnectionProvider connections = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
                Cache workCache = connections.getCache("work");
                InfinispanCacheInitializer initializer = new InfinispanCacheInitializer(sessionFactory, workCache, new RemoteCacheSessionsLoader(cacheName), "remoteCacheLoad::" + cacheName, sessionsPerSegment, maxErrors);
                initializer.initCache();
                initializer.loadSessions();
            }
        });
        log.debugf("Pre-loading sessions from remote cache '%s' finished", (Object)cacheName);
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }
}

