/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.utils;

import org.jboss.logging.Logger;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.authentication.ClientAuthenticator;
import org.keycloak.authentication.ClientAuthenticatorFactory;
import org.keycloak.authentication.ConfigurableAuthenticatorFactory;
import org.keycloak.authentication.FormAction;
import org.keycloak.authentication.FormActionFactory;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.credential.OTPCredentialModel;
import org.keycloak.representations.idm.CredentialRepresentation;

public class CredentialHelper {
    private static final Logger logger = Logger.getLogger(CredentialHelper.class);

    public static void setRequiredCredential(KeycloakSession session, String type, RealmModel realm) {
        AuthenticationExecutionModel.Requirement requirement = AuthenticationExecutionModel.Requirement.REQUIRED;
        CredentialHelper.setOrReplaceAuthenticationRequirement(session, realm, type, requirement, null);
    }

    public static void setAlternativeCredential(KeycloakSession session, String type, RealmModel realm) {
        AuthenticationExecutionModel.Requirement requirement = AuthenticationExecutionModel.Requirement.ALTERNATIVE;
        CredentialHelper.setOrReplaceAuthenticationRequirement(session, realm, type, requirement, null);
    }

    public static void setOrReplaceAuthenticationRequirement(KeycloakSession session, RealmModel realm, String type, AuthenticationExecutionModel.Requirement requirement, AuthenticationExecutionModel.Requirement currentRequirement) {
        for (AuthenticationFlowModel flow : realm.getAuthenticationFlows()) {
            for (AuthenticationExecutionModel execution : realm.getAuthenticationExecutions(flow.getId())) {
                String providerId = execution.getAuthenticator();
                ConfigurableAuthenticatorFactory factory = CredentialHelper.getConfigurableAuthenticatorFactory(session, providerId);
                if (factory == null || !type.equals(factory.getReferenceCategory())) continue;
                if (currentRequirement == null || currentRequirement.equals((Object)execution.getRequirement())) {
                    execution.setRequirement(requirement);
                    realm.updateAuthenticatorExecution(execution);
                    logger.debugf("Authenticator execution '%s' switched to '%s'", (Object)execution.getAuthenticator(), (Object)requirement.toString());
                    continue;
                }
                logger.debugf("Skip switch authenticator execution '%s' to '%s' as it's in state %s", (Object)execution.getAuthenticator(), (Object)requirement.toString(), (Object)execution.getRequirement());
            }
        }
    }

    public static ConfigurableAuthenticatorFactory getConfigurableAuthenticatorFactory(KeycloakSession session, String providerId) {
        ConfigurableAuthenticatorFactory factory = (AuthenticatorFactory)session.getKeycloakSessionFactory().getProviderFactory(Authenticator.class, providerId);
        if (factory == null) {
            factory = (FormActionFactory)session.getKeycloakSessionFactory().getProviderFactory(FormAction.class, providerId);
        }
        if (factory == null) {
            factory = (ClientAuthenticatorFactory)session.getKeycloakSessionFactory().getProviderFactory(ClientAuthenticator.class, providerId);
        }
        return factory;
    }

    public static boolean createOTPCredential(KeycloakSession session, RealmModel realm, UserModel user, String totpCode, OTPCredentialModel credentialModel) {
        CredentialProvider otpCredentialProvider = (CredentialProvider)session.getProvider(CredentialProvider.class, "keycloak-otp");
        String totpSecret = credentialModel.getOTPSecretData().getValue();
        UserCredentialModel otpUserCredential = new UserCredentialModel("", realm.getOTPPolicy().getType(), totpSecret);
        boolean userStorageCreated = session.userCredentialManager().updateCredential(realm, user, (CredentialInput)otpUserCredential);
        String credentialId = null;
        if (userStorageCreated) {
            logger.debugf("Created OTP credential for user '%s' in the user storage", (Object)user.getUsername());
        } else {
            CredentialModel createdCredential = otpCredentialProvider.createCredential(realm, user, (CredentialModel)credentialModel);
            credentialId = createdCredential.getId();
        }
        UserCredentialModel credential = new UserCredentialModel(credentialId, otpCredentialProvider.getType(), totpCode);
        return session.userCredentialManager().isValid(realm, user, new CredentialInput[]{credential});
    }

    public static void deleteOTPCredential(KeycloakSession session, RealmModel realm, UserModel user, String credentialId) {
        CredentialProvider otpCredentialProvider = (CredentialProvider)session.getProvider(CredentialProvider.class, "keycloak-otp");
        boolean removed = otpCredentialProvider.deleteCredential(realm, user, credentialId);
        if (!removed) {
            logger.debug((Object)"Removing OTP credential from userStorage");
            session.userCredentialManager().disableCredentialType(realm, user, "otp");
        }
    }

    public static CredentialRepresentation createUserStorageCredentialRepresentation(String credentialProviderType) {
        CredentialRepresentation credential = new CredentialRepresentation();
        credential.setId(credentialProviderType + "-id");
        credential.setType(credentialProviderType);
        credential.setCreatedDate(Long.valueOf(-1L));
        credential.setPriority(Integer.valueOf(0));
        return credential;
    }
}

