/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.backend.marshalling.v1_1.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.kie.dmn.backend.marshalling.CustomStaxReader;
import org.kie.dmn.backend.marshalling.CustomStaxWriter;
import org.kie.dmn.backend.marshalling.v1_1.xstream.MarshallingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QNameConverter
implements Converter {
    private static final Logger LOG = LoggerFactory.getLogger(QNameConverter.class);

    public boolean canConvert(Class clazz) {
        return clazz.equals(QName.class);
    }

    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        QName qname = (QName)object;
        if (!"".equals(qname.getNamespaceURI()) && !"".equals(qname.getPrefix())) {
            CustomStaxWriter staxWriter = (CustomStaxWriter)writer.underlyingWriter();
            try {
                staxWriter.writeNamespace(qname.getPrefix(), qname.getNamespaceURI());
            }
            catch (XMLStreamException e) {
                LOG.error("Exception", (Throwable)e);
            }
        }
        writer.setValue(MarshallingUtils.formatQName(qname));
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        QName qname = MarshallingUtils.parseQNameString(reader.getValue());
        Map<String, String> currentNSCtx = ((CustomStaxReader)reader.underlyingReader()).getNsContext();
        String qnameURI = currentNSCtx.get(qname.getPrefix());
        if (qnameURI != null) {
            return new QName(qnameURI, qname.getLocalPart(), qname.getPrefix());
        }
        return qname;
    }
}

