/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.backend.marshalling.v1_2.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.kie.dmn.backend.marshalling.v1_2.xstream.EdgeConverter;
import org.kie.dmn.backend.marshalling.v1_2.xstream.MarshallingUtils;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.dmndi.DMNLabel;
import org.kie.dmn.model.v1_2.dmndi.DMNEdge;

public class DMNEdgeConverter
extends EdgeConverter {
    private static final String DMN_ELEMENT_REF = "dmnElementRef";
    private static final String DMN_LABEL = "DMNLabel";

    public DMNEdgeConverter(XStream xstream) {
        super(xstream);
    }

    @Override
    protected void assignChildElement(Object parent, String nodeName, Object child) {
        org.kie.dmn.model.api.dmndi.DMNEdge concrete = (org.kie.dmn.model.api.dmndi.DMNEdge)parent;
        if (child instanceof DMNLabel) {
            concrete.setDMNLabel((DMNLabel)child);
        } else {
            super.assignChildElement(parent, nodeName, child);
        }
    }

    @Override
    protected void assignAttributes(HierarchicalStreamReader reader, Object parent) {
        super.assignAttributes(reader, parent);
        org.kie.dmn.model.api.dmndi.DMNEdge concrete = (org.kie.dmn.model.api.dmndi.DMNEdge)parent;
        String dmnElementRef = reader.getAttribute(DMN_ELEMENT_REF);
        if (dmnElementRef != null) {
            concrete.setDmnElementRef(MarshallingUtils.parseQNameString(dmnElementRef));
        }
    }

    @Override
    protected void writeChildren(HierarchicalStreamWriter writer, MarshallingContext context, Object parent) {
        super.writeChildren(writer, context, parent);
        org.kie.dmn.model.api.dmndi.DMNEdge concrete = (org.kie.dmn.model.api.dmndi.DMNEdge)parent;
        if (concrete.getDMNLabel() != null) {
            this.writeChildrenNode(writer, context, concrete.getDMNLabel(), DMN_LABEL);
        }
    }

    @Override
    protected void writeAttributes(HierarchicalStreamWriter writer, Object parent) {
        super.writeAttributes(writer, parent);
        org.kie.dmn.model.api.dmndi.DMNEdge concrete = (org.kie.dmn.model.api.dmndi.DMNEdge)parent;
        if (concrete.getDmnElementRef() != null) {
            writer.addAttribute(DMN_ELEMENT_REF, MarshallingUtils.formatQName(concrete.getDmnElementRef(), (DMNModelInstrumentedBase)concrete));
        }
    }

    @Override
    protected DMNModelInstrumentedBase createModelObject() {
        return new DMNEdge();
    }

    public boolean canConvert(Class type) {
        return type.equals(DMNEdge.class);
    }
}

