/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.openapi.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.kie.dmn.api.core.DMNUnaryTest;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.codegen.feel11.ASTUnaryTestTransform;
import org.kie.dmn.feel.lang.CompilerContext;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.lang.ast.InfixOpNode;
import org.kie.dmn.feel.lang.ast.NullNode;
import org.kie.dmn.feel.lang.ast.RangeNode;
import org.kie.dmn.feel.lang.ast.UnaryTestListNode;
import org.kie.dmn.feel.lang.ast.UnaryTestNode;
import org.kie.dmn.feel.lang.ast.Visitor;
import org.kie.dmn.feel.lang.ast.visitor.ASTTemporalConstantVisitor;
import org.kie.dmn.feel.lang.impl.FEELBuilder;
import org.kie.dmn.feel.lang.impl.FEELEventListenersManager;
import org.kie.dmn.feel.lang.types.FEELTypeRegistry;
import org.kie.dmn.feel.parser.feel11.ASTBuilderVisitor;
import org.kie.dmn.feel.parser.feel11.FEELParser;
import org.kie.dmn.feel.parser.feel11.FEEL_1_1Parser;
import org.kie.dmn.openapi.impl.BaseNodeSchemaMapper;
import org.kie.dmn.openapi.impl.InfixOpNodeSchemaMapper;
import org.kie.dmn.openapi.impl.RangeNodeSchemaMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNUnaryTestsMapper {
    private static final Logger LOG = LoggerFactory.getLogger(DMNUnaryTestsMapper.class);

    public static void populateSchemaFromUnaryTests(Schema toPopulate, List<DMNUnaryTest> unaryTests) {
        LOG.debug("populateSchemaFromUnaryTests {} {}", (Object)toPopulate, unaryTests);
        List<BaseNode> unaryEvaluationNodes = DMNUnaryTestsMapper.getUnaryEvaluationNodesFromUnaryTests(unaryTests);
        Map<Boolean, List<BaseNode>> map = unaryEvaluationNodes.stream().collect(Collectors.groupingBy(RangeNode.class::isInstance));
        if (map.containsKey(true)) {
            RangeNodeSchemaMapper.populateSchemaFromListOfRanges(toPopulate, map.get(true).stream().map(RangeNode.class::cast).toList());
        }
        if (map.containsKey(false)) {
            List<BaseNode> enumBaseNodes = map.get(false);
            List<BaseNode> nullNodes = enumBaseNodes.stream().filter(NullNode.class::isInstance).toList();
            if (nullNodes.size() > 1) {
                throw new IllegalArgumentException("At most one null value is allowed for enum definition");
            }
            toPopulate.setNullable(Boolean.valueOf(!nullNodes.isEmpty()));
            if (enumBaseNodes.size() > nullNodes.size()) {
                enumBaseNodes.forEach(unaryEvaluationNode -> DMNUnaryTestsMapper.populateSchemaFromBaseNode(toPopulate, unaryEvaluationNode));
            }
        }
    }

    static void populateSchemaFromBaseNode(Schema toPopulate, BaseNode unaryEvaluationNode) {
        LOG.debug("populateSchemaFromBaseNode {} {}", (Object)toPopulate, (Object)unaryEvaluationNode);
        if (unaryEvaluationNode instanceof InfixOpNode) {
            InfixOpNode infixOpNode = (InfixOpNode)unaryEvaluationNode;
            InfixOpNodeSchemaMapper.populateSchemaFromFunctionInvocationNode(toPopulate, infixOpNode);
        } else {
            BaseNodeSchemaMapper.populateSchemaFromBaseNode(toPopulate, unaryEvaluationNode);
        }
    }

    static List<BaseNode> getUnaryEvaluationNodesFromUnaryTests(List<DMNUnaryTest> unaryTests) {
        LOG.debug("getUnaryEvaluationNodesFromUnaryTests {}", unaryTests);
        List<BaseNode> baseNodes = unaryTests.stream().map(dmnUnaryTest -> DMNUnaryTestsMapper.getBaseNode(dmnUnaryTest.toString())).toList();
        return baseNodes.stream().map(baseNode -> ((UnaryTestNode)((UnaryTestListNode)baseNode).getElements().get(0)).getValue()).toList();
    }

    static BaseNode getBaseNode(String expression) {
        LOG.debug("getBaseNode {}", (Object)expression);
        FEEL feelInstance = FEELBuilder.builder().build();
        CompilerContext ctx = feelInstance.newCompilerContext();
        FEEL_1_1Parser.UnaryTestsRootContext tree = DMNUnaryTestsMapper.getFEELParser(expression, ctx).unaryTestsRoot();
        ASTBuilderVisitor astVisitor = new ASTBuilderVisitor(ctx.getInputVariableTypes(), ctx.getFEELFeelTypeRegistry());
        BaseNode initialAst = (BaseNode)tree.accept((ParseTreeVisitor)astVisitor);
        BaseNode toReturn = ((ASTUnaryTestTransform.UnaryTestSubexpr)initialAst.accept((Visitor)new ASTUnaryTestTransform())).node();
        if (astVisitor.isVisitedTemporalCandidate()) {
            toReturn.accept((Visitor)new ASTTemporalConstantVisitor(ctx));
        }
        return toReturn;
    }

    static FEEL_1_1Parser getFEELParser(String expression, CompilerContext ctx) {
        LOG.debug("getFEELParser {} {}", (Object)expression, (Object)ctx);
        FEELEventListenersManager eventsManager = new FEELEventListenersManager();
        return FEELParser.parse((FEELEventListenersManager)eventsManager, (String)expression, (Map)ctx.getInputVariableTypes(), (Map)ctx.getInputVariables(), (Collection)ctx.getFEELFunctions(), Collections.emptyList(), (FEELTypeRegistry)ctx.getFEELFeelTypeRegistry());
    }

    private DMNUnaryTestsMapper() {
    }
}

