/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.openapi.impl;

import java.math.BigDecimal;
import java.util.List;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.kie.dmn.feel.lang.ast.AtLiteralNode;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.lang.ast.NumberNode;
import org.kie.dmn.feel.lang.ast.RangeNode;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.runtime.impl.RangeImpl;
import org.kie.dmn.openapi.impl.MapperHelper;

public class RangeNodeSchemaMapper {
    static void populateSchemaFromListOfRanges(Schema toPopulate, List<RangeNode> ranges) {
        Range range = RangeNodeSchemaMapper.consolidateRanges(ranges);
        if (range != null) {
            BigDecimal bigDecimal;
            Comparable comparable;
            if (range.getLowEndPoint() != null) {
                comparable = range.getLowEndPoint();
                if (comparable instanceof BigDecimal) {
                    bigDecimal = (BigDecimal)comparable;
                    toPopulate.minimum(bigDecimal);
                } else {
                    toPopulate.addExtension("x-dmn-minimum-value", (Object)range.getLowEndPoint());
                }
                toPopulate.exclusiveMinimum(Boolean.valueOf(range.getLowBoundary() == Range.RangeBoundary.OPEN));
            }
            if (range.getHighEndPoint() != null) {
                comparable = range.getHighEndPoint();
                if (comparable instanceof BigDecimal) {
                    bigDecimal = (BigDecimal)comparable;
                    toPopulate.maximum(bigDecimal);
                } else {
                    toPopulate.addExtension("x-dmn-maximum-value", (Object)range.getHighEndPoint());
                }
                toPopulate.exclusiveMaximum(Boolean.valueOf(range.getHighBoundary() == Range.RangeBoundary.OPEN));
            }
        }
    }

    static Range consolidateRanges(List<RangeNode> ranges) {
        boolean consistent = true;
        RangeImpl result = new RangeImpl();
        for (RangeNode r : ranges) {
            Comparable<BigDecimal> lowValue = null;
            BaseNode baseNode = r.getStart();
            if (baseNode instanceof NumberNode) {
                NumberNode startNode = (NumberNode)baseNode;
                lowValue = startNode.getValue();
            } else {
                baseNode = r.getStart();
                if (baseNode instanceof AtLiteralNode) {
                    AtLiteralNode atLiteralNode = (AtLiteralNode)baseNode;
                    Object evaluated = MapperHelper.evaluateAtLiteralNode(atLiteralNode);
                    Comparable comparable = lowValue = evaluated instanceof Comparable ? (Comparable)evaluated : null;
                }
            }
            if (lowValue != null) {
                if (result.getLowEndPoint() == null) {
                    result = new RangeImpl(Range.RangeBoundary.valueOf((String)r.getLowerBound().name()), (Comparable)lowValue, result.getHighEndPoint(), result.getHighBoundary());
                } else {
                    consistent = false;
                }
            }
            Comparable<BigDecimal> highValue = null;
            BaseNode baseNode2 = r.getEnd();
            if (baseNode2 instanceof NumberNode) {
                NumberNode endNode = (NumberNode)baseNode2;
                highValue = endNode.getValue();
            } else {
                baseNode2 = r.getEnd();
                if (baseNode2 instanceof AtLiteralNode) {
                    AtLiteralNode atLiteralNode = (AtLiteralNode)baseNode2;
                    Object evaluated = MapperHelper.evaluateAtLiteralNode(atLiteralNode);
                    Comparable comparable = highValue = evaluated instanceof Comparable ? (Comparable)evaluated : null;
                }
            }
            if (highValue == null) continue;
            if (result.getHighEndPoint() == null) {
                result = new RangeImpl(result.getLowBoundary(), result.getLowEndPoint(), (Comparable)highValue, Range.RangeBoundary.valueOf((String)r.getUpperBound().name()));
                continue;
            }
            consistent = false;
        }
        return consistent ? result : null;
    }

    private RangeNodeSchemaMapper() {
    }
}

