/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.runtime.conf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class ObjectModel
implements Serializable {
    private static final long serialVersionUID = 6079949171686382208L;
    @XmlElement(name="resolver")
    @XmlSchemaType(name="string")
    private String resolver = "reflection";
    @XmlElement(name="identifier")
    @XmlSchemaType(name="string")
    private String identifier;
    @XmlElement(name="parameter")
    @XmlElementWrapper(name="parameters")
    private List<Object> parameters = new ArrayList<Object>();

    public ObjectModel() {
    }

    public ObjectModel(String identifier, Object ... parameters) {
        this.identifier = identifier;
        if (parameters != null) {
            this.parameters = new ArrayList<Object>(Arrays.asList(parameters));
        }
    }

    public ObjectModel(String resolver, String identifier, Object ... parameters) {
        this.resolver = resolver;
        this.identifier = identifier;
        if (parameters != null) {
            this.parameters = new ArrayList<Object>(Arrays.asList(parameters));
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String classname) {
        this.identifier = classname;
    }

    public List<Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Object> parameters) {
        this.parameters = parameters;
    }

    public void addParameter(Object parameter) {
        this.parameters.add(parameter);
    }

    public String getResolver() {
        return this.resolver;
    }

    public void setResolver(String resolver) {
        this.resolver = resolver;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.resolver == null ? 0 : this.resolver.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectModel other = (ObjectModel)obj;
        if (this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
            return false;
        }
        return !(this.resolver == null ? other.resolver != null : !this.resolver.equals(other.resolver));
    }
}

