/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model.predicates;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BinaryOperator;
import org.kie.pmml.commons.exceptions.KiePMMLException;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.model.abstracts.AbstractKiePMMLComponent;
import org.kie.pmml.commons.model.enums.BOOLEAN_OPERATOR;
import org.kie.pmml.commons.model.predicates.KiePMMLPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLCompoundPredicate
extends KiePMMLPredicate {
    private static final Logger logger = LoggerFactory.getLogger(KiePMMLCompoundPredicate.class);
    private final BOOLEAN_OPERATOR booleanOperator;
    protected BinaryOperator<Boolean> operatorFunction;
    protected List<KiePMMLPredicate> kiePMMLPredicates;

    protected KiePMMLCompoundPredicate(String name, List<KiePMMLExtension> extensions, BOOLEAN_OPERATOR booleanOperator) {
        super(name, extensions);
        this.booleanOperator = booleanOperator;
    }

    public static Builder builder(List<KiePMMLExtension> extensions, BOOLEAN_OPERATOR booleanOperator) {
        return new Builder(extensions, booleanOperator);
    }

    @Override
    public boolean evaluate(Map<String, Object> values) {
        Boolean toReturn = null;
        for (KiePMMLPredicate kiePMMLPredicate : this.kiePMMLPredicates) {
            toReturn = (Boolean)this.operatorFunction.apply(toReturn, kiePMMLPredicate.evaluate(values));
        }
        return toReturn != null && toReturn != false;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public BOOLEAN_OPERATOR getBooleanOperator() {
        return this.booleanOperator;
    }

    public List<KiePMMLPredicate> getKiePMMLPredicates() {
        return this.kiePMMLPredicates;
    }

    public String toString() {
        return "KiePMMLCompoundPredicate{booleanOperator=" + (Object)((Object)this.booleanOperator) + ", operatorFunction=" + this.operatorFunction + ", kiePMMLPredicates=" + this.kiePMMLPredicates + ", extensions=" + this.extensions + ", id='" + this.id + '\'' + ", parentId='" + this.parentId + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KiePMMLCompoundPredicate that = (KiePMMLCompoundPredicate)o;
        return this.booleanOperator == that.booleanOperator && Objects.equals(this.operatorFunction, that.operatorFunction) && Objects.equals(this.kiePMMLPredicates, that.kiePMMLPredicates);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.booleanOperator, this.operatorFunction, this.kiePMMLPredicates});
    }

    public static class Builder
    extends AbstractKiePMMLComponent.Builder<KiePMMLCompoundPredicate> {
        private Builder(List<KiePMMLExtension> extensions, BOOLEAN_OPERATOR booleanOperator) {
            super("CompoundPredicate-", () -> new KiePMMLCompoundPredicate("CompoundPredicate", extensions, booleanOperator));
            ((KiePMMLCompoundPredicate)this.toBuild).operatorFunction = this.getInnerBinaryOperator(booleanOperator);
        }

        public Builder withKiePMMLPredicates(List<KiePMMLPredicate> kiePMMLPredicates) {
            kiePMMLPredicates.forEach(predicate -> predicate.setParentId(((KiePMMLCompoundPredicate)this.toBuild).id));
            ((KiePMMLCompoundPredicate)this.toBuild).kiePMMLPredicates = kiePMMLPredicates;
            return this;
        }

        private BinaryOperator<Boolean> getInnerBinaryOperator(BOOLEAN_OPERATOR booleanOperator) {
            switch (booleanOperator) {
                case OR: {
                    return (aBoolean, aBoolean2) -> aBoolean != null ? aBoolean.booleanValue() || aBoolean2.booleanValue() : aBoolean2;
                }
                case AND: {
                    return (aBoolean, aBoolean2) -> aBoolean != null ? aBoolean.booleanValue() && aBoolean2.booleanValue() : aBoolean2;
                }
                case XOR: {
                    return (aBoolean, aBoolean2) -> aBoolean != null ? aBoolean ^ aBoolean2 : aBoolean2;
                }
                case SURROGATE: {
                    throw new IllegalArgumentException((Object)((Object)BOOLEAN_OPERATOR.SURROGATE) + " not supported, yet");
                }
            }
            throw new KiePMMLException("Unknown BOOLEAN_OPERATOR " + (Object)((Object)booleanOperator));
        }
    }
}

