/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import org.dmg.pmml.OutputField;
import org.kie.pmml.api.enums.RESULT_FEATURE;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLExpressionFactory;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;

public class KiePMMLOutputFieldFactory {
    static final String KIE_PMML_OUTPUTFIELD_TEMPLATE_JAVA = "KiePMMLOutputFieldTemplate.tmpl";
    static final String KIE_PMML_OUTPUTFIELD_TEMPLATE = "KiePMMLOutputFieldTemplate";
    static final String GETKIEPMMLOUTPUTFIELD = "getKiePMMLOutputField";
    static final String OUTPUTFIELD = "outputField";
    static final ClassOrInterfaceDeclaration OUTPUTFIELD_TEMPLATE;

    private KiePMMLOutputFieldFactory() {
    }

    static BlockStmt getOutputFieldVariableDeclaration(String variableName, OutputField outputField) {
        NullLiteralExpr expressionExpr;
        MethodDeclaration methodDeclaration = ((MethodDeclaration)OUTPUTFIELD_TEMPLATE.getMethodsByName(GETKIEPMMLOUTPUTFIELD).get(0)).clone();
        BlockStmt outputFieldBody = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new KiePMMLException(String.format("Missing body in %s", methodDeclaration)));
        VariableDeclarator variableDeclarator = CommonCodegenUtils.getVariableDeclarator(outputFieldBody, OUTPUTFIELD).orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", OUTPUTFIELD, outputFieldBody)));
        variableDeclarator.setName(variableName);
        BlockStmt toReturn = new BlockStmt();
        if (outputField.getExpression() != null) {
            String nestedVariableName = String.format("%s_Expression", variableName);
            BlockStmt toAdd = KiePMMLExpressionFactory.getKiePMMLExpression(nestedVariableName, outputField.getExpression());
            toAdd.getStatements().forEach(arg_0 -> ((BlockStmt)toReturn).addStatement(arg_0));
            expressionExpr = new NameExpr(nestedVariableName);
        } else {
            expressionExpr = new NullLiteralExpr();
        }
        MethodCallExpr initializer = ((Expression)variableDeclarator.getInitializer().orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' initializer in %s", OUTPUTFIELD, toReturn)))).asMethodCallExpr();
        MethodCallExpr builder = CommonCodegenUtils.getChainedMethodCallExprFrom("builder", initializer);
        StringLiteralExpr nameExpr = new StringLiteralExpr(outputField.getName().getValue());
        RESULT_FEATURE resultFeature = RESULT_FEATURE.byName((String)outputField.getResultFeature().value());
        NameExpr resultFeatureExpr = new NameExpr(RESULT_FEATURE.class.getName() + "." + resultFeature.name());
        NullLiteralExpr targetFieldExpr = outputField.getTargetField() != null ? CommonCodegenUtils.getExpressionForObject(outputField.getTargetField().getValue()) : new NullLiteralExpr();
        NullLiteralExpr valueExpr = outputField.getValue() != null ? CommonCodegenUtils.getExpressionForObject(outputField.getValue()) : new NullLiteralExpr();
        Expression dataTypeExpression = CommonCodegenUtils.getExpressionForDataType(outputField.getDataType());
        NullLiteralExpr rankExpr = outputField.getRank() != null ? CommonCodegenUtils.getExpressionForObject(outputField.getRank()) : new NullLiteralExpr();
        builder.setArgument(0, (Expression)nameExpr);
        CommonCodegenUtils.getChainedMethodCallExprFrom("withResultFeature", initializer).setArgument(0, (Expression)resultFeatureExpr);
        CommonCodegenUtils.getChainedMethodCallExprFrom("withTargetField", initializer).setArgument(0, (Expression)targetFieldExpr);
        CommonCodegenUtils.getChainedMethodCallExprFrom("withValue", initializer).setArgument(0, (Expression)valueExpr);
        CommonCodegenUtils.getChainedMethodCallExprFrom("withDataType", initializer).setArgument(0, dataTypeExpression);
        CommonCodegenUtils.getChainedMethodCallExprFrom("withRank", initializer).setArgument(0, (Expression)rankExpr);
        CommonCodegenUtils.getChainedMethodCallExprFrom("withKiePMMLExpression", initializer).setArgument(0, (Expression)expressionExpr);
        outputFieldBody.getStatements().forEach(arg_0 -> ((BlockStmt)toReturn).addStatement(arg_0));
        return toReturn;
    }

    static {
        CompilationUnit cloneCU = JavaParserUtils.getFromFileName(KIE_PMML_OUTPUTFIELD_TEMPLATE_JAVA);
        OUTPUTFIELD_TEMPLATE = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(KIE_PMML_OUTPUTFIELD_TEMPLATE).orElseThrow(() -> new KiePMMLException("Main class not found: KiePMMLOutputFieldTemplate"));
        ((MethodDeclaration)OUTPUTFIELD_TEMPLATE.getMethodsByName(GETKIEPMMLOUTPUTFIELD).get(0)).clone();
    }
}

