/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.codegenfactories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import org.apache.commons.text.StringEscapeUtils;
import org.dmg.pmml.TextIndex;
import org.dmg.pmml.TextIndexNormalization;
import org.kie.pmml.api.enums.COUNT_HITS;
import org.kie.pmml.api.enums.LOCAL_TERM_WEIGHTS;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLExpressionFactory;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLTextIndexNormalizationFactory;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;

public class KiePMMLTextIndexFactory {
    static final String KIE_PMML_TEXTINDEX_TEMPLATE_JAVA = "KiePMMLTextIndexTemplate.tmpl";
    static final String KIE_PMML_TEXTINDEX_TEMPLATE = "KiePMMLTextIndexTemplate";
    static final String GETKIEPMMLTEXTINDEX = "getKiePMMLTextIndex";
    static final String TEXTINDEX = "textIndex";
    static final ClassOrInterfaceDeclaration TEXTINDEX_TEMPLATE;

    private KiePMMLTextIndexFactory() {
    }

    static BlockStmt getTextIndexVariableDeclaration(String variableName, TextIndex textIndex) {
        NullLiteralExpr wordSeparatorCharacterREExpression;
        NullLiteralExpr countHitsExpression;
        NullLiteralExpr localTermWeightsExpression;
        MethodDeclaration methodDeclaration = ((MethodDeclaration)TEXTINDEX_TEMPLATE.getMethodsByName(GETKIEPMMLTEXTINDEX).get(0)).clone();
        BlockStmt textIndexBody = (BlockStmt)methodDeclaration.getBody().orElseThrow(() -> new KiePMMLException(String.format("Missing body in %s", methodDeclaration)));
        VariableDeclarator variableDeclarator = CommonCodegenUtils.getVariableDeclarator(textIndexBody, TEXTINDEX).orElseThrow(() -> new KiePMMLException(String.format("Missing expected variable '%s' in body %s", TEXTINDEX, textIndexBody)));
        variableDeclarator.setName(variableName);
        BlockStmt toReturn = new BlockStmt();
        String expressionVariableName = String.format("%s_Expression", variableName);
        BlockStmt expressionBlockStatement = KiePMMLExpressionFactory.getKiePMMLExpressionBlockStmt(expressionVariableName, textIndex.getExpression());
        expressionBlockStatement.getStatements().forEach(arg_0 -> ((BlockStmt)toReturn).addStatement(arg_0));
        int counter = 0;
        NodeList arguments = new NodeList();
        if (textIndex.hasTextIndexNormalizations()) {
            for (TextIndexNormalization textIndexNormalization : textIndex.getTextIndexNormalizations()) {
                String nestedVariableName = String.format("%s_%s", variableName, counter);
                arguments.add((Node)new NameExpr(nestedVariableName));
                BlockStmt toAdd = KiePMMLTextIndexNormalizationFactory.getTextIndexNormalizationVariableDeclaration(nestedVariableName, textIndexNormalization);
                toAdd.getStatements().forEach(arg_0 -> ((BlockStmt)toReturn).addStatement(arg_0));
                ++counter;
            }
        }
        MethodCallExpr initializer = ((Expression)variableDeclarator.getInitializer().orElseThrow(() -> new KiePMMLException(String.format("Missing '%s' initializer in %s", TEXTINDEX, toReturn)))).asMethodCallExpr();
        MethodCallExpr builder = CommonCodegenUtils.getChainedMethodCallExprFrom("builder", initializer);
        StringLiteralExpr nameExpr = new StringLiteralExpr(textIndex.getTextField().getValue());
        NameExpr expressionExpr = new NameExpr(expressionVariableName);
        builder.setArgument(0, (Expression)nameExpr);
        builder.setArgument(2, (Expression)expressionExpr);
        if (textIndex.getLocalTermWeights() != null) {
            LOCAL_TERM_WEIGHTS localTermWeights = LOCAL_TERM_WEIGHTS.byName((String)textIndex.getLocalTermWeights().value());
            localTermWeightsExpression = new NameExpr(LOCAL_TERM_WEIGHTS.class.getName() + "." + localTermWeights.name());
        } else {
            localTermWeightsExpression = new NullLiteralExpr();
        }
        CommonCodegenUtils.getChainedMethodCallExprFrom("withLocalTermWeights", initializer).setArgument(0, (Expression)localTermWeightsExpression);
        CommonCodegenUtils.getChainedMethodCallExprFrom("withIsCaseSensitive", initializer).setArgument(0, CommonCodegenUtils.getExpressionForObject(textIndex.isCaseSensitive()));
        CommonCodegenUtils.getChainedMethodCallExprFrom("withMaxLevenshteinDistance", initializer).setArgument(0, CommonCodegenUtils.getExpressionForObject(textIndex.getMaxLevenshteinDistance()));
        if (textIndex.getCountHits() != null) {
            COUNT_HITS countHits = COUNT_HITS.byName((String)textIndex.getCountHits().value());
            countHitsExpression = new NameExpr(COUNT_HITS.class.getName() + "." + countHits.name());
        } else {
            countHitsExpression = new NullLiteralExpr();
        }
        CommonCodegenUtils.getChainedMethodCallExprFrom("withCountHits", initializer).setArgument(0, (Expression)countHitsExpression);
        if (textIndex.getWordSeparatorCharacterRE() != null) {
            String wordSeparatorCharacterRE = StringEscapeUtils.escapeJava((String)textIndex.getWordSeparatorCharacterRE());
            wordSeparatorCharacterREExpression = new StringLiteralExpr(wordSeparatorCharacterRE);
        } else {
            wordSeparatorCharacterREExpression = new NullLiteralExpr();
        }
        CommonCodegenUtils.getChainedMethodCallExprFrom("withWordSeparatorCharacterRE", initializer).setArgument(0, (Expression)wordSeparatorCharacterREExpression);
        CommonCodegenUtils.getChainedMethodCallExprFrom("withTokenize", initializer).setArgument(0, CommonCodegenUtils.getExpressionForObject(textIndex.isTokenize()));
        CommonCodegenUtils.getChainedMethodCallExprFrom("asList", initializer).setArguments(arguments);
        textIndexBody.getStatements().forEach(arg_0 -> ((BlockStmt)toReturn).addStatement(arg_0));
        return toReturn;
    }

    static {
        CompilationUnit cloneCU = JavaParserUtils.getFromFileName(KIE_PMML_TEXTINDEX_TEMPLATE_JAVA);
        TEXTINDEX_TEMPLATE = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(KIE_PMML_TEXTINDEX_TEMPLATE).orElseThrow(() -> new KiePMMLException("Main class not found: KiePMMLTextIndexTemplate"));
        ((MethodDeclaration)TEXTINDEX_TEMPLATE.getMethodsByName(GETKIEPMMLTEXTINDEX).get(0)).clone();
    }
}

