/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.commons.factories;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.dmg.pmml.Target;
import org.dmg.pmml.TargetValue;
import org.kie.pmml.api.enums.CAST_INTEGER;
import org.kie.pmml.api.enums.OP_TYPE;
import org.kie.pmml.api.models.TargetField;
import org.kie.pmml.commons.model.KiePMMLTarget;

public class KiePMMLTargetInstanceFactory {
    private KiePMMLTargetInstanceFactory() {
    }

    public static KiePMMLTarget getKiePMMLTarget(Target target) {
        List targetValues = target.hasTargetValues() ? target.getTargetValues().stream().map(KiePMMLTargetInstanceFactory::getKieTargetValue).collect(Collectors.toList()) : Collections.emptyList();
        OP_TYPE opType = target.getOpType() != null ? OP_TYPE.byName((String)target.getOpType().value()) : null;
        String field = target.getField() != null ? target.getField().getValue() : null;
        CAST_INTEGER castInteger = target.getCastInteger() != null ? CAST_INTEGER.byName((String)target.getCastInteger().value()) : null;
        TargetField targetField = new TargetField(targetValues, opType, field, castInteger, target.getMin(), target.getMax(), target.getRescaleConstant(), target.getRescaleFactor());
        KiePMMLTarget.Builder builder = KiePMMLTarget.builder((String)targetField.getName(), Collections.emptyList(), (TargetField)targetField);
        return (KiePMMLTarget)builder.build();
    }

    private static org.kie.pmml.api.models.TargetValue getKieTargetValue(TargetValue source) {
        String value = source.getValue() != null ? source.getValue().toString() : null;
        String displayValue = source.getDisplayValue() != null ? source.getDisplayValue() : null;
        return new org.kie.pmml.api.models.TargetValue(value, displayValue, source.getPriorProbability(), source.getDefaultValue());
    }
}

