/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.compiler.service;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.kie.efesto.common.api.utils.FileNameUtils;
import org.kie.efesto.common.utils.PackageClassNameUtils;
import org.kie.efesto.compilationmanager.api.model.EfestoCompilationOutput;
import org.kie.efesto.compilationmanager.api.model.EfestoFileResource;
import org.kie.pmml.api.compilation.PMMLCompilationContext;
import org.kie.pmml.api.exceptions.ExternalException;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.compiler.executor.PMMLCompiler;
import org.kie.pmml.compiler.executor.PMMLCompilerImpl;
import org.kie.pmml.compiler.service.PMMLCompilerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMMLCompilerServicePMMLFile {
    private static final Logger logger = LoggerFactory.getLogger((String)PMMLCompilerServicePMMLFile.class.getName());
    private static final PMMLCompiler PMML_COMPILER = new PMMLCompilerImpl();

    private PMMLCompilerServicePMMLFile() {
    }

    public static List<EfestoCompilationOutput> getEfestoCompilationOutputPMML(EfestoFileResource resource, PMMLCompilationContext pmmlContext) {
        List<KiePMMLModel> kiePmmlModels = PMMLCompilerServicePMMLFile.getKiePMMLModelsFromFileResourcesWithConfigurationsWithSources(pmmlContext, Collections.singletonList(resource));
        return PMMLCompilerService.getEfestoFinalOutputPMML(kiePmmlModels, resource.getContent().getName(), pmmlContext);
    }

    static List<KiePMMLModel> getKiePMMLModelsFromFileResourcesWithConfigurationsWithSources(PMMLCompilationContext pmmlContext, Collection<EfestoFileResource> resources) {
        return resources.stream().flatMap(resource -> PMMLCompilerServicePMMLFile.getKiePMMLModelsFromResourceWithSources(pmmlContext, resource).stream()).collect(Collectors.toList());
    }

    static List<KiePMMLModel> getKiePMMLModelsFromResourceWithSources(PMMLCompilationContext pmmlContext, EfestoFileResource resource) {
        String[] classNamePackageName = PMMLCompilerServicePMMLFile.getFactoryClassNamePackageName(resource);
        String packageName = classNamePackageName[1];
        try {
            List<KiePMMLModel> toReturn = PMML_COMPILER.getKiePMMLModelsWithSources(packageName, resource.getInputStream(), FileNameUtils.getFileName((String)resource.getSourcePath()), pmmlContext);
            return toReturn;
        }
        catch (IOException e) {
            throw new ExternalException("ExternalException", (Throwable)e);
        }
    }

    static String[] getFactoryClassNamePackageName(EfestoFileResource resource) {
        String sourcePath = resource.getSourcePath();
        if (sourcePath == null || sourcePath.isEmpty()) {
            throw new IllegalArgumentException("Missing required sourcePath in resource " + resource + " -> " + resource.getClass().getName());
        }
        return PackageClassNameUtils.getFactoryClassNamePackageName((String)"pmml", (String)sourcePath);
    }
}

