/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.evaluator.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.kie.pmml.api.PMMLRuntimeFactory;
import org.kie.pmml.evaluator.utils.PMMLRuntimeFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPIUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)SPIUtils.class.getName());
    private static final ServiceLoader<PMMLRuntimeFactory> pmmlRuntimeFactoryLoader = ServiceLoader.load(PMMLRuntimeFactory.class);

    private SPIUtils() {
    }

    public static PMMLRuntimeFactory getPMMLRuntimeFactory(boolean refresh) {
        logger.debug("getRuntimeManager {}", (Object)refresh);
        ArrayList toReturn = new ArrayList();
        Iterator<PMMLRuntimeFactory> managers = SPIUtils.getFactories(refresh);
        managers.forEachRemaining(toReturn::add);
        return toReturn.stream().findFirst().orElse(new PMMLRuntimeFactoryImpl());
    }

    private static Iterator<PMMLRuntimeFactory> getFactories(boolean refresh) {
        if (refresh) {
            pmmlRuntimeFactoryLoader.reload();
        }
        return pmmlRuntimeFactoryLoader.iterator();
    }
}

