/*
 * Decompiled with CFR 0.152.
 */
package org.kie.test.util.filesystem;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceHelper {
    private static final Logger logger = LoggerFactory.getLogger(ResourceHelper.class);

    public static Stream<File> getResourcesByExtension(String extension) {
        return Arrays.stream(ResourceHelper.getClassPathElements()).flatMap(elem -> ResourceHelper.internalGetResources(elem, Pattern.compile(".*\\." + extension + "$")));
    }

    public static Stream<File> getResourcesFromDirectory(File directory, Pattern pattern) {
        if (directory == null || directory.listFiles() == null) {
            return Stream.empty();
        }
        return Arrays.stream(Objects.requireNonNull(directory.listFiles())).flatMap(elem -> {
            if (elem.isDirectory()) {
                return ResourceHelper.getResourcesFromDirectory(elem, pattern);
            }
            try {
                if (pattern.matcher(elem.getCanonicalPath()).matches()) {
                    return Stream.of(elem);
                }
            }
            catch (IOException e) {
                logger.error("Failed top retrieve resources from directory " + directory.getAbsolutePath() + " with pattern " + pattern.pattern(), (Throwable)e);
            }
            return Stream.empty();
        });
    }

    static String[] getClassPathElements() {
        return System.getProperty("java.class.path", ".").split(System.getProperty("path.separator"));
    }

    static Stream<File> internalGetResources(String path, Pattern pattern) {
        File file = new File(path);
        if (!file.isDirectory()) {
            return Stream.empty();
        }
        return ResourceHelper.getResourcesFromDirectory(file, pattern);
    }

    private ResourceHelper() {
    }
}

