/*
 * Decompiled with CFR 0.152.
 */
package org.kie.test.util.db.internal;

public enum DatabaseProvider {
    DB2,
    H2,
    MARIADB,
    MSSQL,
    MYSQL,
    ORACLE,
    POSTGRES,
    POSTGRES_PLUS,
    SYBASE;


    public static DatabaseProvider fromDriverClassName(String driverClassName) {
        if (driverClassName == null || driverClassName.isEmpty()) {
            throw new IllegalArgumentException("Driver class name cannot be empty.");
        }
        String sanitizedDriverClassName = driverClassName.trim().toLowerCase();
        if (sanitizedDriverClassName.startsWith("com.ibm.db2")) {
            return DB2;
        }
        if (sanitizedDriverClassName.startsWith("org.h2")) {
            return H2;
        }
        if (sanitizedDriverClassName.startsWith("com.microsoft.sqlserver")) {
            return MSSQL;
        }
        if (sanitizedDriverClassName.startsWith("org.mariadb")) {
            return MARIADB;
        }
        if (sanitizedDriverClassName.startsWith("com.mysql")) {
            return MYSQL;
        }
        if (sanitizedDriverClassName.startsWith("oracle")) {
            return ORACLE;
        }
        if (sanitizedDriverClassName.startsWith("org.postgresql")) {
            return POSTGRES;
        }
        if (sanitizedDriverClassName.startsWith("com.edb")) {
            return POSTGRES_PLUS;
        }
        if (sanitizedDriverClassName.startsWith("com.sybase")) {
            return SYBASE;
        }
        throw new IllegalArgumentException("Unsupported database provider with a driver class:" + driverClassName);
    }
}

