/*
 * Decompiled with CFR 0.152.
 */
package org.kie.test.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.junit.Assert;

public class StaticMethodTestHelper {
    private static final String jarLocRegexStr = ".*-(\\d+\\.\\d+(\\.\\d+)?)(-SNAPSHOT)?.jar";
    private static final Pattern jarLocRegex = Pattern.compile(".*-(\\d+\\.\\d+(\\.\\d+)?)(-SNAPSHOT)?.jar");

    public static boolean projectVersionIsLessThan(double version) {
        String projVersionStr = StaticMethodTestHelper.getProjectVersion();
        return StaticMethodTestHelper.isLessThanProjectVersion(projVersionStr, version);
    }

    static boolean isLessThanProjectVersion(String projVersionStr, double version) {
        int secondPoint;
        projVersionStr = projVersionStr.replace("-SNAPSHOT", "");
        int firstPoint = projVersionStr.indexOf(46);
        return Double.parseDouble(projVersionStr = projVersionStr.substring(0, secondPoint = projVersionStr.substring(++firstPoint).indexOf(46) + firstPoint)) < version;
    }

    static String getProjectVersion() {
        String projVersionStr;
        block16: {
            URL codeLocUrl = StaticMethodTestHelper.class.getProtectionDomain().getCodeSource().getLocation();
            projVersionStr = null;
            String codeLocStr = null;
            try {
                codeLocStr = codeLocUrl.toURI().toString();
                if (codeLocStr.endsWith(".jar")) {
                    Matcher jarLocMatcher = jarLocRegex.matcher(codeLocStr);
                    Assert.assertTrue((String)"Regex for code (jar) location did not match location!", (jarLocMatcher.matches() && jarLocMatcher.groupCount() >= 2 ? 1 : 0) != 0);
                    projVersionStr = jarLocMatcher.group(1);
                    break block16;
                }
                codeLocStr = codeLocStr.replace("target/classes/", "pom.xml");
                File pomFile = new File(new URI(codeLocStr));
                Assert.assertTrue((String)(codeLocStr + " does not exist!"), (boolean)pomFile.exists());
                FileReader reader = null;
                try {
                    reader = new FileReader(pomFile);
                    MavenXpp3Reader xpp3Reader = new MavenXpp3Reader();
                    Model model = xpp3Reader.read((Reader)reader);
                    projVersionStr = model.getVersion();
                    if (projVersionStr == null) {
                        projVersionStr = model.getParent().getVersion();
                    }
                    String projectName = model.getGroupId() + ":" + model.getArtifactId();
                    ((AbstractStringAssert)Assertions.assertThat((String)projVersionStr).as("Unable to resolve project version for " + projectName, new Object[0])).isNotNull();
                }
                catch (FileNotFoundException fnfe) {
                    throw new RuntimeException("Unable to open " + pomFile.getAbsolutePath(), fnfe);
                }
                catch (IOException ioe) {
                    throw new RuntimeException("Unable to read " + codeLocStr, ioe);
                }
                catch (XmlPullParserException xppe) {
                    throw new RuntimeException("Unable to parse " + codeLocStr, xppe);
                }
                finally {
                    try {
                        if (reader != null) {
                            ((Reader)reader).close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (URISyntaxException urise) {
                throw new RuntimeException("Invalid URL: " + codeLocStr, urise);
            }
        }
        return projVersionStr;
    }
}

