/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.index.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.kogito.index.cache.Cache;
import org.kie.kogito.index.cache.CacheService;
import org.kie.kogito.index.json.JsonUtils;
import org.kie.kogito.index.model.Job;
import org.kie.kogito.index.model.ProcessInstance;
import org.kie.kogito.index.model.UserTaskInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class IndexingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexingService.class);
    @Inject
    CacheService manager;

    public void indexProcessInstance(ProcessInstance pi) {
        ProcessInstance previousPI = (ProcessInstance)this.manager.getProcessInstancesCache().get((Object)pi.getId());
        if (previousPI != null) {
            List nodes = previousPI.getNodes().stream().filter(n -> !pi.getNodes().contains(n)).collect(Collectors.toList());
            pi.getNodes().addAll(nodes);
        }
        this.manager.getProcessInstancesCache().put((Object)pi.getId(), (Object)pi);
    }

    public void indexJob(Job job) {
        this.manager.getJobsCache().put((Object)job.getId(), (Object)job);
    }

    public void indexUserTaskInstance(UserTaskInstance ut) {
        this.manager.getUserTaskInstancesCache().put((Object)ut.getId(), (Object)ut);
    }

    public void indexModel(ObjectNode json) {
        String processId = json.remove("processId").asText();
        Cache cache = this.manager.getDomainModelCache(processId);
        if (cache == null) {
            LOGGER.debug("Ignoring Kogito cloud event for unknown process: {}", (Object)processId);
            return;
        }
        String processInstanceId = json.get("id").asText();
        String type = cache.getRootType();
        ObjectNode model = (ObjectNode)cache.get((Object)processInstanceId);
        ObjectNode builder = JsonUtils.getObjectMapper().createObjectNode();
        builder.put("_type", type);
        if (model == null) {
            builder.setAll(json);
        } else {
            this.copyAllEventData(json, processInstanceId, model, builder);
            ObjectNode kogito = this.indexKogitoDomain((ObjectNode)json.get("metadata"), (ObjectNode)model.get("metadata"));
            builder.set("metadata", (JsonNode)kogito);
        }
        cache.put((Object)processInstanceId, (Object)builder);
    }

    private void copyAllEventData(ObjectNode json, String processInstanceId, ObjectNode model, ObjectNode builder) {
        ArrayNode indexPIArray = (ArrayNode)json.get("metadata").get("processInstances");
        if (indexPIArray == null) {
            builder.setAll(model);
        } else {
            JsonNode id = indexPIArray.get(0).get("id");
            if (processInstanceId.equals(id.asText())) {
                builder.setAll(json);
            } else {
                builder.setAll(model);
                builder.setAll(json);
            }
        }
    }

    private ObjectNode indexKogitoDomain(ObjectNode kogitoEvent, ObjectNode kogitoCache) {
        ArrayNode indexTIArray;
        ObjectNode kogitoBuilder = JsonUtils.getObjectMapper().createObjectNode();
        kogitoBuilder.set("lastUpdate", kogitoEvent.get("lastUpdate"));
        ArrayNode indexPIArray = (ArrayNode)kogitoEvent.get("processInstances");
        if (indexPIArray != null) {
            kogitoBuilder.set("processInstances", (JsonNode)this.copyToArray((ArrayNode)kogitoCache.get("processInstances"), indexPIArray));
            kogitoBuilder.set("userTasks", kogitoCache.get("userTasks"));
        }
        if ((indexTIArray = (ArrayNode)kogitoEvent.get("userTasks")) != null) {
            kogitoBuilder.set("userTasks", (JsonNode)this.copyToArray((ArrayNode)kogitoCache.get("userTasks"), indexTIArray));
            kogitoBuilder.set("processInstances", kogitoCache.get("processInstances"));
        }
        return kogitoBuilder;
    }

    private ArrayNode copyToArray(ArrayNode arrayCache, ArrayNode arrayEvent) {
        if (arrayCache == null) {
            return JsonUtils.getObjectMapper().createArrayNode().add(arrayEvent.get(0));
        }
        String indexId = arrayEvent.get(0).get("id").asText();
        for (int i = 0; i < arrayCache.size(); ++i) {
            if (!indexId.equals(arrayCache.get(i).get("id").asText())) continue;
            arrayCache.set(i, arrayEvent.get(0));
            return arrayCache;
        }
        arrayCache.add(arrayEvent.get(0));
        return arrayCache;
    }
}

