/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.feel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jbpm.bpmn2.feel.FeelCompilationException;
import org.jbpm.bpmn2.feel.FeelErrorEvaluatorListener;
import org.jbpm.bpmn2.feel.FeelReturnValueEvaluator;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.core.validation.ProcessValidationError;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.ruleflow.core.validation.RuleFlowProcessValidator;
import org.jbpm.workflow.core.Constraint;
import org.jbpm.workflow.core.node.Split;
import org.kie.api.definition.process.Node;
import org.kie.dmn.api.feel.runtime.events.FEELEventListener;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.lang.CompilerContext;
import org.kie.dmn.feel.parser.feel11.profiles.KieExtendedFEELProfile;

public class FeelProcessValidator
extends RuleFlowProcessValidator {
    private static FeelProcessValidator INSTANCE;

    private FeelProcessValidator() {
    }

    public static FeelProcessValidator getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FeelProcessValidator();
        }
        return INSTANCE;
    }

    protected void validateNodes(Node[] nodes, List<ProcessValidationError> errors, RuleFlowProcess process) {
        super.validateNodes(nodes, errors, process);
        Arrays.stream(nodes).filter(n -> n instanceof Split).forEach(node -> {
            Split split = (Split)node;
            if (split.getType() == 2 || split.getType() == 3) {
                for (Map.Entry entry : split.getConstraints().entrySet()) {
                    if (entry.getValue() == null || !"FEEL".equals(((Constraint)entry.getValue()).getDialect())) continue;
                    try {
                        this.verifyFEELbyCompilingExpression(process.getVariableScope(), ((Constraint)entry.getValue()).getConstraint());
                    }
                    catch (FeelCompilationException ex) {
                        this.addErrorMessage(process, (Node)node, errors, String.format("Invalid FEEL expression: '%s'.", ((Constraint)entry.getValue()).getConstraint()));
                    }
                }
            }
        });
    }

    private void verifyFEELbyCompilingExpression(VariableScope variableScope, String feelExpression) {
        FEEL feel = FEEL.newInstance(Collections.singletonList(new KieExtendedFEELProfile()));
        FeelErrorEvaluatorListener feelErrorListener = new FeelErrorEvaluatorListener();
        feel.addListener((FEELEventListener)feelErrorListener);
        CompilerContext cc = feel.newCompilerContext();
        for (Variable v : variableScope.getVariables()) {
            cc.addInputVariable(v.getName(), null);
        }
        feel.compile(feelExpression, cc);
        if (!feelErrorListener.getErrorEvents().isEmpty()) {
            String exceptionMessage = feelErrorListener.getErrorEvents().stream().map(FeelReturnValueEvaluator::eventToMessage).collect(Collectors.joining(", "));
            throw new FeelCompilationException(exceptionMessage);
        }
    }
}

