/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.core.correlation;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jbpm.process.core.correlation.Correlation;
import org.jbpm.process.core.correlation.CorrelationExpressionEvaluator;
import org.jbpm.process.core.correlation.CorrelationInstance;
import org.jbpm.process.core.correlation.CorrelationProperties;
import org.jbpm.process.core.correlation.Message;

public class CorrelationManager
implements Serializable {
    private static final long serialVersionUID = -1557112455565607001L;
    private Map<String, Correlation> correlations = new HashMap<String, Correlation>();
    private Map<String, Message> messages = new HashMap<String, Message>();
    private transient ClassLoader classLoader;

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void newCorrelation(String correlationRef, String correlationName) {
        if (this.correlations.containsKey(correlationRef)) {
            throw new IllegalStateException("Correlation " + correlationRef + "(" + correlationName + ") already exists");
        }
        Correlation correlation = new Correlation(correlationRef, correlationName);
        this.correlations.put(correlationRef, correlation);
    }

    public void newMessage(String id, String name, String type) {
        if (this.messages.containsKey(id)) {
            throw new IllegalStateException("Correlated messages " + id + " (" + name + ") already exists");
        }
        Message correlatedMessage = new Message(id, name, type);
        this.messages.put(id, correlatedMessage);
    }

    public boolean isSubscribe(String messageRef) {
        return this.correlations.values().stream().anyMatch(correlation -> correlation.hasCorrelationFor(messageRef));
    }

    public void subscribeTo(String correlationRef) {
        if (!this.correlations.containsKey(correlationRef)) {
            throw new IllegalStateException("Correlation " + correlationRef + " does not exist");
        }
        this.correlations.get(correlationRef).subscribe();
    }

    public CorrelationInstance computeCorrelationInstance(String messageRef, Object event) {
        if (event == null) {
            throw new IllegalArgumentException("cannot compute a correlation from a null object");
        }
        if (!this.messages.containsKey(messageRef)) {
            throw new IllegalArgumentException("Message ref " + messageRef + " is not a correlated message");
        }
        Message message = this.messages.get(messageRef);
        try {
            if (!this.classLoader.loadClass(message.getMessageType()).isInstance(event)) {
                throw new IllegalArgumentException("Object event type is not appropiate for this correlation. The message type was " + event.getClass().getCanonicalName() + " and was expecting " + message.getMessageType() + " in message " + message.getMessageName() + "(" + message.getMessageName() + ")");
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Object event type is not found", e);
        }
        Correlation correlation = this.findCorrelationByMessageRef(messageRef);
        CorrelationInstance correlationInstance = new CorrelationInstance(correlation.getId(), correlation.getName());
        CorrelationProperties properties = correlation.getMessageCorrelationFor(messageRef);
        for (String name : properties.names()) {
            CorrelationExpressionEvaluator evaluator = properties.getExpressionFor(name);
            Object val = evaluator.eval(event);
            if (val == null) {
                throw new IllegalArgumentException("Message property evaluated to null is not possible: " + messageRef + " property " + name);
            }
            correlationInstance.setProperty(name, val);
        }
        return correlationInstance;
    }

    public CorrelationInstance computeSubscription(String messageRef, Function<String, Object> resolver) {
        Correlation correlation = this.findCorrelationByMessageRef(messageRef);
        if (!correlation.isSubscribed()) {
            throw new IllegalArgumentException("There is no subscription for correlation by message ref " + messageRef + " is not subscribed");
        }
        CorrelationInstance correlationInstance = new CorrelationInstance(correlation.getId(), correlation.getName());
        CorrelationProperties properties = correlation.getProcessSubscription();
        for (String name : properties.names()) {
            CorrelationExpressionEvaluator evaluator = properties.getExpressionFor(name);
            Object val = evaluator.eval(resolver);
            if (val == null) {
                throw new IllegalArgumentException("Process Subscription property evaluated to null is not possible: " + messageRef + " property " + name);
            }
            correlationInstance.setProperty(name, val);
        }
        return correlationInstance;
    }

    private Correlation findCorrelationByMessageRef(String messageRef) {
        for (Correlation correlation : this.correlations.values()) {
            if (!correlation.hasCorrelationFor(messageRef)) continue;
            return correlation;
        }
        throw new IllegalArgumentException("Correlation for message ref " + messageRef + " does not exist");
    }

    public void addMessagePropertyExpression(String correlationRef, String messageRef, String propertyName, CorrelationExpressionEvaluator expression) {
        this.correlations.get(correlationRef).getMessageCorrelationFor(messageRef).addProperty(propertyName, expression);
    }

    public void addProcessSubscriptionPropertyExpression(String correlationRef, String propertyName, CorrelationExpressionEvaluator expression) {
        if (!this.correlations.containsKey(correlationRef)) {
            return;
        }
        this.correlations.get(correlationRef).getProcessSubscription().addProperty(propertyName, expression);
    }
}

