/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.event.ProcessEventSupport;
import org.drools.core.phreak.PropagationEntry;
import org.drools.core.time.TimeUtils;
import org.jbpm.process.core.event.EventFilter;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.process.core.timer.BusinessCalendar;
import org.jbpm.process.core.timer.DateTimeUtils;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.process.instance.AbstractProcessRuntime;
import org.jbpm.process.instance.DummyKnowledgeRuntime;
import org.jbpm.process.instance.LightProcessRuntimeContext;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.ProcessInstanceManager;
import org.jbpm.process.instance.ProcessRuntimeContext;
import org.jbpm.process.instance.ProcessRuntimeServiceProvider;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.impl.DataAssociation;
import org.jbpm.workflow.core.impl.NodeIoHelper;
import org.jbpm.workflow.core.node.EventTrigger;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.Trigger;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.kie.api.event.rule.DefaultAgendaEventListener;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.event.rule.RuleFlowGroupDeactivatedEvent;
import org.kie.api.runtime.process.EventListener;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.kogito.Application;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemManager;
import org.kie.kogito.jobs.DurationExpirationTime;
import org.kie.kogito.jobs.ExactExpirationTime;
import org.kie.kogito.jobs.ExpirationTime;
import org.kie.kogito.jobs.JobsService;
import org.kie.kogito.jobs.ProcessJobDescription;
import org.kie.kogito.process.Processes;
import org.kie.kogito.signal.SignalManager;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.kie.services.jobs.impl.InMemoryJobService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightProcessRuntime
extends AbstractProcessRuntime {
    private static final Logger LOGGER = LoggerFactory.getLogger(LightProcessRuntime.class);
    private ProcessRuntimeContext runtimeContext;
    private final InternalKnowledgeRuntime knowledgeRuntime;
    private ProcessInstanceManager processInstanceManager;
    private SignalManager signalManager;
    private JobsService jobService;
    private final KogitoWorkItemManager workItemManager;
    private UnitOfWorkManager unitOfWorkManager;

    public static LightProcessRuntime of(Application app, Collection<Process> process, ProcessRuntimeServiceProvider services) {
        return new LightProcessRuntime(new LightProcessRuntimeContext(process), services, app);
    }

    protected LightProcessRuntime(ProcessRuntimeContext runtimeContext, ProcessRuntimeServiceProvider services) {
        this(runtimeContext, services, null);
    }

    protected LightProcessRuntime(ProcessRuntimeContext runtimeContext, ProcessRuntimeServiceProvider services, Application application) {
        super(application);
        this.unitOfWorkManager = services.getUnitOfWorkManager();
        this.knowledgeRuntime = new DummyKnowledgeRuntime(this);
        this.runtimeContext = runtimeContext;
        this.processInstanceManager = services.getProcessInstanceManager();
        this.signalManager = services.getSignalManager();
        this.jobService = services.getJobsService() == null ? InMemoryJobService.get((Processes)((Processes)application.get(Processes.class)), (UnitOfWorkManager)this.unitOfWorkManager) : services.getJobsService();
        this.processEventSupport = services.getEventSupport();
        this.workItemManager = services.getKogitoWorkItemManager();
        if (this.isActive()) {
            this.initProcessEventListeners();
            this.initStartTimers();
        }
        this.initProcessActivationListener();
    }

    public void initStartTimers() {
        Collection<Process> processes = this.runtimeContext.getProcesses();
        for (Process process : processes) {
            RuleFlowProcess p = (RuleFlowProcess)process;
            List<StartNode> startNodes = p.getTimerStart();
            if (startNodes == null || startNodes.isEmpty()) continue;
            for (StartNode startNode : startNodes) {
                if (startNode == null || startNode.getTimer() == null) continue;
                this.jobService.scheduleProcessJob(ProcessJobDescription.of((ExpirationTime)this.createTimerInstance(startNode.getTimer(), this.knowledgeRuntime), (String)p.getId()));
            }
        }
    }

    public org.kie.api.runtime.process.ProcessInstance startProcess(String processId) {
        return this.startProcess(processId, null, null, null);
    }

    public org.kie.api.runtime.process.ProcessInstance startProcess(String processId, Map<String, Object> parameters) {
        return this.startProcess(processId, parameters, null, null);
    }

    public org.kie.api.runtime.process.ProcessInstance startProcess(String processId, Map<String, Object> parameters, String trigger) {
        return this.startProcess(processId, parameters, trigger, null);
    }

    public org.kie.api.runtime.process.ProcessInstance startProcess(String processId, AgendaFilter agendaFilter) {
        return this.startProcess(processId, null, null, agendaFilter);
    }

    public org.kie.api.runtime.process.ProcessInstance startProcess(String processId, Map<String, Object> parameters, AgendaFilter agendaFilter) {
        return this.startProcess(processId, parameters, null, agendaFilter);
    }

    private org.kie.api.runtime.process.ProcessInstance startProcess(String processId, Map<String, Object> parameters, String trigger, AgendaFilter agendaFilter) {
        KogitoProcessInstance processInstance = this.createProcessInstance(processId, parameters);
        if (processInstance != null) {
            return this.kogitoProcessRuntime.startProcessInstance(processInstance.getStringId(), trigger, agendaFilter);
        }
        return null;
    }

    public KogitoProcessInstance createProcessInstance(String processId, Map<String, Object> parameters) {
        return this.createProcessInstance(processId, null, parameters);
    }

    public KogitoProcessInstance startProcess(String processId, CorrelationKey correlationKey, Map<String, Object> parameters) {
        KogitoProcessInstance processInstance = this.createProcessInstance(processId, correlationKey, parameters);
        if (processInstance != null) {
            return this.kogitoProcessRuntime.startProcessInstance(processInstance.getStringId());
        }
        return null;
    }

    public KogitoProcessInstance createProcessInstance(String processId, CorrelationKey correlationKey, Map<String, Object> parameters) {
        return this.createProcessInstance(this.runtimeContext.findProcess(processId).orElseThrow(() -> new IllegalArgumentException("Unknown process ID: " + processId)), correlationKey, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KogitoProcessInstance createProcessInstance(Process process, CorrelationKey correlationKey, Map<String, Object> parameters) {
        try {
            this.runtimeContext.startOperation();
            ProcessInstance pi = this.runtimeContext.createProcessInstance(process, correlationKey);
            pi.setKnowledgeRuntime(this.knowledgeRuntime);
            this.runtimeContext.setupParameters(pi, parameters);
            this.processInstanceManager.addProcessInstance(pi);
            ProcessInstance processInstance = pi;
            return processInstance;
        }
        finally {
            this.runtimeContext.endOperation();
        }
    }

    @Override
    public ProcessInstanceManager getProcessInstanceManager() {
        return this.processInstanceManager;
    }

    @Override
    public JobsService getJobsService() {
        return this.jobService;
    }

    @Override
    public SignalManager getSignalManager() {
        return this.signalManager;
    }

    public Collection<org.kie.api.runtime.process.ProcessInstance> getProcessInstances() {
        return this.processInstanceManager.getProcessInstances();
    }

    public KogitoProcessInstance getProcessInstance(String id) {
        return this.getProcessInstance(id, false);
    }

    public KogitoProcessInstance getProcessInstance(String id, boolean readOnly) {
        return this.processInstanceManager.getProcessInstance(id, readOnly);
    }

    public void removeProcessInstance(KogitoProcessInstance processInstance) {
        this.processInstanceManager.removeProcessInstance(processInstance);
    }

    public void initProcessEventListeners() {
        for (Process process : this.runtimeContext.getProcesses()) {
            this.initProcessEventListener(process);
        }
    }

    public void removeProcessEventListeners() {
        for (Process process : this.runtimeContext.getProcesses()) {
            this.removeProcessEventListener(process);
        }
    }

    private void removeProcessEventListener(Process process) {
        if (process instanceof RuleFlowProcess) {
            String type = (String)((RuleFlowProcess)process).getRuntimeMetaData().get("StartProcessEventType");
            StartProcessEventListener listener = (StartProcessEventListener)((RuleFlowProcess)process).getRuntimeMetaData().get("StartProcessEventListener");
            if (type != null && listener != null) {
                this.signalManager.removeEventListener(type, (EventListener)listener);
            }
        }
    }

    private void initProcessEventListener(Process process) {
        if (process instanceof RuleFlowProcess) {
            for (Node node : ((RuleFlowProcess)process).getNodes()) {
                List<Trigger> triggers;
                StartNode startNode;
                if (!(node instanceof StartNode) || (startNode = (StartNode)node) == null || (triggers = startNode.getTriggers()) == null) continue;
                for (Trigger trigger : triggers) {
                    if (!(trigger instanceof EventTrigger)) continue;
                    List<EventFilter> filters = ((EventTrigger)trigger).getEventFilters();
                    String type = null;
                    for (EventFilter filter : filters) {
                        if (!(filter instanceof EventTypeFilter)) continue;
                        type = ((EventTypeFilter)filter).getType();
                    }
                    StartProcessEventListener listener = new StartProcessEventListener(startNode, trigger, process.getId(), filters);
                    this.signalManager.addEventListener(type, (EventListener)listener);
                    ((RuleFlowProcess)process).getRuntimeMetaData().put("StartProcessEventType", type);
                    ((RuleFlowProcess)process).getRuntimeMetaData().put("StartProcessEventListener", listener);
                }
            }
        }
    }

    private void initProcessActivationListener() {
        this.runtimeContext.addEventListener(new DefaultAgendaEventListener(){

            public void matchCreated(MatchCreatedEvent event) {
                String ruleFlowGroup = ((RuleImpl)event.getMatch().getRule()).getRuleFlowGroup();
                if ("DROOLS_SYSTEM".equals(ruleFlowGroup)) {
                    String ruleName = event.getMatch().getRule().getName();
                    if (ruleName.startsWith("RuleFlowStateNode-")) {
                        int index = ruleName.indexOf(45, 18);
                        index = ruleName.indexOf(45, index + 1);
                        String eventType = ruleName.substring(0, index);
                        LightProcessRuntime.this.runtimeContext.queueWorkingMemoryAction(new SignalManagerSignalAction(eventType, event));
                    } else if (ruleName.startsWith("RuleFlowStateEventSubProcess-") || ruleName.startsWith("RuleFlowStateEvent-") || ruleName.startsWith("RuleFlow-Milestone-") || ruleName.startsWith("RuleFlow-AdHocComplete-") || ruleName.startsWith("RuleFlow-AdHocActivate-")) {
                        LightProcessRuntime.this.runtimeContext.queueWorkingMemoryAction(new SignalManagerSignalAction(ruleName, event));
                    }
                } else {
                    String ruleName = event.getMatch().getRule().getName();
                    if (ruleName.startsWith("RuleFlow-Start-")) {
                        String processId = ruleName.replace("RuleFlow-Start-", "");
                        LightProcessRuntime.this.startProcessWithParamsAndTrigger(processId, null, "conditional", true);
                    }
                }
            }
        });
        this.runtimeContext.addEventListener(new DefaultAgendaEventListener(){

            public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
                if (LightProcessRuntime.this.runtimeContext instanceof StatefulKnowledgeSession) {
                    LightProcessRuntime.this.signalManager.signalEvent("RuleFlowGroup_" + event.getRuleFlowGroup().getName() + "_" + ((StatefulKnowledgeSession)LightProcessRuntime.this.runtimeContext).getIdentifier(), null);
                } else {
                    LightProcessRuntime.this.signalManager.signalEvent("RuleFlowGroup_" + event.getRuleFlowGroup().getName(), null);
                }
            }
        });
    }

    private void startProcessWithParamsAndTrigger(String processId, Map<String, Object> params, String type, boolean dispose) {
        this.startProcess(processId, params, type);
    }

    public void abortProcessInstance(String processInstanceId) {
        KogitoProcessInstance processInstance = this.getProcessInstance(processInstanceId);
        if (processInstance == null) {
            throw new IllegalArgumentException("Could not find process instance for id " + processInstanceId);
        }
        ((ProcessInstance)processInstance).setState(3);
    }

    public WorkItemManager getWorkItemManager() {
        return (WorkItemManager)this.getKogitoWorkItemManager();
    }

    public KogitoWorkItemManager getKogitoWorkItemManager() {
        return this.workItemManager;
    }

    @Override
    public UnitOfWorkManager getUnitOfWorkManager() {
        return this.unitOfWorkManager;
    }

    public void signalEvent(String type, Object event) {
        this.signalManager.signalEvent(type, event);
    }

    public void signalEvent(String type, Object event, String processInstanceId) {
        this.signalManager.signalEvent(processInstanceId, type, event);
    }

    @Override
    public void setProcessEventSupport(ProcessEventSupport processEventSupport) {
        throw new UnsupportedOperationException();
    }

    public void dispose() {
        this.processEventSupport.reset();
        this.runtimeContext = null;
    }

    public void clearProcessInstances() {
        this.processInstanceManager.clearProcessInstances();
    }

    public void clearProcessInstancesState() {
        this.processInstanceManager.clearProcessInstancesState();
    }

    public boolean isActive() {
        return this.runtimeContext.isActive();
    }

    protected ExpirationTime createTimerInstance(Timer timer, InternalKnowledgeRuntime kruntime) {
        if (kruntime != null && kruntime.getEnvironment().get("jbpm.business.calendar") != null) {
            BusinessCalendar businessCalendar = (BusinessCalendar)kruntime.getEnvironment().get("jbpm.business.calendar");
            long delay = businessCalendar.calculateBusinessTimeAsDuration(timer.getDelay());
            if (timer.getPeriod() == null) {
                return DurationExpirationTime.repeat((long)delay);
            }
            long period = businessCalendar.calculateBusinessTimeAsDuration(timer.getPeriod());
            return DurationExpirationTime.repeat((long)delay, (Long)period);
        }
        return this.configureTimerInstance(timer);
    }

    private ExpirationTime configureTimerInstance(Timer timer) {
        long duration = -1L;
        switch (timer.getTimeType()) {
            case 2: {
                long[] repeatValues = DateTimeUtils.parseRepeatableDateTime(timer.getDelay());
                if (repeatValues.length == 3) {
                    int parsedReapedCount = (int)repeatValues[0];
                    if (parsedReapedCount > -1) {
                        parsedReapedCount = Integer.MAX_VALUE;
                    }
                    return DurationExpirationTime.repeat((long)repeatValues[1], (Long)repeatValues[2]);
                }
                long delay = repeatValues[0];
                long period = -1L;
                try {
                    period = TimeUtils.parseTimeString((String)timer.getPeriod());
                }
                catch (RuntimeException e) {
                    period = repeatValues[0];
                }
                return DurationExpirationTime.repeat((long)delay, (Long)period);
            }
            case 1: {
                duration = DateTimeUtils.parseDuration(timer.getDelay());
                return DurationExpirationTime.repeat((long)duration);
            }
            case 3: {
                return ExactExpirationTime.of((String)timer.getDate());
            }
        }
        throw new UnsupportedOperationException("Not supported timer definition");
    }

    @Override
    public InternalKnowledgeRuntime getInternalKieRuntime() {
        return this.knowledgeRuntime;
    }

    public org.kie.api.runtime.process.ProcessInstance startProcessFromNodeIds(String s, Map<String, Object> map, String ... strings) {
        throw new UnsupportedOperationException();
    }

    public org.kie.api.runtime.process.ProcessInstance startProcessInstance(String l) {
        throw new UnsupportedOperationException();
    }

    public org.kie.api.runtime.process.ProcessInstance startProcessFromNodeIds(String s, CorrelationKey correlationKey, Map<String, Object> map, String ... strings) {
        throw new UnsupportedOperationException();
    }

    public org.kie.api.runtime.process.ProcessInstance getProcessInstance(CorrelationKey correlationKey) {
        throw new UnsupportedOperationException();
    }

    public class SignalManagerSignalAction
    extends PropagationEntry.AbstractPropagationEntry
    implements WorkingMemoryAction {
        private String type;
        private Object event;

        public SignalManagerSignalAction(String type, Object event) {
            this.type = type;
            this.event = event;
        }

        public void execute(ReteEvaluator reteEvaluator) {
            LightProcessRuntime.this.signalEvent(this.type, this.event);
        }
    }

    private class StartProcessEventListener
    implements EventListener {
        private String processId;
        private List<EventFilter> eventFilters;
        private Trigger trigger;
        private StartNode startNode;

        public StartProcessEventListener(StartNode startNode, Trigger trigger, String processId, List<EventFilter> eventFilters) {
            this.startNode = startNode;
            this.trigger = trigger;
            this.processId = processId;
            this.eventFilters = eventFilters;
        }

        public String[] getEventTypes() {
            return null;
        }

        public void signalEvent(String type, Object event) {
            boolean bl;
            for (EventFilter eventFilter : this.eventFilters) {
                if (eventFilter.acceptsEvent(type, event, varName -> null)) continue;
                return;
            }
            HashMap<String, Object> outputSet = new HashMap<String, Object>();
            for (Map.Entry<String, String> entry : this.trigger.getInMappings().entrySet()) {
                outputSet.put(entry.getKey(), entry.getKey());
            }
            boolean bl2 = false;
            for (DataAssociation dataAssociation : this.trigger.getInAssociations()) {
                if (!"event".equals(dataAssociation.getSources().get(0).getLabel())) continue;
                bl = true;
            }
            if (!bl && !this.trigger.getInAssociations().isEmpty()) {
                String string = (String)this.startNode.getMetaData("TriggerMappingInput");
                outputSet.put(string, event);
            } else {
                outputSet.put("event", event);
            }
            Map<String, Object> map = NodeIoHelper.processOutputs(this.trigger.getInAssociations(), key -> outputSet.get(key));
            LightProcessRuntime.this.startProcessWithParamsAndTrigger(this.processId, map, type, false);
        }
    }
}

