/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.impl;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.api.definition.process.Node;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessRuntime;
import org.kie.internal.process.CorrelationAwareProcessRuntime;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationProperty;
import org.kie.kogito.Model;
import org.kie.kogito.internal.process.event.KogitoEventListener;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.process.runtime.WorkItemNotFoundException;
import org.kie.kogito.process.EventDescription;
import org.kie.kogito.process.MutableProcessInstances;
import org.kie.kogito.process.NodeInstanceNotFoundException;
import org.kie.kogito.process.NodeNotFoundException;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessError;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceNotFoundException;
import org.kie.kogito.process.Signal;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.flexible.AdHocFragment;
import org.kie.kogito.process.flexible.Milestone;
import org.kie.kogito.process.impl.AbstractProcess;
import org.kie.kogito.process.impl.BaseWorkItem;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.workitem.Transition;
import org.kie.kogito.services.uow.ProcessInstanceWorkUnit;
import org.kie.kogito.uow.WorkUnit;

public abstract class AbstractProcessInstance<T extends Model>
implements ProcessInstance<T> {
    private static final String KOGITO_PROCESS_INSTANCE = "KogitoProcessInstance";
    protected final T variables;
    protected final AbstractProcess<T> process;
    protected InternalProcessRuntime rt;
    protected WorkflowProcessInstance processInstance;
    protected Integer status;
    protected String id;
    protected CorrelationKey correlationKey;
    protected String description;
    protected ProcessError processError;
    protected Consumer<AbstractProcessInstance<?>> reloadSupplier;
    protected CompletionEventListener completionEventListener;
    protected long version;

    public AbstractProcessInstance(AbstractProcess<T> process, T variables, ProcessRuntime rt) {
        this(process, variables, null, rt);
    }

    public AbstractProcessInstance(AbstractProcess<T> process, T variables, String businessKey, ProcessRuntime rt) {
        this.process = process;
        this.rt = (InternalProcessRuntime)rt;
        this.variables = variables;
        this.setCorrelationKey(businessKey);
        Map<String, Object> map = this.bind(variables);
        String processId = process.process().getId();
        this.syncProcessInstance((WorkflowProcessInstance)((CorrelationAwareProcessRuntime)rt).createProcessInstance(processId, this.correlationKey, map));
        this.processInstance.setMetaData(KOGITO_PROCESS_INSTANCE, this);
    }

    public AbstractProcessInstance(AbstractProcess<T> process, T variables, org.kie.api.runtime.process.WorkflowProcessInstance wpi) {
        this.process = process;
        this.variables = variables;
        this.syncProcessInstance((WorkflowProcessInstance)wpi);
        this.unbind(variables, this.processInstance.getVariables());
    }

    public AbstractProcessInstance(AbstractProcess<T> process, T variables, ProcessRuntime rt, org.kie.api.runtime.process.WorkflowProcessInstance wpi) {
        this.process = process;
        this.rt = (InternalProcessRuntime)rt;
        this.variables = variables;
        this.syncProcessInstance((WorkflowProcessInstance)wpi);
        this.reconnect();
    }

    protected void reconnect() {
        if (this.processInstance.getKnowledgeRuntime() == null) {
            this.processInstance.setKnowledgeRuntime(this.getProcessRuntime().getInternalKieRuntime());
        }
        this.getProcessRuntime().getProcessInstanceManager().setLock(((MutableProcessInstances)this.process.instances()).lock());
        this.processInstance.reconnect();
        this.processInstance.setMetaData(KOGITO_PROCESS_INSTANCE, this);
        this.addCompletionEventListener();
        for (NodeInstance nodeInstance : this.processInstance.getNodeInstances()) {
            if (!(nodeInstance instanceof WorkItemNodeInstance)) continue;
            ((WorkItemNodeInstance)nodeInstance).internalRegisterWorkItem();
        }
        this.unbind(this.variables, this.processInstance.getVariables());
    }

    private void addCompletionEventListener() {
        if (this.completionEventListener == null) {
            this.completionEventListener = new CompletionEventListener();
            this.processInstance.addEventListener("processInstanceCompleted:" + this.id, this.completionEventListener, false);
        }
    }

    private void removeCompletionListener() {
        if (this.completionEventListener != null) {
            this.processInstance.removeEventListener("processInstanceCompleted:" + this.id, this.completionEventListener, false);
            this.completionEventListener = null;
        }
    }

    protected void disconnect() {
        if (this.processInstance == null) {
            return;
        }
        for (NodeInstance nodeInstance : this.processInstance.getNodeInstances()) {
            if (!(nodeInstance instanceof WorkItemNodeInstance)) continue;
            ((WorkItemNodeInstance)nodeInstance).internalRemoveWorkItem();
        }
        this.processInstance.disconnect();
        this.processInstance.setMetaData(KOGITO_PROCESS_INSTANCE, null);
    }

    private void syncProcessInstance(WorkflowProcessInstance wpi) {
        this.processInstance = wpi;
        this.status = wpi.getState();
        this.id = wpi.getStringId();
        this.description = wpi.getDescription();
        this.setCorrelationKey(wpi.getCorrelationKey());
    }

    private void setCorrelationKey(String businessKey) {
        if (businessKey != null && !businessKey.trim().isEmpty()) {
            this.correlationKey = new StringCorrelationKey(businessKey);
        }
    }

    public WorkflowProcessInstance internalGetProcessInstance() {
        return this.processInstance;
    }

    public void internalSetProcessInstance(WorkflowProcessInstance processInstance) {
        this.processInstance = processInstance;
    }

    public void internalRemoveProcessInstance(Consumer<AbstractProcessInstance<?>> reloadSupplier) {
        this.reloadSupplier = reloadSupplier;
        this.status = this.processInstance.getState();
        if (this.status == 5) {
            this.processError = this.buildProcessError();
        }
        this.removeCompletionListener();
        if (this.processInstance.getKnowledgeRuntime() != null) {
            this.disconnect();
        }
        this.processInstance = null;
    }

    public void start() {
        this.start(null, null);
    }

    public void start(String trigger, String referenceId) {
        if (this.status != 0) {
            throw new IllegalStateException("Impossible to start process instance that already was started");
        }
        this.status = 1;
        if (referenceId != null) {
            this.processInstance.setReferenceId(referenceId);
        }
        this.getProcessRuntime().getProcessInstanceManager().setLock(((MutableProcessInstances)this.process.instances()).lock());
        this.getProcessRuntime().getProcessInstanceManager().addProcessInstance(this.processInstance);
        this.id = this.processInstance.getStringId();
        this.addCompletionEventListener();
        ((MutableProcessInstances)this.process.instances()).create(this.id, (ProcessInstance)this);
        KogitoProcessInstance kogitoProcessInstance = this.getProcessRuntime().getKogitoProcessRuntime().startProcessInstance(this.id, trigger);
        if (kogitoProcessInstance.getState() != 3 && kogitoProcessInstance.getState() != 2) {
            this.addToUnitOfWork(pi -> ((MutableProcessInstances)this.process.instances()).update(pi.id(), pi));
        }
        this.unbind(this.variables, kogitoProcessInstance.getVariables());
        if (this.processInstance != null) {
            this.status = this.processInstance.getState();
        }
    }

    protected void addToUnitOfWork(Consumer<ProcessInstance<T>> action) {
        this.getProcessRuntime().getUnitOfWorkManager().currentUnitOfWork().intercept((WorkUnit)new ProcessInstanceWorkUnit((ProcessInstance)this, action));
    }

    public void abort() {
        String pid = this.processInstance().getStringId();
        this.unbind(this.variables, this.processInstance().getVariables());
        this.getProcessRuntime().getKogitoProcessRuntime().abortProcessInstance(pid);
        this.status = this.processInstance.getState();
        this.addToUnitOfWork(pi -> ((MutableProcessInstances)this.process.instances()).remove(pi.id()));
    }

    private InternalProcessRuntime getProcessRuntime() {
        if (this.rt == null) {
            throw new UnsupportedOperationException("Process instance is not connected to a Process Runtime");
        }
        return this.rt;
    }

    public <S> void send(Signal<S> signal) {
        if (signal.referenceId() != null) {
            this.processInstance().setReferenceId(signal.referenceId());
        }
        this.processInstance().signalEvent(signal.channel(), signal.payload());
        this.removeOnFinish();
    }

    public Process<T> process() {
        return this.process;
    }

    public T variables() {
        return this.variables;
    }

    public int status() {
        return this.status;
    }

    public String id() {
        return this.id;
    }

    public String businessKey() {
        return this.correlationKey == null ? null : this.correlationKey.getName();
    }

    public String description() {
        return this.description;
    }

    public Date startDate() {
        return this.processInstance != null ? this.processInstance.getStartDate() : null;
    }

    public long version() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public T updateVariables(T updates) {
        Map<String, Object> map = this.bind(updates);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.processInstance().setVariable(entry.getKey(), entry.getValue());
        }
        this.variables.update(map);
        this.addToUnitOfWork(pi -> ((MutableProcessInstances)this.process.instances()).update(pi.id(), pi));
        return this.variables;
    }

    public Optional<ProcessError> error() {
        if (this.status == 5) {
            return Optional.of(this.processError != null ? this.processError : this.buildProcessError());
        }
        return Optional.empty();
    }

    public void startFrom(String nodeId) {
        this.startFrom(nodeId, null);
    }

    public void startFrom(String nodeId, String referenceId) {
        this.processInstance.setStartDate(new Date());
        this.processInstance.setState(1);
        this.getProcessRuntime().getProcessInstanceManager().addProcessInstance(this.processInstance);
        this.id = this.processInstance.getStringId();
        this.addCompletionEventListener();
        if (referenceId != null) {
            this.processInstance.setReferenceId(referenceId);
        }
        this.triggerNode(nodeId);
        this.unbind(this.variables, this.processInstance.getVariables());
        if (this.processInstance != null) {
            this.status = this.processInstance.getState();
        }
    }

    public void triggerNode(String nodeId) {
        Node node;
        WorkflowProcessInstance wfpi = this.processInstance();
        RuleFlowProcess rfp = (RuleFlowProcess)wfpi.getProcess();
        Node parentNode = rfp.getParentNode((node = rfp.getNodesRecursively().stream().filter(ni -> nodeId.equals(ni.getMetaData().get("UniqueId"))).findFirst().orElseThrow(() -> new NodeNotFoundException(this.id, nodeId))).getId());
        WorkflowProcessInstance nodeInstanceContainerNode = parentNode == null ? wfpi : (NodeInstanceContainer)((Object)wfpi.getNodeInstance(parentNode));
        nodeInstanceContainerNode.getNodeInstance(node).trigger(null, "DROOLS_DEFAULT");
        this.addToUnitOfWork(pi -> ((MutableProcessInstances)this.process.instances()).update(pi.id(), pi));
    }

    public void cancelNodeInstance(String nodeInstanceId) {
        org.jbpm.workflow.instance.NodeInstance nodeInstance = this.processInstance().getNodeInstances(true).stream().filter(ni -> ni.getStringId().equals(nodeInstanceId)).findFirst().orElseThrow(() -> new NodeInstanceNotFoundException(this.id, nodeInstanceId));
        nodeInstance.cancel();
        this.removeOnFinish();
    }

    public void retriggerNodeInstance(String nodeInstanceId) {
        org.jbpm.workflow.instance.NodeInstance nodeInstance = this.processInstance().getNodeInstances(true).stream().filter(ni -> ni.getStringId().equals(nodeInstanceId)).findFirst().orElseThrow(() -> new NodeInstanceNotFoundException(this.id, nodeInstanceId));
        ((NodeInstanceImpl)nodeInstance).retrigger(true);
        this.removeOnFinish();
    }

    protected WorkflowProcessInstance processInstance() {
        if (this.processInstance == null) {
            this.reloadSupplier.accept(this);
            if (this.processInstance == null) {
                throw new ProcessInstanceNotFoundException(this.id);
            }
            if (this.getProcessRuntime() != null) {
                this.reconnect();
            }
        }
        return this.processInstance;
    }

    public Collection<KogitoNodeInstance> findNodes(Predicate<KogitoNodeInstance> predicate) {
        return this.processInstance().getKogitoNodeInstances(predicate, true);
    }

    public WorkItem workItem(String workItemId, Policy<?> ... policies) {
        WorkItemNodeInstance workItemInstance = (WorkItemNodeInstance)this.processInstance().getNodeInstances(true).stream().filter(ni -> ni instanceof WorkItemNodeInstance && ((WorkItemNodeInstance)ni).getWorkItemId().equals(workItemId) && ((WorkItemNodeInstance)ni).getWorkItem().enforce(policies)).findFirst().orElseThrow(() -> new WorkItemNotFoundException("Work item with id " + workItemId + " was not found in process instance " + this.id(), workItemId));
        return new BaseWorkItem(workItemInstance.getStringId(), workItemInstance.getWorkItem().getStringId(), Long.toString(workItemInstance.getNode().getId()), workItemInstance.getWorkItem().getParameters().getOrDefault("TaskName", workItemInstance.getNodeName()), workItemInstance.getWorkItem().getState(), workItemInstance.getWorkItem().getPhaseId(), workItemInstance.getWorkItem().getPhaseStatus(), workItemInstance.getWorkItem().getParameters(), workItemInstance.getWorkItem().getResults());
    }

    public List<WorkItem> workItems(Policy<?> ... policies) {
        return this.workItems(WorkItemNodeInstance.class::isInstance, policies);
    }

    public List<WorkItem> workItems(Predicate<KogitoNodeInstance> p, Policy<?> ... policies) {
        ArrayList<WorkItem> list = new ArrayList<WorkItem>();
        for (org.jbpm.workflow.instance.NodeInstance ni : this.processInstance().getNodeInstances(true)) {
            if (!p.test(ni) || !((WorkItemNodeInstance)ni).getWorkItem().enforce(policies)) continue;
            BaseWorkItem taskName = new BaseWorkItem(ni.getStringId(), ((WorkItemNodeInstance)ni).getWorkItemId(), Long.toString(ni.getNode().getId()), ((WorkItemNodeInstance)ni).getWorkItem().getParameters().getOrDefault("TaskName", ni.getNodeName()), ((WorkItemNodeInstance)ni).getWorkItem().getState(), ((WorkItemNodeInstance)ni).getWorkItem().getPhaseId(), ((WorkItemNodeInstance)ni).getWorkItem().getPhaseStatus(), ((WorkItemNodeInstance)ni).getWorkItem().getParameters(), ((WorkItemNodeInstance)ni).getWorkItem().getResults());
            list.add(taskName);
        }
        return list;
    }

    public void completeWorkItem(String id, Map<String, Object> variables, Policy<?> ... policies) {
        this.getProcessRuntime().getKogitoProcessRuntime().getKogitoWorkItemManager().completeWorkItem(id, variables, policies);
        this.removeOnFinish();
    }

    public <R> R updateWorkItem(String id, Function<KogitoWorkItem, R> updater, Policy<?> ... policies) {
        Object result = this.getProcessRuntime().getKogitoProcessRuntime().getKogitoWorkItemManager().updateWorkItem(id, updater, policies);
        this.addToUnitOfWork(pi -> ((MutableProcessInstances)this.process.instances()).update(pi.id(), pi));
        return (R)result;
    }

    public void abortWorkItem(String id, Policy<?> ... policies) {
        this.getProcessRuntime().getKogitoProcessRuntime().getKogitoWorkItemManager().abortWorkItem(id, policies);
        this.removeOnFinish();
    }

    public void transitionWorkItem(String id, Transition<?> transition) {
        this.getProcessRuntime().getKogitoProcessRuntime().getKogitoWorkItemManager().transitionWorkItem(id, transition);
        this.removeOnFinish();
    }

    public Set<EventDescription<?>> events() {
        return this.processInstance().getEventDescriptions();
    }

    public Collection<Milestone> milestones() {
        return this.processInstance.milestones();
    }

    public Collection<AdHocFragment> adHocFragments() {
        return this.processInstance.adHocFragments();
    }

    protected void removeOnFinish() {
        if (this.processInstance.getState() != 1 && this.processInstance.getState() != 5) {
            this.removeCompletionListener();
            this.syncProcessInstance(this.processInstance);
            this.addToUnitOfWork(pi -> ((MutableProcessInstances)this.process.instances()).remove(pi.id()));
        } else {
            this.addToUnitOfWork(pi -> ((MutableProcessInstances)this.process.instances()).update(pi.id(), pi));
        }
        this.unbind(this.variables, this.processInstance().getVariables());
        this.status = this.processInstance.getState();
    }

    protected Map<String, Object> bind(T variables) {
        HashMap<String, Object> vmap = new HashMap<String, Object>();
        if (variables == null) {
            return vmap;
        }
        try {
            for (Field f : variables.getClass().getDeclaredFields()) {
                f.setAccessible(true);
                Object v = f.get(variables);
                vmap.put(f.getName(), v);
            }
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        vmap.put("$v", variables);
        return vmap;
    }

    protected void unbind(T variables, Map<String, Object> vmap) {
        if (vmap == null) {
            return;
        }
        try {
            for (Field f : variables.getClass().getDeclaredFields()) {
                f.setAccessible(true);
                f.set(variables, vmap.get(f.getName()));
            }
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        vmap.put("$v", variables);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractProcessInstance other = (AbstractProcessInstance)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.status == null ? other.status != null : !this.status.equals(other.status));
    }

    protected ProcessError buildProcessError() {
        WorkflowProcessInstance pi = this.processInstance();
        final String errorMessage = pi.getErrorMessage();
        final String nodeInError = pi.getNodeIdInError();
        final Throwable errorCause = pi.getErrorCause().orElse(null);
        return new ProcessError(){

            public String failedNodeId() {
                return nodeInError;
            }

            public String errorMessage() {
                return errorMessage;
            }

            public Throwable errorCause() {
                return errorCause;
            }

            public void retrigger() {
                WorkflowProcessInstanceImpl pInstance = (WorkflowProcessInstanceImpl)AbstractProcessInstance.this.processInstance();
                org.jbpm.workflow.instance.NodeInstance ni = pInstance.getByNodeDefinitionId(nodeInError, pInstance.getNodeContainer());
                pInstance.setState(1);
                pInstance.internalSetErrorNodeId(null);
                pInstance.internalSetErrorMessage(null);
                ni.trigger(null, "DROOLS_DEFAULT");
                AbstractProcessInstance.this.removeOnFinish();
            }

            public void skip() {
                WorkflowProcessInstanceImpl pInstance = (WorkflowProcessInstanceImpl)AbstractProcessInstance.this.processInstance();
                org.jbpm.workflow.instance.NodeInstance ni = pInstance.getByNodeDefinitionId(nodeInError, pInstance.getNodeContainer());
                pInstance.setState(1);
                pInstance.internalSetErrorNodeId(null);
                pInstance.internalSetErrorMessage(null);
                ((NodeInstanceImpl)ni).triggerCompleted("DROOLS_DEFAULT", true);
                AbstractProcessInstance.this.removeOnFinish();
            }
        };
    }

    private class StringCorrelationKey
    implements CorrelationKey {
        private final String correlationKey;

        public StringCorrelationKey(String correlationKey) {
            this.correlationKey = correlationKey;
        }

        public String getName() {
            return this.correlationKey;
        }

        public List<CorrelationProperty<?>> getProperties() {
            return Collections.emptyList();
        }

        public String toExternalForm() {
            return this.correlationKey;
        }
    }

    private class CompletionEventListener
    implements KogitoEventListener {
        private CompletionEventListener() {
        }

        public void signalEvent(String type, Object event) {
            AbstractProcessInstance.this.removeOnFinish();
        }

        public String[] getEventTypes() {
            return new String[]{"processInstanceCompleted:" + AbstractProcessInstance.this.processInstance.getStringId()};
        }
    }
}

