/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.drools.core.WorkItemHandlerNotFoundException;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.ParameterDefinition;
import org.jbpm.process.core.Work;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.instance.ContextInstance;
import org.jbpm.process.instance.ContextInstanceContainer;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.KogitoProcessContextImpl;
import org.jbpm.process.instance.context.exception.ExceptionScopeInstance;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.process.instance.impl.ContextInstanceFactory;
import org.jbpm.process.instance.impl.ContextInstanceFactoryRegistry;
import org.jbpm.workflow.core.impl.DataAssociation;
import org.jbpm.workflow.core.impl.NodeIoHelper;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.WorkflowRuntimeException;
import org.jbpm.workflow.instance.node.StateBasedNodeInstance;
import org.kie.api.definition.process.Node;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.process.EventListener;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.ProcessRuntime;
import org.kie.api.runtime.process.ProcessWorkItemHandlerException;
import org.kie.kogito.Model;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessContext;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemNodeInstance;
import org.kie.kogito.process.EventDescription;
import org.kie.kogito.process.GroupedNamedDataType;
import org.kie.kogito.process.IOEventDescription;
import org.kie.kogito.process.NamedDataType;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.Processes;
import org.kie.kogito.process.impl.AbstractProcessInstance;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.workitems.InternalKogitoWorkItem;
import org.kie.kogito.process.workitems.InternalKogitoWorkItemManager;
import org.kie.kogito.process.workitems.impl.KogitoWorkItemImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkItemNodeInstance
extends StateBasedNodeInstance
implements EventListener,
ContextInstanceContainer,
KogitoWorkItemNodeInstance {
    private static final long serialVersionUID = 510L;
    private static final Logger logger = LoggerFactory.getLogger(WorkItemNodeInstance.class);
    private static List<String> defaultOutputVariables = Arrays.asList("ActorId");
    private Map<String, List<ContextInstance>> subContextInstances = new HashMap<String, List<ContextInstance>>();
    private String workItemId;
    private transient InternalKogitoWorkItem workItem;
    private String exceptionHandlingProcessInstanceId;
    private int triggerCount = 0;

    protected WorkItemNode getWorkItemNode() {
        return (WorkItemNode)this.getNode();
    }

    public InternalKogitoWorkItem getWorkItem() {
        if (this.workItem == null && this.workItemId != null) {
            this.workItem = ((InternalKogitoWorkItemManager)this.getProcessInstance().getKnowledgeRuntime().getWorkItemManager()).getWorkItem(this.workItemId);
        }
        return this.workItem;
    }

    public String getWorkItemId() {
        return this.workItemId;
    }

    public void internalSetWorkItemId(String workItemId) {
        this.workItemId = workItemId;
    }

    public void internalSetWorkItem(InternalKogitoWorkItem workItem) {
        this.workItem = workItem;
        this.workItem.setProcessInstance((KogitoProcessInstance)this.getProcessInstance());
        this.workItem.setNodeInstance((KogitoNodeInstance)this);
    }

    @Override
    public boolean isInversionOfControl() {
        return false;
    }

    public void internalRegisterWorkItem() {
        ((InternalKogitoWorkItemManager)this.getProcessInstance().getKnowledgeRuntime().getWorkItemManager()).internalAddWorkItem(this.workItem);
    }

    public void internalRemoveWorkItem() {
        ((InternalKogitoWorkItemManager)this.getProcessInstance().getKnowledgeRuntime().getWorkItemManager()).internalRemoveWorkItem(this.workItem.getStringId());
    }

    @Override
    public void internalTrigger(KogitoNodeInstance from, String type) {
        super.internalTrigger(from, type);
        if (this.getNodeInstanceContainer().getNodeInstance(this.getStringId()) == null) {
            return;
        }
        WorkItemNode workItemNode = this.getWorkItemNode();
        this.createWorkItem(workItemNode);
        if (workItemNode.isWaitForCompletion()) {
            this.addWorkItemListener();
        }
        String deploymentId = (String)this.getProcessInstance().getKnowledgeRuntime().getEnvironment().get("deploymentId");
        this.workItem.setDeploymentId(deploymentId);
        this.workItem.setNodeInstanceId(this.getStringId());
        this.workItem.setNodeId(this.getNodeId());
        this.workItem.setNodeInstance((KogitoNodeInstance)this);
        this.workItem.setProcessInstance((KogitoProcessInstance)this.getProcessInstance());
        if (workItemNode.getWork().getWorkParametersFactory() != null) {
            this.workItem.getParameters().putAll((Map)workItemNode.getWork().getWorkParametersFactory().apply((Object)this.workItem));
        }
        this.processWorkItemHandler(() -> ((InternalKogitoWorkItemManager)InternalProcessRuntime.asKogitoProcessRuntime((ProcessRuntime)this.getProcessInstance().getKnowledgeRuntime()).getKogitoWorkItemManager()).internalExecuteWorkItem(this.workItem));
        if (!workItemNode.isWaitForCompletion()) {
            this.triggerCompleted();
        }
        this.workItemId = this.workItem.getStringId();
    }

    private void processWorkItemHandler(Runnable handler) {
        if (this.isInversionOfControl()) {
            this.getProcessInstance().getKnowledgeRuntime().update(this.getProcessInstance().getKnowledgeRuntime().getFactHandle((Object)this), (Object)this);
        } else {
            try {
                handler.run();
            }
            catch (WorkItemHandlerNotFoundException wihnfe) {
                this.getProcessInstance().setState(3);
                throw wihnfe;
            }
            catch (ProcessWorkItemHandlerException handlerException) {
                if (this.triggerCount++ < handlerException.getRetries() + 1) {
                    this.workItemId = this.workItem.getStringId();
                    this.handleWorkItemHandlerException(handlerException, this.workItem);
                }
                throw handlerException;
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    protected void handleException(String exceptionName, Exception e) {
        this.getExceptionScopeInstance(exceptionName, e).handleException(exceptionName, this.getProcessContext(e));
    }

    protected void handleException(Exception e) {
        this.getExceptionScopeInstance(e, e).handleException(e, this.getProcessContext(e));
    }

    private ExceptionScopeInstance getExceptionScopeInstance(Object context, Exception e) {
        ExceptionScopeInstance exceptionScopeInstance = (ExceptionScopeInstance)this.resolveContextInstance("ExceptionScope", context);
        if (exceptionScopeInstance == null) {
            throw new WorkflowRuntimeException(this, this.getProcessInstance(), "Unable to execute Action: " + e.getMessage(), e);
        }
        this.workItemId = this.workItem.getStringId();
        return exceptionScopeInstance;
    }

    protected InternalKogitoWorkItem newWorkItem() {
        return new KogitoWorkItemImpl();
    }

    protected InternalKogitoWorkItem createWorkItem(WorkItemNode workItemNode) {
        Work work = workItemNode.getWork();
        this.workItem = this.newWorkItem();
        this.workItem.setName(work.getName());
        this.workItem.setProcessInstanceId(this.getProcessInstance().getStringId());
        HashMap<String, Object> resolvedParameters = new HashMap<String, Object>();
        Set<String> metaParameters = work.getMetaParameters();
        for (Map.Entry<String, Object> e : work.getParameters().entrySet()) {
            if (metaParameters.contains(e.getKey()) || e.getValue() == null) continue;
            resolvedParameters.put(e.getKey(), e.getValue());
            if (!(e.getValue() instanceof String)) continue;
            Object value = this.getVariable((String)e.getValue());
            if (value != null) {
                resolvedParameters.put(e.getKey(), value);
                continue;
            }
            resolvedParameters.put(e.getKey(), this.resolveValue(e.getValue()));
        }
        this.workItem.setStartDate(new Date());
        Function<String, Object> varResolver = varRef -> {
            if (resolvedParameters.containsKey(varRef)) {
                return resolvedParameters.get(varRef);
            }
            return this.getVariable((String)varRef);
        };
        Map<String, Object> inputSet = NodeIoHelper.processInputs(this, varResolver);
        inputSet.putAll(resolvedParameters);
        if (this.dynamicParameters != null) {
            inputSet.putAll(this.dynamicParameters);
        }
        this.workItem.getParameters().putAll(inputSet);
        return this.workItem;
    }

    public void triggerCompleted(InternalKogitoWorkItem workItem) {
        this.workItem = workItem;
        WorkItemNode workItemNode = this.getWorkItemNode();
        if (workItemNode != null && workItem.getState() == 2) {
            this.validateWorkItemResultVariable(this.getProcessInstance().getProcessName(), workItemNode.getOutAssociations(), workItem);
            NodeIoHelper.processOutputs(this, varRef -> workItem.getResult(varRef), varName -> this.getVariable((String)varName));
        }
        if (this.getNode() == null) {
            this.setMetaData("NodeType", workItem.getName());
            this.mapDynamicOutputData(workItem.getResults());
        }
        if (this.isInversionOfControl()) {
            InternalKnowledgeRuntime kruntime = this.getProcessInstance().getKnowledgeRuntime();
            kruntime.update(kruntime.getFactHandle((Object)this), (Object)this);
        } else {
            this.triggerCompleted();
        }
    }

    @Override
    public void cancel() {
        KogitoProcessRuntime kruntime;
        org.jbpm.process.instance.ProcessInstance processInstance;
        InternalKogitoWorkItem item = this.getWorkItem();
        if (item != null && item.getState() != 2 && item.getState() != 3) {
            try {
                ((InternalKogitoWorkItemManager)this.getProcessInstance().getKnowledgeRuntime().getWorkItemManager()).internalAbortWorkItem(item.getStringId());
            }
            catch (WorkItemHandlerNotFoundException wihnfe) {
                this.getProcessInstance().setState(3);
                throw wihnfe;
            }
        }
        if (this.exceptionHandlingProcessInstanceId != null && (processInstance = (org.jbpm.process.instance.ProcessInstance)(kruntime = this.getKieRuntimeForSubprocess()).getProcessInstance(this.exceptionHandlingProcessInstanceId)) != null) {
            processInstance.setState(3);
        }
        super.cancel();
    }

    @Override
    public void addEventListeners() {
        super.addEventListeners();
        this.addWorkItemListener();
        this.addExceptionProcessListener();
    }

    protected void addWorkItemListener() {
        this.getProcessInstance().addEventListener("workItemCompleted", this, false);
        this.getProcessInstance().addEventListener("workItemAborted", this, false);
    }

    protected void removeWorkItemListener() {
        this.getProcessInstance().removeEventListener("workItemCompleted", this, false);
        this.getProcessInstance().removeEventListener("workItemAborted", this, false);
    }

    @Override
    public void removeEventListeners() {
        super.removeEventListeners();
        this.removeWorkItemListener();
    }

    @Override
    public void signalEvent(String type, Object event) {
        if ("workItemCompleted".equals(type)) {
            this.workItemCompleted((InternalKogitoWorkItem)event);
        } else if ("workItemAborted".equals(type)) {
            this.workItemAborted((InternalKogitoWorkItem)event);
        } else if (("processInstanceCompleted:" + this.exceptionHandlingProcessInstanceId).equals(type)) {
            this.exceptionHandlingCompleted((WorkflowProcessInstance)event, null);
        } else if (type.equals("RuleFlow-Activate" + this.getProcessInstance().getProcessId() + "-" + this.getNode().getMetaData().get("UniqueId"))) {
            this.trigger(null, "DROOLS_DEFAULT");
        } else {
            super.signalEvent(type, event);
        }
    }

    @Override
    public String[] getEventTypes() {
        if (this.exceptionHandlingProcessInstanceId != null) {
            return new String[]{"workItemCompleted", "processInstanceCompleted:" + this.exceptionHandlingProcessInstanceId};
        }
        return new String[]{"workItemCompleted"};
    }

    public void workItemAborted(InternalKogitoWorkItem workItem) {
        if (workItem.getStringId().equals(this.workItemId) || this.workItemId == null && this.getWorkItem().getStringId().equals(workItem.getStringId())) {
            this.removeEventListeners();
            this.triggerCompleted(workItem);
        }
    }

    public void workItemCompleted(InternalKogitoWorkItem workItem) {
        if (workItem.getStringId().equals(this.workItemId) || this.workItemId == null && this.getWorkItem().getStringId().equals(workItem.getStringId())) {
            this.removeEventListeners();
            this.triggerCompleted(workItem);
        }
    }

    @Override
    public String getNodeName() {
        Node node = this.getNode();
        if (node == null) {
            Object nodeName = "[Dynamic]";
            InternalKogitoWorkItem item = this.getWorkItem();
            if (item != null) {
                nodeName = (String)nodeName + " " + item.getParameter("TaskName");
            }
            return nodeName;
        }
        return super.getNodeName();
    }

    @Override
    public List<ContextInstance> getContextInstances(String contextId) {
        return this.subContextInstances.get(contextId);
    }

    @Override
    public void addContextInstance(String contextId, ContextInstance contextInstance) {
        this.subContextInstances.computeIfAbsent(contextId, k -> new ArrayList()).add(contextInstance);
    }

    @Override
    public void removeContextInstance(String contextId, ContextInstance contextInstance) {
        List<ContextInstance> list = this.subContextInstances.get(contextId);
        if (list != null) {
            list.remove(contextInstance);
        }
    }

    @Override
    public ContextInstance getContextInstance(String contextId, long id) {
        List<ContextInstance> instances = this.subContextInstances.get(contextId);
        if (instances != null) {
            for (ContextInstance contextInstance : instances) {
                if (contextInstance.getContextId() != id) continue;
                return contextInstance;
            }
        }
        return null;
    }

    @Override
    public ContextInstance getContextInstance(Context context) {
        ContextInstanceFactory conf = ContextInstanceFactoryRegistry.INSTANCE.getContextInstanceFactory(context);
        if (conf == null) {
            throw new IllegalArgumentException("Illegal context type (registry not found): " + context.getClass());
        }
        ContextInstance contextInstance = conf.getContextInstance(context, this, this.getProcessInstance());
        if (contextInstance == null) {
            throw new IllegalArgumentException("Illegal context type (instance not found): " + context.getClass());
        }
        return contextInstance;
    }

    @Override
    public ContextContainer getContextContainer() {
        return this.getWorkItemNode();
    }

    public void validateWorkItemResultVariable(String processName, List<DataAssociation> outputs, InternalKogitoWorkItem workItem) {
        if (!VariableScope.isVariableStrictEnabled() || workItem.getResults().isEmpty()) {
            return;
        }
        ArrayList<String> outputNames = new ArrayList<String>();
        for (DataAssociation association : outputs) {
            if (association.getSources() != null) {
                outputNames.add(association.getSources().get(0).getLabel());
            }
            if (association.getAssignments() == null) continue;
            association.getAssignments().forEach(a -> outputNames.add(a.getFrom().getLabel()));
        }
        for (String outputName : workItem.getResults().keySet()) {
            if (outputNames.contains(outputName) || defaultOutputVariables.contains(outputName)) continue;
            throw new IllegalArgumentException("Data output '" + outputName + "' is not defined in process '" + processName + "' for task '" + workItem.getParameter("NodeName") + "'");
        }
    }

    private void handleWorkItemHandlerException(ProcessWorkItemHandlerException handlerException, InternalKogitoWorkItem workItem) {
        KogitoProcessRuntime kruntime = this.getKieRuntimeForSubprocess();
        Process process = ((Processes)kruntime.getApplication().get(Processes.class)).processById(handlerException.getProcessId());
        if (process == null) {
            logger.error("Cannot find process {}. Aborting error handling", (Object)handlerException.getProcessId());
            return;
        }
        AbstractProcessInstance kogitoProcessInstance = (AbstractProcessInstance)process.createInstance((Model)process.createModel());
        WorkflowProcessInstance processInstance = kogitoProcessInstance.internalGetProcessInstance();
        processInstance.setParentProcessInstanceId(this.getProcessInstance().getStringId());
        processInstance.setSignalCompletion(true);
        processInstance.setMetaData("ParentProcessInstanceId", this.getProcessInstance().getStringId());
        processInstance.setMetaData("ParentNodeInstanceId", this.getUniqueId());
        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)processInstance.getContextInstance("VariableScope");
        variableScopeInstance.setVariable("DeploymentId", workItem.getDeploymentId());
        variableScopeInstance.setVariable("ProcessInstanceId", workItem.getProcessInstanceStringId());
        variableScopeInstance.setVariable("WorkItemId", workItem.getStringId());
        variableScopeInstance.setVariable("NodeInstanceId", this.getStringId());
        variableScopeInstance.setVariable("ErrorMessage", handlerException.getMessage());
        variableScopeInstance.setVariable("Error", (Object)handlerException);
        for (Map.Entry entry : workItem.getParameters().entrySet()) {
            variableScopeInstance.setVariable((String)entry.getKey(), entry.getValue());
        }
        kogitoProcessInstance.start();
        this.exceptionHandlingProcessInstanceId = kogitoProcessInstance.id();
        if (processInstance.getState() == 2 || processInstance.getState() == 3) {
            this.exceptionHandlingCompleted(processInstance, handlerException);
        } else {
            this.addExceptionProcessListener();
        }
    }

    private void exceptionHandlingCompleted(WorkflowProcessInstance processInstance, ProcessWorkItemHandlerException handlerException) {
        Object errorVariable = processInstance.getVariable("Error");
        if (errorVariable instanceof ProcessWorkItemHandlerException) {
            handlerException = (ProcessWorkItemHandlerException)((Object)errorVariable);
        }
        InternalKogitoWorkItemManager kogitoWorkItemManager = (InternalKogitoWorkItemManager)InternalProcessRuntime.asKogitoProcessRuntime((ProcessRuntime)this.getProcessInstance().getKnowledgeRuntime()).getKogitoWorkItemManager();
        switch (handlerException.getStrategy()) {
            case ABORT: {
                kogitoWorkItemManager.abortWorkItem(this.getWorkItem().getStringId(), new Policy[0]);
                break;
            }
            case RETHROW: {
                String exceptionName = handlerException.getCause().getClass().getName();
                ExceptionScopeInstance exceptionScopeInstance = (ExceptionScopeInstance)this.resolveContextInstance("ExceptionScope", exceptionName);
                if (exceptionScopeInstance == null) {
                    throw new WorkflowRuntimeException(this, this.getProcessInstance(), "Unable to execute work item " + handlerException.getMessage(), handlerException.getCause());
                }
                KogitoProcessContextImpl context = new KogitoProcessContextImpl((KieRuntime)this.getProcessInstance().getKnowledgeRuntime());
                context.setProcessInstance((ProcessInstance)this.getProcessInstance());
                context.setNodeInstance((NodeInstance)this);
                context.getContextData().put("Exception", handlerException.getCause());
                exceptionScopeInstance.handleException(exceptionName, (KogitoProcessContext)context);
                break;
            }
            case RETRY: {
                HashMap parameters = new HashMap(this.getWorkItem().getParameters());
                parameters.putAll(processInstance.getVariables());
                this.processWorkItemHandler(() -> kogitoWorkItemManager.retryWorkItem(this.getWorkItem().getStringId(), parameters));
                break;
            }
            case COMPLETE: {
                kogitoWorkItemManager.completeWorkItem(this.getWorkItem().getStringId(), processInstance.getVariables(), new Policy[0]);
            }
        }
    }

    public void addExceptionProcessListener() {
        if (this.exceptionHandlingProcessInstanceId != null) {
            this.getProcessInstance().addEventListener("processInstanceCompleted:" + this.exceptionHandlingProcessInstanceId, this, true);
        }
    }

    public void removeExceptionProcessListeners() {
        super.removeEventListeners();
        this.getProcessInstance().removeEventListener("processInstanceCompleted:" + this.exceptionHandlingProcessInstanceId, this, true);
    }

    public String getExceptionHandlingProcessInstanceId() {
        return this.exceptionHandlingProcessInstanceId;
    }

    public void internalSetProcessInstanceId(String processInstanceId) {
        if (processInstanceId != null && !processInstanceId.isEmpty()) {
            this.exceptionHandlingProcessInstanceId = processInstanceId;
        }
    }

    protected KogitoProcessRuntime getKieRuntimeForSubprocess() {
        return InternalProcessRuntime.asKogitoProcessRuntime((ProcessRuntime)this.getProcessInstance().getKnowledgeRuntime());
    }

    public Set<EventDescription<?>> getEventDescriptions() {
        ArrayList<NamedDataType> inputs = new ArrayList<NamedDataType>();
        for (ParameterDefinition paramDef : this.getWorkItemNode().getWork().getParameterDefinitions()) {
            inputs.add(new NamedDataType(paramDef.getName(), (Object)paramDef.getType()));
        }
        ArrayList outputs = new ArrayList();
        VariableScope variableScope = (VariableScope)this.getProcessInstance().getContextContainer().getDefaultContext("VariableScope");
        this.getWorkItemNode().getOutAssociations().forEach(da -> da.getSources().forEach(s -> outputs.add(new NamedDataType(s.getLabel(), (Object)variableScope.findVariable(da.getTarget().getLabel()).getType()))));
        GroupedNamedDataType dataTypes = new GroupedNamedDataType();
        dataTypes.add("Input", inputs);
        dataTypes.add("Output", outputs);
        return Collections.singleton(new IOEventDescription("workItemCompleted", this.getNodeDefinitionId(), this.getNodeName(), "workItem", this.getWorkItemId(), this.getProcessInstance().getStringId(), dataTypes));
    }
}

