/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.util.StringUtils;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.instance.ContextInstance;
import org.jbpm.process.instance.ContextInstanceContainer;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.KogitoProcessContextImpl;
import org.jbpm.process.instance.StartProcessHelper;
import org.jbpm.process.instance.context.exception.ExceptionScopeInstance;
import org.jbpm.process.instance.impl.ContextInstanceFactory;
import org.jbpm.process.instance.impl.ContextInstanceFactoryRegistry;
import org.jbpm.workflow.core.impl.NodeIoHelper;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.jbpm.workflow.instance.node.StateBasedNodeInstance;
import org.kie.api.KieBase;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.process.EventListener;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.ProcessRuntime;
import org.kie.internal.KieInternalServices;
import org.kie.internal.process.CorrelationAwareProcessRuntime;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationKeyFactory;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessContext;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubProcessNodeInstance
extends StateBasedNodeInstance
implements EventListener,
ContextInstanceContainer {
    private static final long serialVersionUID = 510L;
    private static final Logger logger = LoggerFactory.getLogger(SubProcessNodeInstance.class);
    private Map<String, List<ContextInstance>> subContextInstances = new HashMap<String, List<ContextInstance>>();
    private String processInstanceId;

    protected SubProcessNode getSubProcessNode() {
        return (SubProcessNode)this.getNode();
    }

    @Override
    public void internalTrigger(KogitoNodeInstance from, String type) {
        String latestProcessId;
        super.internalTrigger(from, type);
        if (this.getNodeInstanceContainer().getNodeInstance(this.getStringId()) == null) {
            return;
        }
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("A SubProcess node only accepts default incoming connections!");
        }
        Map<String, Object> parameters = NodeIoHelper.processInputs(this, key -> this.getVariable((String)key));
        String processIdExpression = this.getSubProcessNode().getProcessId();
        if (processIdExpression == null) {
            processIdExpression = this.getSubProcessNode().getProcessName();
        }
        String processId = this.resolveExpression(processIdExpression);
        KieBase kbase = this.getProcessInstance().getKnowledgeRuntime().getKieBase();
        Process process = kbase.getProcess(processId);
        if (process == null && (latestProcessId = StartProcessHelper.findLatestProcessByName(kbase, processId)) != null) {
            processId = latestProcessId;
            process = kbase.getProcess(processId);
        }
        if (process == null) {
            logger.error("Could not find process {}", (Object)processId);
            logger.error("Aborting process");
            this.getProcessInstance().setState(3);
            throw new RuntimeException("Could not find process " + processId);
        }
        KogitoProcessRuntime kruntime = InternalProcessRuntime.asKogitoProcessRuntime((ProcessRuntime)this.getProcessInstance().getKnowledgeRuntime());
        if (this.getSubProcessNode().getMetaData("MICollectionInput") != null) {
            parameters.remove(this.getSubProcessNode().getMetaData("MICollectionInput"));
        }
        org.jbpm.process.instance.ProcessInstance processInstance = null;
        if (this.getProcessInstance().getCorrelationKey() != null) {
            ArrayList<String> businessKeys = new ArrayList<String>();
            businessKeys.add(this.getProcessInstance().getCorrelationKey());
            businessKeys.add(processId);
            businessKeys.add(String.valueOf(System.currentTimeMillis()));
            CorrelationKeyFactory correlationKeyFactory = KieInternalServices.Factory.get().newCorrelationKeyFactory();
            CorrelationKey subProcessCorrelationKey = correlationKeyFactory.newCorrelationKey(businessKeys);
            processInstance = (org.jbpm.process.instance.ProcessInstance)((CorrelationAwareProcessRuntime)kruntime).createProcessInstance(processId, subProcessCorrelationKey, parameters);
        } else {
            processInstance = (org.jbpm.process.instance.ProcessInstance)kruntime.createProcessInstance(processId, parameters);
        }
        this.processInstanceId = processInstance.getStringId();
        processInstance.setMetaData("ParentProcessInstanceId", this.getProcessInstance().getStringId());
        processInstance.setMetaData("ParentNodeInstanceId", this.getUniqueId());
        processInstance.setMetaData("ParentNodeId", this.getSubProcessNode().getUniqueId());
        processInstance.setParentProcessInstanceId(this.getProcessInstance().getStringId());
        processInstance.setRootProcessInstanceId(StringUtils.isEmpty((CharSequence)this.getProcessInstance().getRootProcessInstanceId()) ? this.getProcessInstance().getStringId() : this.getProcessInstance().getRootProcessInstanceId());
        processInstance.setRootProcessId(StringUtils.isEmpty((CharSequence)this.getProcessInstance().getRootProcessId()) ? this.getProcessInstance().getProcessId() : this.getProcessInstance().getRootProcessId());
        processInstance.setSignalCompletion(this.getSubProcessNode().isWaitForCompletion());
        kruntime.startProcessInstance(processInstance.getStringId());
        if (!this.getSubProcessNode().isWaitForCompletion()) {
            this.triggerCompleted();
        } else if (processInstance.getState() == 2 || processInstance.getState() == 3) {
            this.processInstanceCompleted(processInstance);
        } else {
            this.addProcessListener();
        }
    }

    @Override
    public void cancel() {
        KogitoProcessRuntime kruntime;
        org.jbpm.process.instance.ProcessInstance processInstance;
        super.cancel();
        if (!(this.getSubProcessNode() != null && this.getSubProcessNode().isIndependent() || (processInstance = (org.jbpm.process.instance.ProcessInstance)(kruntime = InternalProcessRuntime.asKogitoProcessRuntime((ProcessRuntime)this.getProcessInstance().getKnowledgeRuntime())).getProcessInstance(this.processInstanceId)) == null)) {
            processInstance.setState(3);
        }
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void internalSetProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public void addEventListeners() {
        super.addEventListeners();
        this.addProcessListener();
    }

    private void addProcessListener() {
        this.getProcessInstance().addEventListener("processInstanceCompleted:" + this.processInstanceId, this, true);
    }

    @Override
    public void removeEventListeners() {
        super.removeEventListeners();
        this.getProcessInstance().removeEventListener("processInstanceCompleted:" + this.processInstanceId, this, true);
    }

    @Override
    public void signalEvent(String type, Object event) {
        if (("processInstanceCompleted:" + this.processInstanceId).equals(type)) {
            this.processInstanceCompleted((org.jbpm.process.instance.ProcessInstance)event);
        } else {
            super.signalEvent(type, event);
        }
    }

    @Override
    public String[] getEventTypes() {
        return new String[]{"processInstanceCompleted:" + this.processInstanceId};
    }

    public void processInstanceCompleted(org.jbpm.process.instance.ProcessInstance processInstance) {
        this.removeEventListeners();
        Map outputSet = processInstance.getVariables();
        NodeIoHelper.processOutputs(this, varRef -> outputSet.get(varRef), varName -> this.getVariable((String)varName));
        if (processInstance.getState() == 3) {
            String faultName = processInstance.getOutcome() == null ? "" : processInstance.getOutcome();
            ExceptionScopeInstance exceptionScopeInstance = (ExceptionScopeInstance)this.resolveContextInstance("ExceptionScope", faultName);
            if (exceptionScopeInstance != null) {
                KogitoProcessContextImpl context = new KogitoProcessContextImpl((KieRuntime)this.getProcessInstance().getKnowledgeRuntime());
                context.setProcessInstance((ProcessInstance)this.getProcessInstance());
                context.setNodeInstance((NodeInstance)this);
                context.getContextData().put("Exception", processInstance.getFaultData());
                exceptionScopeInstance.handleException(faultName, (KogitoProcessContext)context);
                if (this.getSubProcessNode() != null && !this.getSubProcessNode().isIndependent() && this.getSubProcessNode().isAbortParent()) {
                    this.cancel();
                }
                return;
            }
            if (this.getSubProcessNode() != null && !this.getSubProcessNode().isIndependent() && this.getSubProcessNode().isAbortParent()) {
                this.getProcessInstance().setState(3, faultName);
                return;
            }
        }
        if (this.getNode() == null) {
            this.setMetaData("NodeType", "SubProcessNode");
        }
        this.triggerCompleted();
    }

    @Override
    public String getNodeName() {
        Node node = this.getNode();
        if (node == null) {
            return "[Dynamic] Sub Process";
        }
        return super.getNodeName();
    }

    @Override
    public List<ContextInstance> getContextInstances(String contextId) {
        return this.subContextInstances.get(contextId);
    }

    @Override
    public void addContextInstance(String contextId, ContextInstance contextInstance) {
        List<ContextInstance> list = this.subContextInstances.get(contextId);
        if (list == null) {
            list = new ArrayList<ContextInstance>();
            this.subContextInstances.put(contextId, list);
        }
        list.add(contextInstance);
    }

    @Override
    public void removeContextInstance(String contextId, ContextInstance contextInstance) {
        List<ContextInstance> list = this.subContextInstances.get(contextId);
        if (list != null) {
            list.remove(contextInstance);
        }
    }

    @Override
    public ContextInstance getContextInstance(String contextId, long id) {
        List<ContextInstance> contextInstances = this.subContextInstances.get(contextId);
        if (contextInstances != null) {
            for (ContextInstance contextInstance : contextInstances) {
                if (contextInstance.getContextId() != id) continue;
                return contextInstance;
            }
        }
        return null;
    }

    @Override
    public ContextInstance getContextInstance(Context context) {
        ContextInstanceFactory conf = ContextInstanceFactoryRegistry.INSTANCE.getContextInstanceFactory(context);
        if (conf == null) {
            throw new IllegalArgumentException("Illegal context type (registry not found): " + context.getClass());
        }
        ContextInstance contextInstance = conf.getContextInstance(context, this, this.getProcessInstance());
        if (contextInstance == null) {
            throw new IllegalArgumentException("Illegal context type (instance not found): " + context.getClass());
        }
        return contextInstance;
    }

    @Override
    public ContextContainer getContextContainer() {
        return this.getSubProcessNode();
    }
}

