/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.context.variable;

import java.util.List;
import java.util.Objects;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.ProcessInstance;
import org.kie.api.runtime.KieRuntime;
import org.kie.kogito.internal.process.event.KogitoObjectListener;
import org.kie.kogito.internal.process.event.KogitoProcessEventSupport;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;

public class VariableScopeListener
implements KogitoObjectListener {
    private final ProcessInstance processInstance;
    private final String variableIdPrefix;
    private final String variableInstanceIdPrefix;
    private final List<String> tags;

    public VariableScopeListener(ProcessInstance processInstance, String name, String variableIdPrefix, String variableInstanceIdPrefix, List<String> tags) {
        this.processInstance = processInstance;
        this.variableIdPrefix = this.getString(variableIdPrefix, name);
        this.variableInstanceIdPrefix = this.getString(variableInstanceIdPrefix, name);
        this.tags = tags;
    }

    private String getString(String prefix, String suffix) {
        return (String)(prefix == null ? "" : prefix + ".") + suffix;
    }

    public void afterValueChanged(Object container, String property, Object oldValue, Object newValue) {
        this.getProcessEventSupport().fireAfterVariableChanged(this.getString(this.variableIdPrefix, property), this.getString(this.variableInstanceIdPrefix, property), oldValue, newValue, this.tags, (KogitoProcessInstance)this.processInstance, null, (KieRuntime)this.processInstance.getKnowledgeRuntime());
    }

    public void beforeValueChanged(Object container, String property, Object oldValue, Object newValue) {
        this.getProcessEventSupport().fireBeforeVariableChanged(this.getString(this.variableIdPrefix, property), this.getString(this.variableInstanceIdPrefix, property), oldValue, newValue, this.tags, (KogitoProcessInstance)this.processInstance, null, (KieRuntime)this.processInstance.getKnowledgeRuntime());
    }

    private KogitoProcessEventSupport getProcessEventSupport() {
        return ((InternalProcessRuntime)this.processInstance.getKnowledgeRuntime().getProcessRuntime()).getProcessEventSupport();
    }

    public int hashCode() {
        return Objects.hash(this.processInstance, this.tags, this.variableIdPrefix, this.variableInstanceIdPrefix);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariableScopeListener other = (VariableScopeListener)obj;
        return Objects.equals(this.processInstance, other.processInstance) && Objects.equals(this.tags, other.tags) && Objects.equals(this.variableIdPrefix, other.variableIdPrefix) && Objects.equals(this.variableInstanceIdPrefix, other.variableInstanceIdPrefix);
    }
}

