/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.core.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import org.jbpm.process.core.correlation.CorrelationManager;
import org.jbpm.process.core.impl.ProcessImpl;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.util.PatternConstants;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.WorkflowModelValidator;
import org.jbpm.workflow.core.WorkflowProcess;
import org.jbpm.workflow.core.impl.NodeContainerImpl;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.impl.MVELProcessHelper;
import org.jbpm.workflow.instance.impl.ProcessInstanceResolverFactory;
import org.mvel2.integration.VariableResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowProcessImpl
extends ProcessImpl
implements WorkflowProcess,
NodeContainer {
    private static final long serialVersionUID = 510L;
    private static final Logger logger = LoggerFactory.getLogger(WorkflowProcessImpl.class);
    private boolean autoComplete = false;
    private boolean dynamic = false;
    private WorkflowModelValidator inputValidator;
    private WorkflowModelValidator outputValidator;
    private NodeContainer nodeContainer;
    private transient BiFunction<String, ProcessInstance, String> expressionEvaluator = (expression, p) -> {
        String evaluatedValue = expression;
        HashMap<String, String> replacements = new HashMap<String, String>();
        Matcher matcher = PatternConstants.PARAMETER_MATCHER.matcher(evaluatedValue);
        while (matcher.find()) {
            String paramName = matcher.group(1);
            if (replacements.get(paramName) != null) continue;
            try {
                String value = (String)MVELProcessHelper.evaluator().eval(paramName, (VariableResolverFactory)new ProcessInstanceResolverFactory((org.kie.api.runtime.process.WorkflowProcessInstance)((WorkflowProcessInstance)p)));
                replacements.put(paramName, value);
            }
            catch (Exception t) {
                logger.error("Could not resolve, parameter {} while evaluating expression {}", new Object[]{paramName, expression, t});
            }
        }
        for (Map.Entry replacement : replacements.entrySet()) {
            evaluatedValue = evaluatedValue.replace("#{" + (String)replacement.getKey() + "}", (CharSequence)replacement.getValue());
        }
        return evaluatedValue;
    };
    private CorrelationManager correlationManager = new CorrelationManager();

    public CorrelationManager getCorrelationManager() {
        return this.correlationManager;
    }

    public WorkflowProcessImpl() {
        this.nodeContainer = (NodeContainer)this.createNodeContainer();
    }

    protected org.kie.api.definition.process.NodeContainer createNodeContainer() {
        return new NodeContainerImpl();
    }

    public org.kie.api.definition.process.Node[] getNodes() {
        return this.nodeContainer.getNodes();
    }

    public org.kie.api.definition.process.Node getNode(long id) {
        return this.nodeContainer.getNode(id);
    }

    public org.kie.api.definition.process.Node getNodeByUniqueId(String s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public org.kie.api.definition.process.Node internalGetNode(long id) {
        try {
            return this.getNode(id);
        }
        catch (IllegalArgumentException e) {
            if (this.dynamic) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public void removeNode(org.kie.api.definition.process.Node node) {
        this.nodeContainer.removeNode(node);
        ((Node)node).setParentContainer(null);
    }

    @Override
    public void addNode(org.kie.api.definition.process.Node node) {
        this.nodeContainer.addNode(node);
        ((Node)node).setParentContainer(this);
    }

    @Override
    public boolean isAutoComplete() {
        return this.autoComplete;
    }

    public void setAutoComplete(boolean autoComplete) {
        this.autoComplete = autoComplete;
    }

    @Override
    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    @Override
    public Integer getProcessType() {
        if (this.dynamic) {
            return 2;
        }
        return 1;
    }

    public List<org.kie.api.definition.process.Node> getNodesRecursively() {
        ArrayList<org.kie.api.definition.process.Node> nodes = new ArrayList<org.kie.api.definition.process.Node>();
        this.processNodeContainer(this.nodeContainer, nodes);
        return nodes;
    }

    protected void processNodeContainer(NodeContainer nodeContainer, List<org.kie.api.definition.process.Node> nodes) {
        for (org.kie.api.definition.process.Node node : nodeContainer.getNodes()) {
            nodes.add(node);
            if (!(node instanceof NodeContainer)) continue;
            this.processNodeContainer((NodeContainer)node, nodes);
        }
    }

    protected org.kie.api.definition.process.Node getContainerNode(org.kie.api.definition.process.Node currentNode, NodeContainer nodeContainer, long nodeId) {
        for (org.kie.api.definition.process.Node node : nodeContainer.getNodes()) {
            if (nodeId == node.getId()) {
                return currentNode;
            }
            if (!(node instanceof NodeContainer)) continue;
            return this.getContainerNode(node, (NodeContainer)node, nodeId);
        }
        return null;
    }

    public org.kie.api.definition.process.Node getParentNode(long nodeId) {
        return this.getContainerNode(null, this.nodeContainer, nodeId);
    }

    public List<StartNode> getTimerStart() {
        org.kie.api.definition.process.Node[] nodes = this.getNodes();
        ArrayList<StartNode> timerStartNodes = new ArrayList<StartNode>();
        for (int i = 0; i < nodes.length; ++i) {
            if (!(nodes[i] instanceof StartNode) || ((StartNode)nodes[i]).getTimer() == null) continue;
            timerStartNodes.add((StartNode)nodes[i]);
        }
        return timerStartNodes;
    }

    @Override
    public void setExpressionEvaluator(BiFunction<String, ProcessInstance, String> expressionEvaluator) {
        this.expressionEvaluator = expressionEvaluator;
    }

    @Override
    public String evaluateExpression(String metaData, ProcessInstance processInstance) {
        return this.expressionEvaluator.apply(metaData, processInstance);
    }

    @Override
    public Optional<WorkflowModelValidator> getInputValidator() {
        return Optional.ofNullable(this.inputValidator);
    }

    @Override
    public void setInputValidator(WorkflowModelValidator inputValidator) {
        this.inputValidator = inputValidator;
    }

    @Override
    public Optional<WorkflowModelValidator> getOutputValidator() {
        return Optional.ofNullable(this.outputValidator);
    }

    @Override
    public void setOutputValidator(WorkflowModelValidator outputValidator) {
        this.outputValidator = outputValidator;
    }
}

