/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.repository.impl;

import java.lang.annotation.Annotation;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.kie.kogito.jobs.service.model.JobStatus;
import org.kie.kogito.jobs.service.model.ScheduledJob;
import org.kie.kogito.jobs.service.qualifier.Repository;
import org.kie.kogito.jobs.service.repository.ReactiveJobRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Default
@ApplicationScoped
public class JobRepositoryDelegate
implements ReactiveJobRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobRepositoryDelegate.class);
    private ReactiveJobRepository delegate;

    JobRepositoryDelegate() {
    }

    @Inject
    public JobRepositoryDelegate(@Any Instance<ReactiveJobRepository> instances, @ConfigProperty(name="kogito.jobs-service.persistence") Optional<String> persistence) {
        this.delegate = (ReactiveJobRepository)instances.select(new Annotation[]{new Repository.Literal(persistence.orElse("in-memory"))}).get();
        LOGGER.info("JobRepository selected {}", this.delegate.getClass());
    }

    @Override
    public CompletionStage<ScheduledJob> save(ScheduledJob job) {
        return this.delegate.save(job);
    }

    @Override
    public CompletionStage<ScheduledJob> get(String id) {
        return this.delegate.get(id);
    }

    @Override
    public CompletionStage<Boolean> exists(String id) {
        return this.delegate.exists(id);
    }

    @Override
    public CompletionStage<ScheduledJob> delete(String id) {
        return this.delegate.delete(id);
    }

    @Override
    public CompletionStage<ScheduledJob> delete(ScheduledJob job) {
        return this.delegate.delete(job);
    }

    @Override
    public PublisherBuilder<ScheduledJob> findByStatus(JobStatus ... status) {
        return this.delegate.findByStatus(status);
    }

    @Override
    public PublisherBuilder<ScheduledJob> findAll() {
        return this.delegate.findAll();
    }

    @Override
    public PublisherBuilder<ScheduledJob> findByStatusBetweenDatesOrderByPriority(ZonedDateTime from, ZonedDateTime to, JobStatus ... status) {
        return this.delegate.findByStatusBetweenDatesOrderByPriority(from, to, status);
    }
}

