/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.processes.devservices;

import com.fasterxml.jackson.databind.JsonNode;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.kogito.internal.process.event.DefaultKogitoProcessEventListener;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevModeWorkflowLogger
extends DefaultKogitoProcessEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DevModeWorkflowLogger.class);

    public void beforeProcessStarted(ProcessStartedEvent event) {
        LOGGER.info("Starting workflow '{}' ({})", (Object)event.getProcessInstance().getProcessId(), (Object)((KogitoProcessInstance)event.getProcessInstance()).getStringId());
        ((KogitoProcessInstance)event.getProcessInstance()).getVariables().forEach((name, value) -> {
            if ("workflowdata".equals(name)) {
                JsonNode node;
                if (value instanceof JsonNode && !(node = (JsonNode)value).isEmpty()) {
                    LOGGER.info("Workflow data \n{}", (Object)node.toPrettyString());
                }
            } else {
                LOGGER.info("Variable '{}' value: '{}'", name, value);
            }
        });
    }

    public void afterProcessStarted(ProcessStartedEvent event) {
        if (event.getProcessInstance().getState() != 2) {
            LOGGER.info("Workflow '{}' ({}) was started, now '{}'", new Object[]{event.getProcessInstance().getProcessId(), ((KogitoProcessInstance)event.getProcessInstance()).getStringId(), DevModeWorkflowLogger.getStatus(event.getProcessInstance().getState())});
        }
    }

    public void afterProcessCompleted(ProcessCompletedEvent event) {
        LOGGER.info("Workflow '{}' ({}) completed", (Object)event.getProcessInstance().getProcessId(), (Object)((KogitoProcessInstance)event.getProcessInstance()).getStringId());
    }

    public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
        String nodeName = event.getNodeInstance().getNodeName();
        if (!("EmbeddedStart".equals(nodeName) || "EmbeddedEnd".equals(nodeName) || "Script".equals(nodeName))) {
            LOGGER.info("Triggered node '{}' for process '{}' ({})", new Object[]{nodeName, event.getProcessInstance().getProcessId(), ((KogitoProcessInstance)event.getProcessInstance()).getStringId()});
        }
    }

    public void afterVariableChanged(ProcessVariableChangedEvent event) {
        if ("workflowdata".equals(event.getVariableId())) {
            JsonNode node;
            if (event.getNewValue() instanceof JsonNode && !(node = (JsonNode)event.getNewValue()).isEmpty()) {
                LOGGER.info("Workflow data change\n{}", (Object)node.toPrettyString());
            }
        } else {
            LOGGER.info("Variable '{}' changed value from: '{}', to: '{}'", new Object[]{event.getVariableId(), event.getOldValue(), event.getNewValue()});
        }
    }

    private static String getStatus(int status) {
        switch (status) {
            case 0: {
                return "PENDING";
            }
            case 1: {
                return "ACTIVE";
            }
            case 2: {
                return "COMPLETED";
            }
            case 3: {
                return "ABORTED";
            }
            case 4: {
                return "SUSPENDED";
            }
        }
        return "UNKNOWN " + status;
    }
}

