/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.services.jobs.impl;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.kie.kogito.jobs.JobDescription;
import org.kie.kogito.jobs.JobsService;
import org.kie.kogito.jobs.ProcessInstanceJobDescription;
import org.kie.kogito.jobs.ProcessJobDescription;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceOptimisticLockingException;
import org.kie.kogito.process.Processes;
import org.kie.kogito.services.jobs.impl.TriggerJobCommand;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryJobService
implements JobsService,
AutoCloseable {
    public static final String IN_MEMORY_JOB_SERVICE_POOL_SIZE_PROPERTY = "kogito.in-memory.job-service.pool-size";
    private static final Logger LOGGER = LoggerFactory.getLogger(InMemoryJobService.class);
    protected static final String TRIGGER = "timer";
    protected final ScheduledExecutorService scheduler;
    protected final UnitOfWorkManager unitOfWorkManager;
    protected ConcurrentHashMap<String, ScheduledFuture<?>> scheduledJobs = new ConcurrentHashMap();
    private final Processes processes;
    private static final ConcurrentHashMap<Processes, InMemoryJobService> INSTANCE = new ConcurrentHashMap();

    protected InMemoryJobService(Processes processes, UnitOfWorkManager unitOfWorkManager) {
        this(processes, unitOfWorkManager, new ScheduledThreadPoolExecutor(Integer.parseInt(System.getProperty(IN_MEMORY_JOB_SERVICE_POOL_SIZE_PROPERTY, "10"))));
    }

    protected InMemoryJobService(Processes processes, UnitOfWorkManager unitOfWorkManager, ScheduledExecutorService scheduler) {
        this.processes = processes;
        this.unitOfWorkManager = unitOfWorkManager;
        this.scheduler = scheduler;
    }

    public static InMemoryJobService get(Processes processes, UnitOfWorkManager unitOfWorkManager) {
        Objects.requireNonNull(processes);
        Objects.requireNonNull(unitOfWorkManager);
        return INSTANCE.computeIfAbsent(processes, k -> new InMemoryJobService(processes, unitOfWorkManager));
    }

    public static InMemoryJobService get(Processes processes, UnitOfWorkManager unitOfWorkManager, ScheduledExecutorService scheduler) {
        Objects.requireNonNull(processes);
        Objects.requireNonNull(unitOfWorkManager);
        Objects.requireNonNull(scheduler);
        return INSTANCE.computeIfAbsent(processes, k -> new InMemoryJobService(processes, unitOfWorkManager, scheduler));
    }

    public String scheduleProcessJob(ProcessJobDescription description) {
        LOGGER.debug("ScheduleProcessJob: {}", (Object)description);
        ScheduledFuture<?> future = description.expirationTime().repeatInterval() != null ? this.scheduler.scheduleAtFixedRate(this.repeatableProcessJobByDescription(description), this.calculateDelay((JobDescription)description), description.expirationTime().repeatInterval(), TimeUnit.MILLISECONDS) : this.scheduler.schedule(this.processJobByDescription(description), this.calculateDelay((JobDescription)description), TimeUnit.MILLISECONDS);
        this.scheduledJobs.put(description.id(), future);
        return description.id();
    }

    public String scheduleProcessInstanceJob(ProcessInstanceJobDescription description) {
        ScheduledFuture<?> future = description.expirationTime().repeatInterval() != null ? this.scheduler.scheduleAtFixedRate(this.getSignalProcessInstanceCommand(description, false, description.expirationTime().repeatLimit()), this.calculateDelay((JobDescription)description), description.expirationTime().repeatInterval(), TimeUnit.MILLISECONDS) : this.scheduler.schedule(this.getSignalProcessInstanceCommand(description, true, 1), this.calculateDelay((JobDescription)description), TimeUnit.MILLISECONDS);
        this.scheduledJobs.put(description.id(), future);
        return description.id();
    }

    public Runnable getSignalProcessInstanceCommand(ProcessInstanceJobDescription description, boolean remove, int limit) {
        return new SignalProcessInstanceOnExpiredTimer(description.id(), description.timerId(), description.processInstanceId(), description.processId(), remove, limit);
    }

    public boolean cancelJob(String id) {
        return this.cancelJob(id, true);
    }

    public boolean cancelJob(String id, boolean force) {
        LOGGER.debug("Cancel Job: {}", (Object)id);
        if (this.scheduledJobs.containsKey(id)) {
            return this.scheduledJobs.remove(id).cancel(force);
        }
        return false;
    }

    protected long calculateDelay(JobDescription description) {
        long delay = Duration.between(ZonedDateTime.now(), description.expirationTime().get()).toMillis();
        if (delay <= 0L) {
            return 1L;
        }
        return delay;
    }

    protected Runnable processJobByDescription(ProcessJobDescription description) {
        return new StartProcessOnExpiredTimer(description.id(), description.process(), true, -1);
    }

    protected Runnable repeatableProcessJobByDescription(ProcessJobDescription description) {
        return new StartProcessOnExpiredTimer(description.id(), description.process(), false, description.expirationTime().repeatLimit());
    }

    @Override
    public void close() throws Exception {
        this.scheduledJobs.clear();
        this.scheduler.shutdown();
    }

    private class StartProcessOnExpiredTimer
    implements Runnable {
        private final String id;
        private boolean removeAtExecution;
        private Process process;
        private Integer limit;

        private StartProcessOnExpiredTimer(String id, Process<?> process, boolean removeAtExecution, Integer limit) {
            this.id = id;
            this.process = process;
            this.removeAtExecution = removeAtExecution;
            this.limit = limit;
        }

        @Override
        public void run() {
            try {
                LOGGER.debug("Job {} started", (Object)this.id);
                UnitOfWorkExecutor.executeInUnitOfWork(InMemoryJobService.this.unitOfWorkManager, () -> {
                    ProcessInstance pi = this.process.createInstance(this.process.createModel());
                    if (pi != null) {
                        pi.start(InMemoryJobService.TRIGGER, null);
                    }
                    return null;
                });
                Integer n = this.limit;
                Integer n2 = this.limit = Integer.valueOf(this.limit - 1);
                if (this.limit == 0) {
                    InMemoryJobService.this.cancelJob(this.id, false);
                }
                LOGGER.debug("Job {} completed", (Object)this.id);
            }
            finally {
                if (this.removeAtExecution) {
                    InMemoryJobService.this.cancelJob(this.id, true);
                }
            }
        }
    }

    private class SignalProcessInstanceOnExpiredTimer
    implements Runnable {
        private final String id;
        private final String timerId;
        private boolean removeAtExecution;
        private String processInstanceId;
        private Integer limit;
        private String processId;

        private SignalProcessInstanceOnExpiredTimer(String id, String timerId, String processInstanceId, String processId, boolean removeAtExecution, Integer limit) {
            this.id = id;
            this.timerId = timerId;
            this.processInstanceId = processInstanceId;
            this.removeAtExecution = removeAtExecution;
            this.limit = limit;
            this.processId = processId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                LOGGER.info("Job {} started", (Object)this.id);
                Process process = InMemoryJobService.this.processes.processById(this.processId);
                Integer n = this.limit;
                Integer n2 = this.limit = Integer.valueOf(this.limit - 1);
                boolean executed = new TriggerJobCommand(this.processInstanceId, this.id, this.timerId, this.limit, process, InMemoryJobService.this.unitOfWorkManager).execute();
                if (this.limit == 0 || !executed) {
                    InMemoryJobService.this.cancelJob(this.id, false);
                }
                LOGGER.debug("Job {} completed", (Object)this.id);
            }
            catch (ProcessInstanceOptimisticLockingException ex) {
                LOGGER.info("Retrying Job {} due to: {}", (Object)this.id, (Object)ex.getMessage());
                Integer n = this.limit;
                Integer n3 = this.limit = Integer.valueOf(this.limit + 1);
                this.run();
            }
            finally {
                if (this.removeAtExecution) {
                    InMemoryJobService.this.cancelJob(this.id, true);
                }
            }
        }
    }
}

