/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.messaging.incoming;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEvent;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.kie.kogito.explainability.api.ExplainabilityResultDto;
import org.kie.kogito.explainability.api.ExplainabilityStatus;
import org.kie.kogito.explainability.api.FeatureImportanceDto;
import org.kie.kogito.explainability.api.SaliencyDto;
import org.kie.kogito.trusty.service.TrustyService;
import org.kie.kogito.trusty.service.messaging.BaseEventConsumer;
import org.kie.kogito.trusty.storage.api.model.Decision;
import org.kie.kogito.trusty.storage.api.model.DecisionOutcome;
import org.kie.kogito.trusty.storage.api.model.ExplainabilityResult;
import org.kie.kogito.trusty.storage.api.model.FeatureImportance;
import org.kie.kogito.trusty.storage.api.model.Saliency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ExplainabilityResultConsumer
extends BaseEventConsumer<ExplainabilityResultDto> {
    private static final Logger LOG = LoggerFactory.getLogger(ExplainabilityResultConsumer.class);
    private static final TypeReference<ExplainabilityResultDto> CLOUD_EVENT_TYPE = new TypeReference<ExplainabilityResultDto>(){};

    private ExplainabilityResultConsumer() {
    }

    @Inject
    public ExplainabilityResultConsumer(TrustyService service, ObjectMapper mapper) {
        super(service, mapper);
    }

    @Override
    @Incoming(value="trusty-explainability-result")
    public CompletionStage<Void> handleMessage(Message<String> message) {
        return super.handleMessage(message);
    }

    @Override
    protected void internalHandleCloudEvent(CloudEvent cloudEvent, ExplainabilityResultDto payload) {
        String executionId = payload.getExecutionId();
        Decision decision = this.getDecisionById(executionId);
        if (decision == null) {
            LOG.warn("Can't find decision related to explainability result (executionId={})", (Object)executionId);
        }
        this.service.storeExplainabilityResult(executionId, ExplainabilityResultConsumer.explainabilityResultFrom(payload, decision));
    }

    @Override
    protected TypeReference<ExplainabilityResultDto> getEventType() {
        return CLOUD_EVENT_TYPE;
    }

    protected Decision getDecisionById(String executionId) {
        try {
            return this.service.getDecisionById(executionId);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    protected static ExplainabilityResult explainabilityResultFrom(ExplainabilityResultDto dto, Decision decision) {
        if (dto == null) {
            return null;
        }
        Map outcomeNameToIdMap = decision == null ? Collections.emptyMap() : decision.getOutcomes().stream().collect(Collectors.toUnmodifiableMap(DecisionOutcome::getOutcomeName, DecisionOutcome::getOutcomeId));
        List saliencies = dto.getSaliencies() == null ? null : dto.getSaliencies().entrySet().stream().map(e -> ExplainabilityResultConsumer.saliencyFrom((String)outcomeNameToIdMap.get(e.getKey()), (String)e.getKey(), (SaliencyDto)e.getValue())).collect(Collectors.toList());
        return new ExplainabilityResult(dto.getExecutionId(), ExplainabilityResultConsumer.statusFrom(dto.getStatus()), dto.getStatusDetails(), saliencies);
    }

    protected static FeatureImportance featureImportanceFrom(FeatureImportanceDto dto) {
        if (dto == null) {
            return null;
        }
        return new FeatureImportance(dto.getFeatureName(), dto.getScore());
    }

    protected static Saliency saliencyFrom(String outcomeId, String outcomeName, SaliencyDto dto) {
        if (dto == null) {
            return null;
        }
        List featureImportance = dto.getFeatureImportance() == null ? null : dto.getFeatureImportance().stream().map(ExplainabilityResultConsumer::featureImportanceFrom).collect(Collectors.toList());
        return new Saliency(outcomeId, outcomeName, featureImportance);
    }

    protected static org.kie.kogito.trusty.storage.api.model.ExplainabilityStatus statusFrom(ExplainabilityStatus status) {
        switch (status) {
            case SUCCEEDED: {
                return org.kie.kogito.trusty.storage.api.model.ExplainabilityStatus.SUCCEEDED;
            }
            case FAILED: {
                return org.kie.kogito.trusty.storage.api.model.ExplainabilityStatus.FAILED;
            }
        }
        return null;
    }
}

