/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.trusty.service.responses;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.cloudevents.jackson.JsonFormat;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.kie.kogito.tracing.typedvalue.TypedValue;
import org.kie.kogito.trusty.service.responses.DecisionOutcomeResponse;
import org.kie.kogito.trusty.service.responses.DecisionOutcomesResponse;
import org.kie.kogito.trusty.service.responses.DecisionStructuredInputsResponse;
import org.kie.kogito.trusty.service.responses.ExecutionHeaderResponse;
import org.kie.kogito.trusty.service.responses.ExecutionType;
import org.kie.kogito.trusty.service.responses.MessageExceptionFieldResponse;
import org.kie.kogito.trusty.service.responses.MessageResponse;
import org.kie.kogito.trusty.service.responses.TypedVariableResponse;
import org.kie.kogito.trusty.storage.api.model.Decision;
import org.kie.kogito.trusty.storage.api.model.DecisionInput;
import org.kie.kogito.trusty.storage.api.model.DecisionOutcome;
import org.kie.kogito.trusty.storage.api.model.Execution;
import org.kie.kogito.trusty.storage.api.model.Message;
import org.kie.kogito.trusty.storage.api.model.MessageExceptionField;
import org.kie.kogito.trusty.storage.api.model.TypedVariable;

public class ResponseUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().registerModule((Module)JsonFormat.getCloudEventJacksonModule());

    public static DecisionOutcomeResponse decisionOutcomeResponseFrom(DecisionOutcome outcome) {
        return outcome == null ? null : new DecisionOutcomeResponse(outcome.getOutcomeId(), outcome.getOutcomeName(), outcome.getEvaluationStatus(), ResponseUtils.typedVariableResponseFrom(outcome.getOutcomeResult()), ResponseUtils.collectionFrom(outcome.getOutcomeInputs(), ResponseUtils::typedVariableResponseFrom), ResponseUtils.collectionFrom(outcome.getMessages(), ResponseUtils::messageResponseFrom), outcome.hasErrors());
    }

    public static DecisionOutcomesResponse decisionOutcomesResponseFrom(Decision decision) {
        if (decision == null) {
            return null;
        }
        Collection outcomes = decision.getOutcomes() == null ? null : (Collection)decision.getOutcomes().stream().map(ResponseUtils::decisionOutcomeResponseFrom).collect(Collectors.toList());
        return new DecisionOutcomesResponse(ResponseUtils.executionHeaderResponseFrom((Execution)decision), outcomes);
    }

    public static DecisionStructuredInputsResponse decisionStructuredInputsResponseFrom(Collection<DecisionInput> inputs) {
        return inputs == null ? null : new DecisionStructuredInputsResponse((Collection)inputs.stream().map(ResponseUtils::typedVariableResponseFrom).collect(Collectors.toList()));
    }

    public static DecisionStructuredInputsResponse decisionStructuredInputsResponseFrom(Decision decision) {
        return ResponseUtils.decisionStructuredInputsResponseFrom(decision.getInputs());
    }

    public static ExecutionHeaderResponse executionHeaderResponseFrom(Execution execution) {
        OffsetDateTime ldt = OffsetDateTime.ofInstant(Instant.ofEpochMilli(execution.getExecutionTimestamp()), ZoneOffset.UTC);
        return new ExecutionHeaderResponse(execution.getExecutionId(), ldt, execution.hasSucceeded(), execution.getExecutorName(), execution.getExecutedModelName(), execution.getExecutedModelNamespace(), ResponseUtils.executionTypeFrom(execution.getExecutionType()));
    }

    public static ExecutionType executionTypeFrom(org.kie.kogito.trusty.storage.api.model.ExecutionType executionType) {
        switch (executionType) {
            case DECISION: {
                return ExecutionType.DECISION;
            }
            case PROCESS: {
                return ExecutionType.PROCESS;
            }
        }
        throw new IllegalStateException();
    }

    public static MessageExceptionFieldResponse messageExceptionFieldResponseFrom(MessageExceptionField field) {
        return field == null ? null : new MessageExceptionFieldResponse(field.getClassName(), field.getMessage(), ResponseUtils.messageExceptionFieldResponseFrom(field.getCause()));
    }

    public static MessageResponse messageResponseFrom(Message message) {
        if (message == null) {
            return null;
        }
        String level = message.getLevel() == null ? null : message.getLevel().name();
        return new MessageResponse(level, message.getCategory(), message.getType(), message.getSourceId(), message.getText(), ResponseUtils.messageExceptionFieldResponseFrom(message.getException()));
    }

    public static TypedVariableResponse typedVariableResponseFrom(DecisionInput input) {
        return input != null ? ResponseUtils.typedVariableResponseFrom(input.getValue()) : null;
    }

    public static TypedVariableResponse typedVariableResponseFrom(TypedVariable value) {
        if (value == null) {
            return null;
        }
        switch (value.getKind()) {
            case COLLECTION: {
                return ResponseUtils.typedVariableResponseFromCollection(value);
            }
            case STRUCTURE: {
                return ResponseUtils.typedVariableResponseFromStructure(value);
            }
            case UNIT: {
                return ResponseUtils.typedVariableResponseFromUnit(value);
            }
        }
        throw new IllegalStateException(String.format("TypedVariable of kind %s can't be converted to TypedVariableResponse", value.getKind()));
    }

    private static TypedVariableResponse typedVariableResponseFromCollection(TypedVariable value) {
        boolean isCollectionOfStructures = value.getComponents() != null && value.getComponents().stream().anyMatch(t -> t.getKind() == TypedValue.Kind.STRUCTURE);
        JsonNode responseValue = isCollectionOfStructures || value.getComponents() == null ? null : (JsonNode)value.getComponents().stream().map(ResponseUtils::typedVariableResponseFromUnit).map(TypedVariableResponse::getValue).collect(() -> ((ObjectMapper)OBJECT_MAPPER).createArrayNode(), ArrayNode::add, ArrayNode::addAll);
        List responseComponents = !isCollectionOfStructures || value.getComponents() == null ? null : value.getComponents().stream().map(ResponseUtils::typedVariableResponseFromStructure).map(r -> r.getComponents().stream().collect(() -> ((ObjectMapper)OBJECT_MAPPER).createArrayNode(), ArrayNode::add, ArrayNode::addAll)).collect(Collectors.toList());
        return new TypedVariableResponse(value.getName(), value.getTypeRef(), responseValue, responseComponents);
    }

    private static TypedVariableResponse typedVariableResponseFromStructure(TypedVariable value) {
        List components = value.getComponents() == null ? null : value.getComponents().stream().map(ResponseUtils::typedVariableResponseFrom).map(arg_0 -> ((ObjectMapper)OBJECT_MAPPER).valueToTree(arg_0)).collect(Collectors.toList());
        return new TypedVariableResponse(value.getName(), value.getTypeRef(), null, components);
    }

    private static TypedVariableResponse typedVariableResponseFromUnit(TypedVariable value) {
        return new TypedVariableResponse(value.getName(), value.getTypeRef(), value.getValue(), null);
    }

    private static <T, U> Collection<U> collectionFrom(Collection<T> input, Function<T, U> mapper) {
        return input == null ? null : (Collection)input.stream().map(mapper).collect(Collectors.toList());
    }

    private ResponseUtils() {
    }
}

