/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.impl;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.ws.rs.core.Response;
import org.kie.api.command.Command;
import org.kie.internal.process.CorrelationKey;
import org.kie.remote.common.rest.KieRemoteHttpRequest;
import org.kie.remote.common.rest.KieRemoteHttpResponse;
import org.kie.server.api.commands.CallContainerCommand;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.CreateContainerCommand;
import org.kie.server.api.commands.DisposeContainerCommand;
import org.kie.server.api.commands.GetContainerInfoCommand;
import org.kie.server.api.commands.GetScannerInfoCommand;
import org.kie.server.api.commands.GetServerInfoCommand;
import org.kie.server.api.commands.ListContainersCommand;
import org.kie.server.api.commands.RegisterServerControllerCommand;
import org.kie.server.api.commands.UpdateReleaseIdCommand;
import org.kie.server.api.commands.UpdateScannerCommand;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingException;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.ServiceResponsesList;
import org.kie.server.api.model.Wrapped;
import org.kie.server.api.model.definition.AssociatedEntitiesDefinition;
import org.kie.server.api.model.definition.ProcessDefinition;
import org.kie.server.api.model.definition.ProcessDefinitionList;
import org.kie.server.api.model.definition.ServiceTasksDefinition;
import org.kie.server.api.model.definition.SubProcessesDefinition;
import org.kie.server.api.model.definition.TaskInputsDefinition;
import org.kie.server.api.model.definition.TaskOutputsDefinition;
import org.kie.server.api.model.definition.UserTaskDefinitionList;
import org.kie.server.api.model.definition.VariablesDefinition;
import org.kie.server.api.model.instance.NodeInstance;
import org.kie.server.api.model.instance.NodeInstanceList;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.ProcessInstanceList;
import org.kie.server.api.model.instance.TaskAttachment;
import org.kie.server.api.model.instance.TaskAttachmentList;
import org.kie.server.api.model.instance.TaskComment;
import org.kie.server.api.model.instance.TaskCommentList;
import org.kie.server.api.model.instance.TaskEventInstance;
import org.kie.server.api.model.instance.TaskEventInstanceList;
import org.kie.server.api.model.instance.TaskInstance;
import org.kie.server.api.model.instance.TaskSummary;
import org.kie.server.api.model.instance.TaskSummaryList;
import org.kie.server.api.model.instance.VariableInstance;
import org.kie.server.api.model.instance.VariableInstanceList;
import org.kie.server.api.model.instance.WorkItemInstance;
import org.kie.server.api.model.instance.WorkItemInstanceList;
import org.kie.server.api.rest.RestURI;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServicesClientImpl
implements KieServicesClient {
    private static Logger logger = LoggerFactory.getLogger(KieServicesClientImpl.class);
    private static final Boolean BYPASS_AUTH_USER = Boolean.parseBoolean(System.getProperty("org.kie.server.bypass.auth.user", "false"));
    private String baseURI;
    private final KieServicesConfiguration config;
    private final Marshaller marshaller;

    public KieServicesClientImpl(KieServicesConfiguration config) {
        this.config = config.clone();
        this.baseURI = config.getServerUrl();
        ClassLoader cl = Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : CommandScript.class.getClassLoader();
        this.marshaller = MarshallerFactory.getMarshaller(config.getExtraJaxbClasses(), (MarshallingFormat)config.getMarshallingFormat(), (ClassLoader)cl);
    }

    public KieServicesClientImpl(KieServicesConfiguration config, ClassLoader classLoader) {
        this.config = config.clone();
        this.baseURI = config.getServerUrl();
        this.marshaller = MarshallerFactory.getMarshaller(config.getExtraJaxbClasses(), (MarshallingFormat)config.getMarshallingFormat(), (ClassLoader)classLoader);
    }

    private String initializeURI(URL url, String servicePrefix) {
        if (url == null) {
            throw new IllegalArgumentException("The url may not be empty or null.");
        }
        try {
            url.toURI();
        }
        catch (URISyntaxException urise) {
            throw new IllegalArgumentException("URL (" + url.toExternalForm() + ") is incorrectly formatted: " + urise.getMessage(), urise);
        }
        String urlString = url.toExternalForm();
        if (!urlString.endsWith("/")) {
            urlString = urlString + "/";
        }
        urlString = urlString + "services/" + servicePrefix + "/server";
        try {
            URL serverPlusServicePrefixUrl = new URL(urlString);
        }
        catch (MalformedURLException murle) {
            throw new IllegalArgumentException("URL (" + url.toExternalForm() + ") is incorrectly formatted: " + murle.getMessage(), murle);
        }
        return urlString;
    }

    @Override
    public ServiceResponse<KieServerInfo> register(String controllerEndpoint, KieServerConfig kieServerConfig) {
        if (this.config.isRest()) {
            return this.makeHttpPostRequestAndCreateServiceResponse(this.baseURI + "/controller/" + controllerEndpoint, kieServerConfig, KieServerInfo.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new RegisterServerControllerCommand(controllerEndpoint, kieServerConfig)));
        return (ServiceResponse)this.executeJmsCommand(script).getResponses().get(0);
    }

    @Override
    public ServiceResponse<KieServerInfo> getServerInfo() {
        if (this.config.isRest()) {
            return this.makeHttpGetRequestAndCreateServiceResponse(this.baseURI, KieServerInfo.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new GetServerInfoCommand()));
        return (ServiceResponse)this.executeJmsCommand(script).getResponses().get(0);
    }

    @Override
    public ServiceResponse<KieContainerResourceList> listContainers() {
        if (this.config.isRest()) {
            return this.makeHttpGetRequestAndCreateServiceResponse(this.baseURI + "/containers", KieContainerResourceList.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new ListContainersCommand()));
        return (ServiceResponse)this.executeJmsCommand(script).getResponses().get(0);
    }

    @Override
    public ServiceResponse<KieContainerResource> createContainer(String id, KieContainerResource resource) {
        if (this.config.isRest()) {
            return this.makeHttpPutRequestAndCreateServiceResponse(this.baseURI + "/containers/" + id, resource, KieContainerResource.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new CreateContainerCommand(resource)));
        return (ServiceResponse)this.executeJmsCommand(script).getResponses().get(0);
    }

    @Override
    public ServiceResponse<KieContainerResource> getContainerInfo(String id) {
        if (this.config.isRest()) {
            return this.makeHttpGetRequestAndCreateServiceResponse(this.baseURI + "/containers/" + id, KieContainerResource.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new GetContainerInfoCommand(id)));
        return (ServiceResponse)this.executeJmsCommand(script).getResponses().get(0);
    }

    @Override
    public ServiceResponse<Void> disposeContainer(String id) {
        if (this.config.isRest()) {
            return this.makeHttpDeleteRequestAndCreateServiceResponse(this.baseURI + "/containers/" + id, Void.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new DisposeContainerCommand(id)));
        return (ServiceResponse)this.executeJmsCommand(script).getResponses().get(0);
    }

    @Override
    public ServiceResponse<String> executeCommands(String id, String payload) {
        if (this.config.isRest()) {
            return this.makeHttpPostRequestAndCreateServiceResponse(this.baseURI + "/containers/" + id, payload, String.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new CallContainerCommand(id, payload)));
        return (ServiceResponse)this.executeJmsCommand(script).getResponses().get(0);
    }

    @Override
    public ServiceResponse<String> executeCommands(String id, Command<?> cmd) {
        if (this.config.isRest()) {
            return this.makeHttpPostRequestAndCreateServiceResponse(this.baseURI + "/containers/" + id, cmd, String.class, this.getHeaders(cmd));
        }
        CommandScript script = new CommandScript(Collections.singletonList(new CallContainerCommand(id, this.serialize(cmd))));
        return (ServiceResponse)this.executeJmsCommand(script, cmd.getClass().getName()).getResponses().get(0);
    }

    @Override
    public ServiceResponsesList executeScript(CommandScript script) {
        if (this.config.isRest()) {
            return this.makeHttpPostRequestAndCreateCustomResponse(this.baseURI, script, ServiceResponsesList.class);
        }
        return this.executeJmsCommand(script);
    }

    @Override
    public ServiceResponse<KieScannerResource> getScannerInfo(String id) {
        if (this.config.isRest()) {
            return this.makeHttpGetRequestAndCreateServiceResponse(this.baseURI + "/containers/" + id + "/scanner", KieScannerResource.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new GetScannerInfoCommand(id)));
        return (ServiceResponse)this.executeJmsCommand(script).getResponses().get(0);
    }

    @Override
    public ServiceResponse<KieScannerResource> updateScanner(String id, KieScannerResource resource) {
        if (this.config.isRest()) {
            return this.makeHttpPostRequestAndCreateServiceResponse(this.baseURI + "/containers/" + id + "/scanner", resource, KieScannerResource.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new UpdateScannerCommand(id, resource)));
        return (ServiceResponse)this.executeJmsCommand(script).getResponses().get(0);
    }

    @Override
    public ServiceResponse<ReleaseId> updateReleaseId(String id, ReleaseId releaseId) {
        if (this.config.isRest()) {
            return this.makeHttpPostRequestAndCreateServiceResponse(this.baseURI + "/containers/" + id + "/release-id", releaseId, ReleaseId.class);
        }
        CommandScript script = new CommandScript(Collections.singletonList(new UpdateReleaseIdCommand(id, releaseId)));
        return (ServiceResponse)this.executeJmsCommand(script).getResponses().get(0);
    }

    @Override
    public ProcessDefinition getProcessDefinition(String containerId, String processId) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("pId", processId);
            return this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/process/definition/{pId}", valuesMap), ProcessDefinition.class);
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public SubProcessesDefinition getReusableSubProcessDefinitions(String containerId, String processId) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("pId", processId);
            return this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/process/definition/{pId}/subprocesses", valuesMap), SubProcessesDefinition.class);
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public VariablesDefinition getProcessVariableDefinitions(String containerId, String processId) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("pId", processId);
            return this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/process/definition/{pId}/variables", valuesMap), VariablesDefinition.class);
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public ServiceTasksDefinition getServiceTaskDefinitions(String containerId, String processId) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("pId", processId);
            return this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/process/definition/{pId}/tasks/service", valuesMap), ServiceTasksDefinition.class);
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public AssociatedEntitiesDefinition getAssociatedEntityDefinitions(String containerId, String processId) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("pId", processId);
            return this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/process/definition/{pId}/entities", valuesMap), AssociatedEntitiesDefinition.class);
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public UserTaskDefinitionList getUserTaskDefinitions(String containerId, String processId) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("pId", processId);
            return this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/process/definition/{pId}/tasks/user", valuesMap), UserTaskDefinitionList.class);
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public TaskInputsDefinition getUserTaskInputDefinitions(String containerId, String processId, String taskName) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("pId", processId);
            valuesMap.put("taskName", taskName);
            return this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/process/definition/{pId}/tasks/user/{taskName}/inputs", valuesMap), TaskInputsDefinition.class);
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public TaskOutputsDefinition getUserTaskOutputDefinitions(String containerId, String processId, String taskName) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("pId", processId);
            valuesMap.put("taskName", taskName);
            return this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/process/definition/{pId}/tasks/user/{taskName}/outputs", valuesMap), TaskOutputsDefinition.class);
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public Long startProcess(String containerId, String processId) {
        return this.startProcess(containerId, processId, (Map<String, Object>)null);
    }

    @Override
    public Long startProcess(String containerId, String processId, Map<String, Object> variables) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("pId", processId);
            Object result = this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/process/{pId}/instances", valuesMap), variables, Object.class);
            if (result instanceof Wrapped) {
                return (Long)((Wrapped)result).unwrap();
            }
            return ((Number)result).longValue();
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public Long startProcess(String containerId, String processId, CorrelationKey correlationKey) {
        return this.startProcess(containerId, processId, correlationKey, null);
    }

    @Override
    public Long startProcess(String containerId, String processId, CorrelationKey correlationKey, Map<String, Object> variables) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("pId", processId);
            valuesMap.put("correlationKey", correlationKey.toExternalForm());
            Object result = this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/process/{pId}/instances/correlation/{correlationKey}", valuesMap), variables, Object.class);
            if (result instanceof Wrapped) {
                return (Long)((Wrapped)result).unwrap();
            }
            return ((Number)result).longValue();
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public void abortProcessInstance(String containerId, Long processInstanceId) {
        if (!this.config.isRest()) {
            throw new UnsupportedOperationException("Not yet supported");
        }
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        valuesMap.put("id", containerId);
        valuesMap.put("pInstanceId", processInstanceId);
        this.makeHttpDeleteRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/process/instance/{pInstanceId}", valuesMap), null);
    }

    @Override
    public void abortProcessInstances(String containerId, List<Long> processInstanceIds) {
        if (!this.config.isRest()) {
            throw new UnsupportedOperationException("Not yet supported");
        }
        String queryStr = this.buildQueryString("instanceId", processInstanceIds);
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put("id", containerId);
        this.makeHttpDeleteRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/process/instances", valuesMap) + queryStr, null);
    }

    @Override
    public Object getProcessInstanceVariable(String containerId, Long processInstanceId, String variableName) {
        return this.getProcessInstanceVariable(containerId, processInstanceId, variableName, Object.class);
    }

    @Override
    public <T> T getProcessInstanceVariable(String containerId, Long processInstanceId, String variableName, Class<T> type) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("id", containerId);
            valuesMap.put("pInstanceId", processInstanceId);
            valuesMap.put("varName", variableName);
            T result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/process/instance/{pInstanceId}/variable/{varName}", valuesMap), type);
            if (result instanceof Wrapped) {
                return (T)((Wrapped)result).unwrap();
            }
            return result;
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public Map<String, Object> getProcessInstanceVariables(String containerId, Long processInstanceId) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("id", containerId);
            valuesMap.put("pInstanceId", processInstanceId);
            Object variables = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/process/instance/{pInstanceId}/variables", valuesMap), Object.class);
            if (variables instanceof Wrapped) {
                return (Map)((Wrapped)variables).unwrap();
            }
            return (Map)variables;
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public void signalProcessInstance(String containerId, Long processInstanceId, String signalName, Object event) {
        if (!this.config.isRest()) {
            throw new UnsupportedOperationException("Not yet supported");
        }
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        valuesMap.put("id", containerId);
        valuesMap.put("pInstanceId", processInstanceId);
        valuesMap.put("sName", signalName);
        HashMap<String, String> headers = new HashMap<String, String>();
        this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/process/instance/{pInstanceId}/signal/{sName}", valuesMap), event, String.class, headers);
    }

    @Override
    public void signalProcessInstances(String containerId, List<Long> processInstanceIds, String signalName, Object event) {
        if (!this.config.isRest()) {
            throw new UnsupportedOperationException("Not yet supported");
        }
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put("id", containerId);
        valuesMap.put("sName", signalName);
        String queryStr = this.buildQueryString("instanceId", processInstanceIds);
        HashMap<String, String> headers = new HashMap<String, String>();
        this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/process/instances/signal/{sName}", valuesMap) + queryStr, event, String.class, headers);
    }

    @Override
    public List<String> getAvailableSignals(String containerId, Long processInstanceId) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("id", containerId);
            valuesMap.put("pInstanceId", processInstanceId);
            Object signals = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/process/instance/{pInstanceId}/signals", valuesMap), Object.class);
            if (signals instanceof Wrapped) {
                return (List)((Wrapped)signals).unwrap();
            }
            return (List)signals;
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public void setProcessVariable(String containerId, Long processInstanceId, String variableId, Object value) {
        if (!this.config.isRest()) {
            throw new UnsupportedOperationException("Not yet supported");
        }
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        valuesMap.put("id", containerId);
        valuesMap.put("pInstanceId", processInstanceId);
        valuesMap.put("varName", variableId);
        this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/process/instance/{pInstanceId}/variable/{varName}", valuesMap), value, String.class, this.getHeaders(null));
    }

    @Override
    public void setProcessVariables(String containerId, Long processInstanceId, Map<String, Object> variables) {
        if (!this.config.isRest()) {
            throw new UnsupportedOperationException("Not yet supported");
        }
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        valuesMap.put("id", containerId);
        valuesMap.put("pInstanceId", processInstanceId);
        this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/process/instance/{pInstanceId}/variables", valuesMap), variables, String.class);
    }

    @Override
    public ProcessInstance getProcessInstance(String containerId, Long processInstanceId) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("id", containerId);
            valuesMap.put("pInstanceId", processInstanceId);
            return this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/process/instance/{pInstanceId}", valuesMap), ProcessInstance.class);
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public ProcessInstance getProcessInstance(String containerId, Long processInstanceId, boolean withVars) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("id", containerId);
            valuesMap.put("pInstanceId", processInstanceId);
            return this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/process/instance/{pInstanceId}", valuesMap) + "?withVars=" + withVars, ProcessInstance.class);
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public void completeWorkItem(String containerId, Long processInstanceId, Long id, Map<String, Object> results) {
        if (!this.config.isRest()) {
            throw new UnsupportedOperationException("Not yet supported");
        }
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        valuesMap.put("id", containerId);
        valuesMap.put("pInstanceId", processInstanceId);
        valuesMap.put("workItemId", id);
        this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/process/instance/{pInstanceId}/workitems/{workItemId}/completed", valuesMap), results, String.class, this.getHeaders(null));
    }

    @Override
    public void abortWorkItem(String containerId, Long processInstanceId, Long id) {
        if (!this.config.isRest()) {
            throw new UnsupportedOperationException("Not yet supported");
        }
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        valuesMap.put("id", containerId);
        valuesMap.put("pInstanceId", processInstanceId);
        valuesMap.put("workItemId", id);
        this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/process/instance/{pInstanceId}/workitems/{workItemId}/aborted", valuesMap), null, String.class, this.getHeaders(null));
    }

    @Override
    public WorkItemInstance getWorkItem(String containerId, Long processInstanceId, Long id) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("id", containerId);
            valuesMap.put("pInstanceId", processInstanceId);
            valuesMap.put("workItemId", id);
            return this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/process/instance/{pInstanceId}/workitems/{workItemId}", valuesMap), WorkItemInstance.class);
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public List<WorkItemInstance> getWorkItemByProcessInstance(String containerId, Long processInstanceId) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("id", containerId);
            valuesMap.put("pInstanceId", processInstanceId);
            WorkItemInstanceList list = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/process/instance/{pInstanceId}/workitems", valuesMap), WorkItemInstanceList.class);
            if (list != null && list.getWorkItems() != null) {
                return Arrays.asList(list.getWorkItems());
            }
            return Collections.emptyList();
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public void activateTask(String containerId, Long taskId, String userId) {
        if (!this.config.isRest()) {
            throw new UnsupportedOperationException("Not yet supported");
        }
        this.sendTaskOperation(containerId, taskId, "containers/{id}/tasks/{tInstanceId}/states/activated", this.getUserQueryStr(userId));
    }

    @Override
    public void claimTask(String containerId, Long taskId, String userId) {
        if (!this.config.isRest()) {
            throw new UnsupportedOperationException("Not yet supported");
        }
        this.sendTaskOperation(containerId, taskId, "containers/{id}/tasks/{tInstanceId}/states/claimed", this.getUserQueryStr(userId));
    }

    @Override
    public void completeTask(String containerId, Long taskId, String userId, Map<String, Object> params) {
        if (!this.config.isRest()) {
            throw new UnsupportedOperationException("Not yet supported");
        }
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        valuesMap.put("id", containerId);
        valuesMap.put("tInstanceId", taskId);
        this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/tasks/{tInstanceId}/states/completed", valuesMap) + this.getUserQueryStr(userId), params, String.class, this.getHeaders(null));
    }

    @Override
    public void delegateTask(String containerId, Long taskId, String userId, String targetUserId) {
        if (!this.config.isRest()) {
            throw new UnsupportedOperationException("Not yet supported");
        }
        this.sendTaskOperation(containerId, taskId, "containers/{id}/tasks/{tInstanceId}/states/delegated", this.getUserAndAdditionalParam(userId, "targetUser", targetUserId));
    }

    @Override
    public void exitTask(String containerId, Long taskId, String userId) {
        if (!this.config.isRest()) {
            throw new UnsupportedOperationException("Not yet supported");
        }
        this.sendTaskOperation(containerId, taskId, "containers/{id}/tasks/{tInstanceId}/states/exited", this.getUserQueryStr(userId));
    }

    @Override
    public void failTask(String containerId, Long taskId, String userId, Map<String, Object> params) {
        if (!this.config.isRest()) {
            throw new UnsupportedOperationException("Not yet supported");
        }
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        valuesMap.put("id", containerId);
        valuesMap.put("tInstanceId", taskId);
        this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/tasks/{tInstanceId}/states/failed", valuesMap) + this.getUserQueryStr(userId), params, String.class, this.getHeaders(null));
    }

    @Override
    public void forwardTask(String containerId, Long taskId, String userId, String targetEntityId) {
        if (!this.config.isRest()) {
            throw new UnsupportedOperationException("Not yet supported");
        }
        this.sendTaskOperation(containerId, taskId, "containers/{id}/tasks/{tInstanceId}/states/forwarded", this.getUserAndAdditionalParam(userId, "targetUser", targetEntityId));
    }

    @Override
    public void releaseTask(String containerId, Long taskId, String userId) {
        if (!this.config.isRest()) {
            throw new UnsupportedOperationException("Not yet supported");
        }
        this.sendTaskOperation(containerId, taskId, "containers/{id}/tasks/{tInstanceId}/states/released", this.getUserQueryStr(userId));
    }

    @Override
    public void resumeTask(String containerId, Long taskId, String userId) {
        if (!this.config.isRest()) {
            throw new UnsupportedOperationException("Not yet supported");
        }
        this.sendTaskOperation(containerId, taskId, "containers/{id}/tasks/{tInstanceId}/states/resumed", this.getUserQueryStr(userId));
    }

    @Override
    public void skipTask(String containerId, Long taskId, String userId) {
        if (!this.config.isRest()) {
            throw new UnsupportedOperationException("Not yet supported");
        }
        this.sendTaskOperation(containerId, taskId, "containers/{id}/tasks/{tInstanceId}/states/skipped", this.getUserQueryStr(userId));
    }

    @Override
    public void startTask(String containerId, Long taskId, String userId) {
        if (!this.config.isRest()) {
            throw new UnsupportedOperationException("Not yet supported");
        }
        this.sendTaskOperation(containerId, taskId, "containers/{id}/tasks/{tInstanceId}/states/started", this.getUserQueryStr(userId));
    }

    @Override
    public void stopTask(String containerId, Long taskId, String userId) {
        if (!this.config.isRest()) {
            throw new UnsupportedOperationException("Not yet supported");
        }
        this.sendTaskOperation(containerId, taskId, "containers/{id}/tasks/{tInstanceId}/states/stopped", this.getUserQueryStr(userId));
    }

    @Override
    public void suspendTask(String containerId, Long taskId, String userId) {
        if (!this.config.isRest()) {
            throw new UnsupportedOperationException("Not yet supported");
        }
        this.sendTaskOperation(containerId, taskId, "containers/{id}/tasks/{tInstanceId}/states/suspended", this.getUserQueryStr(userId));
    }

    @Override
    public void nominateTask(String containerId, Long taskId, String userId, List<String> potentialOwners) {
        if (!this.config.isRest()) {
            throw new UnsupportedOperationException("Not yet supported");
        }
        this.sendTaskOperation(containerId, taskId, "containers/{id}/tasks/{tInstanceId}/states/nominated", this.getUserAndAdditionalParams(userId, "potOwner", potentialOwners));
    }

    @Override
    public void setTaskPriority(String containerId, Long taskId, int priority) {
        if (!this.config.isRest()) {
            throw new UnsupportedOperationException("Not yet supported");
        }
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        valuesMap.put("id", containerId);
        valuesMap.put("tInstanceId", taskId);
        this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/tasks/{tInstanceId}/priority", valuesMap), priority, String.class, this.getHeaders(null));
    }

    @Override
    public void setTaskExpirationDate(String containerId, Long taskId, Date date) {
        if (!this.config.isRest()) {
            throw new UnsupportedOperationException("Not yet supported");
        }
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        valuesMap.put("id", containerId);
        valuesMap.put("tInstanceId", taskId);
        this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/tasks/{tInstanceId}/expiration", valuesMap), date, String.class, this.getHeaders(null));
    }

    @Override
    public void setTaskSkipable(String containerId, Long taskId, boolean skipable) {
        if (!this.config.isRest()) {
            throw new UnsupportedOperationException("Not yet supported");
        }
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        valuesMap.put("id", containerId);
        valuesMap.put("tInstanceId", taskId);
        this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/tasks/{tInstanceId}/skipable", valuesMap), skipable, String.class, this.getHeaders(null));
    }

    @Override
    public void setTaskName(String containerId, Long taskId, String name) {
        if (!this.config.isRest()) {
            throw new UnsupportedOperationException("Not yet supported");
        }
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        valuesMap.put("id", containerId);
        valuesMap.put("tInstanceId", taskId);
        this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/tasks/{tInstanceId}/name", valuesMap), name, String.class, this.getHeaders(null));
    }

    @Override
    public void setTaskDescription(String containerId, Long taskId, String description) {
        if (!this.config.isRest()) {
            throw new UnsupportedOperationException("Not yet supported");
        }
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        valuesMap.put("id", containerId);
        valuesMap.put("tInstanceId", taskId);
        this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/tasks/{tInstanceId}/description", valuesMap), description, String.class, this.getHeaders(description));
    }

    @Override
    public Long saveTaskContent(String containerId, Long taskId, Map<String, Object> values) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("id", containerId);
            valuesMap.put("tInstanceId", taskId);
            Object contentId = this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/tasks/{tInstanceId}/content/output", valuesMap), values, Object.class, this.getHeaders(null));
            if (contentId instanceof Wrapped) {
                return (Long)((Wrapped)contentId).unwrap();
            }
            return ((Number)contentId).longValue();
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public Map<String, Object> getTaskOutputContentByTaskId(String containerId, Long taskId) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("id", containerId);
            valuesMap.put("tInstanceId", taskId);
            Object variables = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/tasks/{tInstanceId}/content/output", valuesMap), Object.class);
            if (variables instanceof Wrapped) {
                return (Map)((Wrapped)variables).unwrap();
            }
            return (Map)variables;
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public Map<String, Object> getTaskInputContentByTaskId(String containerId, Long taskId) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("id", containerId);
            valuesMap.put("tInstanceId", taskId);
            Object variables = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/tasks/{tInstanceId}/content/input", valuesMap), Object.class);
            if (variables instanceof Wrapped) {
                return (Map)((Wrapped)variables).unwrap();
            }
            return (Map)variables;
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public void deleteTaskContent(String containerId, Long taskId, Long contentId) {
        if (!this.config.isRest()) {
            throw new UnsupportedOperationException("Not yet supported");
        }
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        valuesMap.put("id", containerId);
        valuesMap.put("tInstanceId", taskId);
        valuesMap.put("contentId", contentId);
        this.makeHttpDeleteRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/tasks/{tInstanceId}/content/{contentId}", valuesMap), null);
    }

    @Override
    public Long addTaskComment(String containerId, Long taskId, String text, String addedBy, Date addedOn) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("id", containerId);
            valuesMap.put("tInstanceId", taskId);
            TaskComment taskComment = TaskComment.builder().text(text).addedBy(addedBy).addedAt(addedOn).build();
            Object commentId = this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/tasks/{tInstanceId}/comments", valuesMap), taskComment, Object.class, this.getHeaders(taskComment));
            if (commentId instanceof Wrapped) {
                return (Long)((Wrapped)commentId).unwrap();
            }
            return ((Number)commentId).longValue();
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public void deleteTaskComment(String containerId, Long taskId, Long commentId) {
        if (!this.config.isRest()) {
            throw new UnsupportedOperationException("Not yet supported");
        }
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        valuesMap.put("id", containerId);
        valuesMap.put("tInstanceId", taskId);
        valuesMap.put("commentId", commentId);
        this.makeHttpDeleteRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/tasks/{tInstanceId}/comments/{commentId}", valuesMap), null);
    }

    @Override
    public List<TaskComment> getTaskCommentsByTaskId(String containerId, Long taskId) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("id", containerId);
            valuesMap.put("tInstanceId", taskId);
            TaskCommentList commentList = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/tasks/{tInstanceId}/comments", valuesMap), TaskCommentList.class);
            if (commentList.getTasks() != null) {
                return Arrays.asList(commentList.getTasks());
            }
            return Collections.emptyList();
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public TaskComment getTaskCommentById(String containerId, Long taskId, Long commentId) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("id", containerId);
            valuesMap.put("tInstanceId", taskId);
            valuesMap.put("commentId", commentId);
            TaskComment taskComment = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/tasks/{tInstanceId}/comments/{commentId}", valuesMap), TaskComment.class);
            return taskComment;
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public Long addTaskAttachment(String containerId, Long taskId, String userId, Object attachment) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("id", containerId);
            valuesMap.put("tInstanceId", taskId);
            Object attachmentId = this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/tasks/{tInstanceId}/attachments", valuesMap) + this.getUserQueryStr(userId), attachment, Object.class, this.getHeaders(null));
            if (attachmentId instanceof Wrapped) {
                return (Long)((Wrapped)attachmentId).unwrap();
            }
            return ((Number)attachmentId).longValue();
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public void deleteTaskAttachment(String containerId, Long taskId, Long attachmentId) {
        if (!this.config.isRest()) {
            throw new UnsupportedOperationException("Not yet supported");
        }
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        valuesMap.put("id", containerId);
        valuesMap.put("tInstanceId", taskId);
        valuesMap.put("attachmentId", attachmentId);
        this.makeHttpDeleteRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/tasks/{tInstanceId}/attachments/{attachmentId}", valuesMap), null);
    }

    @Override
    public TaskAttachment getTaskAttachmentById(String containerId, Long taskId, Long attachmentId) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("id", containerId);
            valuesMap.put("tInstanceId", taskId);
            valuesMap.put("attachmentId", attachmentId);
            TaskAttachment attachment = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/tasks/{tInstanceId}/attachments/{attachmentId}", valuesMap), TaskAttachment.class);
            return attachment;
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public Object getTaskAttachmentContentById(String containerId, Long taskId, Long attachmentId) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("id", containerId);
            valuesMap.put("tInstanceId", taskId);
            valuesMap.put("attachmentId", attachmentId);
            Object result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/tasks/{tInstanceId}/attachments/{attachmentId}/content", valuesMap), Object.class);
            if (result instanceof Wrapped) {
                return ((Wrapped)result).unwrap();
            }
            return result;
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public List<TaskAttachment> getTaskAttachmentsByTaskId(String containerId, Long taskId) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("id", containerId);
            valuesMap.put("tInstanceId", taskId);
            TaskAttachmentList attachmentList = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/tasks/{tInstanceId}/attachments", valuesMap), TaskAttachmentList.class);
            if (attachmentList.getTasks() != null) {
                return Arrays.asList(attachmentList.getTasks());
            }
            return Collections.emptyList();
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public TaskInstance getTaskInstance(String containerId, Long taskId) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("id", containerId);
            valuesMap.put("tInstanceId", taskId);
            TaskInstance result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/tasks/{tInstanceId}", valuesMap), TaskInstance.class);
            return result;
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public TaskInstance getTaskInstance(String containerId, Long taskId, boolean withInputs, boolean withOutputs, boolean withAssignments) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("id", containerId);
            valuesMap.put("tInstanceId", taskId);
            StringBuilder queryString = new StringBuilder();
            queryString.append("?withInputData").append("=").append(withInputs).append("&withOutputData").append("=").append(withOutputs).append("&withAssignments").append("=").append(withAssignments);
            TaskInstance result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/tasks/{tInstanceId}", valuesMap) + queryString.toString(), TaskInstance.class);
            return result;
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public List<ProcessDefinition> findProcessesById(String processId) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("pId", processId);
            ProcessDefinitionList result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"process/definitions/{pId}", valuesMap), ProcessDefinitionList.class);
            if (result != null && result.getProcesses() != null) {
                return Arrays.asList(result.getProcesses());
            }
            return Collections.emptyList();
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public ProcessDefinition findProcessByContainerIdProcessId(String containerId, String processId) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            valuesMap.put("pId", processId);
            ProcessDefinition result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/process/definitions/{pId}", valuesMap), ProcessDefinition.class);
            return result;
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public List<ProcessDefinition> findProcesses(Integer page, Integer pageSize) {
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String queryString = this.getPagingQueryString("", page, pageSize);
            ProcessDefinitionList result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"process/definitions", valuesMap) + queryString, ProcessDefinitionList.class);
            if (result != null && result.getProcesses() != null) {
                return Arrays.asList(result.getProcesses());
            }
            return Collections.emptyList();
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public List<ProcessDefinition> findProcesses(String filter, Integer page, Integer pageSize) {
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String queryString = this.getPagingQueryString("?filter=" + filter, page, pageSize);
            ProcessDefinitionList result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"process/definitions", valuesMap) + queryString, ProcessDefinitionList.class);
            if (result != null && result.getProcesses() != null) {
                return Arrays.asList(result.getProcesses());
            }
            return Collections.emptyList();
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public List<ProcessDefinition> findProcessesByContainerId(String containerId, Integer page, Integer pageSize) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            String queryString = this.getPagingQueryString("", page, pageSize);
            ProcessDefinitionList result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/process/definitions", valuesMap) + queryString, ProcessDefinitionList.class);
            if (result != null && result.getProcesses() != null) {
                return Arrays.asList(result.getProcesses());
            }
            return Collections.emptyList();
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public List<ProcessInstance> findProcessInstances(Integer page, Integer pageSize) {
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String queryString = this.getPagingQueryString("", page, pageSize);
            ProcessInstanceList result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"process/instances", valuesMap) + queryString, ProcessInstanceList.class);
            if (result != null && result.getProcessInstances() != null) {
                return Arrays.asList(result.getProcessInstances());
            }
            return Collections.emptyList();
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public List<ProcessInstance> findProcessInstancesByProcessId(String processId, List<Integer> status, Integer page, Integer pageSize) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("pId", processId);
            String statusQueryString = this.getAdditionalParams("", "status", status);
            String queryString = this.getPagingQueryString(statusQueryString, page, pageSize);
            ProcessInstanceList result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"process/{pId}/instances", valuesMap) + queryString, ProcessInstanceList.class);
            if (result != null && result.getProcessInstances() != null) {
                return Arrays.asList(result.getProcessInstances());
            }
            return Collections.emptyList();
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public List<ProcessInstance> findProcessInstancesByProcessName(String processName, List<Integer> status, Integer page, Integer pageSize) {
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String statusQueryString = this.getAdditionalParams("?processName=" + processName, "status", status);
            String queryString = this.getPagingQueryString(statusQueryString, page, pageSize);
            ProcessInstanceList result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"process/instances", valuesMap) + queryString, ProcessInstanceList.class);
            if (result != null && result.getProcessInstances() != null) {
                return Arrays.asList(result.getProcessInstances());
            }
            return Collections.emptyList();
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public List<ProcessInstance> findProcessInstancesByContainerId(String containerId, List<Integer> status, Integer page, Integer pageSize) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("id", containerId);
            String statusQueryString = this.getAdditionalParams("", "status", status);
            String queryString = this.getPagingQueryString(statusQueryString, page, pageSize);
            ProcessInstanceList result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"containers/{id}/process/instances", valuesMap) + queryString, ProcessInstanceList.class);
            if (result != null && result.getProcessInstances() != null) {
                return Arrays.asList(result.getProcessInstances());
            }
            return Collections.emptyList();
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public List<ProcessInstance> findProcessInstancesByStatus(List<Integer> status, Integer page, Integer pageSize) {
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String statusQueryString = this.getAdditionalParams("", "status", status);
            String queryString = this.getPagingQueryString(statusQueryString, page, pageSize);
            ProcessInstanceList result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"process/instances", valuesMap) + queryString, ProcessInstanceList.class);
            if (result != null && result.getProcessInstances() != null) {
                return Arrays.asList(result.getProcessInstances());
            }
            return Collections.emptyList();
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public List<ProcessInstance> findProcessInstancesByInitiator(String initiator, List<Integer> status, Integer page, Integer pageSize) {
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String statusQueryString = this.getAdditionalParams("?initiator=" + initiator, "status", status);
            String queryString = this.getPagingQueryString(statusQueryString, page, pageSize);
            ProcessInstanceList result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"process/instances", valuesMap) + queryString, ProcessInstanceList.class);
            if (result != null && result.getProcessInstances() != null) {
                return Arrays.asList(result.getProcessInstances());
            }
            return Collections.emptyList();
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public ProcessInstance findProcessInstanceById(Long processInstanceId) {
        if (this.config.isRest()) {
            HashMap<String, Long> valuesMap = new HashMap<String, Long>();
            valuesMap.put("pInstanceId", processInstanceId);
            ProcessInstance result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"process/instances/{pInstanceId}", valuesMap), ProcessInstance.class);
            return result;
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public ProcessInstance findProcessInstanceByCorrelationKey(CorrelationKey correlationKey) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("correlationKey", correlationKey.toExternalForm());
            ProcessInstance result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"process/instances/correlation/{correlationKey}", valuesMap), ProcessInstance.class);
            return result;
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public NodeInstance findNodeInstanceByWorkItemId(Long processInstanceId, Long workItemId) {
        if (this.config.isRest()) {
            HashMap<String, Long> valuesMap = new HashMap<String, Long>();
            valuesMap.put("pInstanceId", processInstanceId);
            valuesMap.put("workItemId", workItemId);
            NodeInstance result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"process/instances/{pInstanceId}/wi-nodes/instances/{workItemId}", valuesMap), NodeInstance.class);
            return result;
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public List<NodeInstance> findActiveNodeInstances(Long processInstanceId, Integer page, Integer pageSize) {
        if (this.config.isRest()) {
            HashMap<String, Long> valuesMap = new HashMap<String, Long>();
            valuesMap.put("pInstanceId", processInstanceId);
            String queryString = this.getPagingQueryString("?activeOnly=true", page, pageSize);
            NodeInstanceList result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"process/instances/{pInstanceId}/nodes/instances", valuesMap) + queryString, NodeInstanceList.class);
            if (result != null && result.getNodeInstances() != null) {
                return Arrays.asList(result.getNodeInstances());
            }
            return Collections.emptyList();
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public List<NodeInstance> findCompletedNodeInstances(Long processInstanceId, Integer page, Integer pageSize) {
        if (this.config.isRest()) {
            HashMap<String, Long> valuesMap = new HashMap<String, Long>();
            valuesMap.put("pInstanceId", processInstanceId);
            String queryString = this.getPagingQueryString("?completedOnly=true", page, pageSize);
            NodeInstanceList result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"process/instances/{pInstanceId}/nodes/instances", valuesMap) + queryString, NodeInstanceList.class);
            if (result != null && result.getNodeInstances() != null) {
                return Arrays.asList(result.getNodeInstances());
            }
            return Collections.emptyList();
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public List<NodeInstance> findNodeInstances(Long processInstanceId, Integer page, Integer pageSize) {
        if (this.config.isRest()) {
            HashMap<String, Long> valuesMap = new HashMap<String, Long>();
            valuesMap.put("pInstanceId", processInstanceId);
            String queryString = this.getPagingQueryString("", page, pageSize);
            NodeInstanceList result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"process/instances/{pInstanceId}/nodes/instances", valuesMap) + queryString, NodeInstanceList.class);
            if (result != null && result.getNodeInstances() != null) {
                return Arrays.asList(result.getNodeInstances());
            }
            return Collections.emptyList();
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public List<VariableInstance> findVariablesCurrentState(Long processInstanceId) {
        if (this.config.isRest()) {
            HashMap<String, Long> valuesMap = new HashMap<String, Long>();
            valuesMap.put("pInstanceId", processInstanceId);
            VariableInstanceList result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"process/instances/{pInstanceId}/variables/instances", valuesMap), VariableInstanceList.class);
            if (result != null && result.getVariableInstances() != null) {
                return Arrays.asList(result.getVariableInstances());
            }
            return Collections.emptyList();
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public List<VariableInstance> findVariableHistory(Long processInstanceId, String variableName, Integer page, Integer pageSize) {
        if (this.config.isRest()) {
            HashMap<String, Object> valuesMap = new HashMap<String, Object>();
            valuesMap.put("pInstanceId", processInstanceId);
            valuesMap.put("varName", variableName);
            String queryString = this.getPagingQueryString("", page, pageSize);
            VariableInstanceList result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"process/instances/{pInstanceId}/variables/instances/{varName}", valuesMap) + queryString, VariableInstanceList.class);
            if (result != null && result.getVariableInstances() != null) {
                return Arrays.asList(result.getVariableInstances());
            }
            return Collections.emptyList();
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public TaskInstance findTaskByWorkItemId(Long workItemId) {
        if (this.config.isRest()) {
            HashMap<String, Long> valuesMap = new HashMap<String, Long>();
            valuesMap.put("workItemId", workItemId);
            return this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"task/instances/workitem/{workItemId}", valuesMap), TaskInstance.class);
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public TaskInstance findTaskById(Long taskId) {
        if (this.config.isRest()) {
            HashMap<String, Long> valuesMap = new HashMap<String, Long>();
            valuesMap.put("tInstanceId", taskId);
            return this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"task/instances/{tInstanceId}", valuesMap), TaskInstance.class);
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public List<TaskSummary> findTasksAssignedAsBusinessAdministrator(String userId, Integer page, Integer pageSize) {
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String queryString = this.getUserAndPagingQueryString(userId, page, pageSize);
            TaskSummaryList taskSummaryList = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"task/instances/admins", valuesMap) + queryString, TaskSummaryList.class);
            if (taskSummaryList != null && taskSummaryList.getTasks() != null) {
                return Arrays.asList(taskSummaryList.getTasks());
            }
            return Collections.emptyList();
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public List<TaskSummary> findTasksAssignedAsBusinessAdministrator(String userId, List<String> status, Integer page, Integer pageSize) {
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String userQuery = this.getUserQueryStr(userId);
            String statusQuery = this.getAdditionalParams(userQuery, "status", status);
            String queryString = this.getPagingQueryString(statusQuery, page, pageSize);
            TaskSummaryList taskSummaryList = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"task/instances/admins", valuesMap) + queryString, TaskSummaryList.class);
            if (taskSummaryList != null && taskSummaryList.getTasks() != null) {
                return Arrays.asList(taskSummaryList.getTasks());
            }
            return Collections.emptyList();
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public List<TaskSummary> findTasksAssignedAsPotentialOwner(String userId, Integer page, Integer pageSize) {
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String queryString = this.getUserAndPagingQueryString(userId, page, pageSize);
            TaskSummaryList taskSummaryList = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"task/instances/pot-owners", valuesMap) + queryString, TaskSummaryList.class);
            if (taskSummaryList != null && taskSummaryList.getTasks() != null) {
                return Arrays.asList(taskSummaryList.getTasks());
            }
            return Collections.emptyList();
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public List<TaskSummary> findTasksAssignedAsPotentialOwner(String userId, List<String> status, Integer page, Integer pageSize) {
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String userQuery = this.getUserQueryStr(userId);
            String statusQuery = this.getAdditionalParams(userQuery, "status", status);
            String queryString = this.getPagingQueryString(statusQuery, page, pageSize);
            TaskSummaryList taskSummaryList = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"task/instances/pot-owners", valuesMap) + queryString, TaskSummaryList.class);
            if (taskSummaryList != null && taskSummaryList.getTasks() != null) {
                return Arrays.asList(taskSummaryList.getTasks());
            }
            return Collections.emptyList();
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public List<TaskSummary> findTasksAssignedAsPotentialOwner(String userId, List<String> groups, List<String> status, Integer page, Integer pageSize) {
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String userQuery = this.getUserQueryStr(userId);
            String statusQuery = this.getAdditionalParams(userQuery, "status", status);
            String groupsQuery = this.getAdditionalParams(statusQuery, "groups", groups);
            String queryString = this.getPagingQueryString(groupsQuery, page, pageSize);
            TaskSummaryList taskSummaryList = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"task/instances/pot-owners", valuesMap) + queryString, TaskSummaryList.class);
            if (taskSummaryList != null && taskSummaryList.getTasks() != null) {
                return Arrays.asList(taskSummaryList.getTasks());
            }
            return Collections.emptyList();
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public List<TaskSummary> findTasksOwned(String userId, Integer page, Integer pageSize) {
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String queryString = this.getUserAndPagingQueryString(userId, page, pageSize);
            TaskSummaryList taskSummaryList = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"task/instances/owners", valuesMap) + queryString, TaskSummaryList.class);
            if (taskSummaryList != null && taskSummaryList.getTasks() != null) {
                return Arrays.asList(taskSummaryList.getTasks());
            }
            return Collections.emptyList();
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public List<TaskSummary> findTasksOwned(String userId, List<String> status, Integer page, Integer pageSize) {
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String userQuery = this.getUserQueryStr(userId);
            String statusQuery = this.getAdditionalParams(userQuery, "status", status);
            String queryString = this.getPagingQueryString(statusQuery, page, pageSize);
            TaskSummaryList taskSummaryList = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"task/instances/owners", valuesMap) + queryString, TaskSummaryList.class);
            if (taskSummaryList != null && taskSummaryList.getTasks() != null) {
                return Arrays.asList(taskSummaryList.getTasks());
            }
            return Collections.emptyList();
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public List<TaskSummary> findTasksByStatusByProcessInstanceId(Long processInstanceId, List<String> status, Integer page, Integer pageSize) {
        if (this.config.isRest()) {
            HashMap<String, Long> valuesMap = new HashMap<String, Long>();
            valuesMap.put("pInstanceId", processInstanceId);
            String statusQuery = this.getAdditionalParams("", "status", status);
            String queryString = this.getPagingQueryString(statusQuery, page, pageSize);
            TaskSummaryList taskSummaryList = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"task/instances/process/{pInstanceId}", valuesMap) + queryString, TaskSummaryList.class);
            if (taskSummaryList != null && taskSummaryList.getTasks() != null) {
                return Arrays.asList(taskSummaryList.getTasks());
            }
            return Collections.emptyList();
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public List<TaskSummary> findTasks(String userId, Integer page, Integer pageSize) {
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String queryString = this.getUserAndPagingQueryString(userId, page, pageSize);
            TaskSummaryList taskSummaryList = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"task/instances", valuesMap) + queryString, TaskSummaryList.class);
            if (taskSummaryList != null && taskSummaryList.getTasks() != null) {
                return Arrays.asList(taskSummaryList.getTasks());
            }
            return Collections.emptyList();
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    @Override
    public List<TaskEventInstance> findTaskEvents(Long taskId, Integer page, Integer pageSize) {
        if (this.config.isRest()) {
            HashMap<String, Long> valuesMap = new HashMap<String, Long>();
            valuesMap.put("tInstanceId", taskId);
            String queryString = this.getPagingQueryString("", page, pageSize);
            TaskEventInstanceList taskSummaryList = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)"task/instances/{tInstanceId}/events", valuesMap) + queryString, TaskEventInstanceList.class);
            if (taskSummaryList != null && taskSummaryList.getTaskEvents() != null) {
                return Arrays.asList(taskSummaryList.getTaskEvents());
            }
            return Collections.emptyList();
        }
        throw new UnsupportedOperationException("Not yet supported");
    }

    private void sendTaskOperation(String containerId, Long taskId, String operation, String queryString) {
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        valuesMap.put("id", containerId);
        valuesMap.put("tInstanceId", taskId);
        this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.baseURI, (String)operation, valuesMap) + queryString, null, String.class, this.getHeaders(null));
    }

    private <T> ServiceResponse<T> makeHttpGetRequestAndCreateServiceResponse(String uri, Class<T> resultType) {
        logger.debug("About to send GET request to '{}'", (Object)uri);
        KieRemoteHttpRequest request = this.newRequest(uri).get();
        KieRemoteHttpResponse response = request.response();
        if (response.code() == Response.Status.OK.getStatusCode()) {
            ServiceResponse serviceResponse = this.deserialize(response.body(), ServiceResponse.class);
            this.checkResultType(serviceResponse, resultType);
            return serviceResponse;
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    private <T> T makeHttpGetRequestAndCreateCustomResponse(String uri, Class<T> resultType) {
        logger.debug("About to send GET request to '{}'", (Object)uri);
        KieRemoteHttpRequest request = this.newRequest(uri).get();
        KieRemoteHttpResponse response = request.response();
        if (response.code() == Response.Status.OK.getStatusCode()) {
            return this.deserialize(response.body(), resultType);
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    private <T> ServiceResponse<T> makeHttpPostRequestAndCreateServiceResponse(String uri, Object bodyObject, Class<T> resultType) {
        return this.makeHttpPostRequestAndCreateServiceResponse(uri, this.serialize(bodyObject), resultType);
    }

    private <T> ServiceResponse<T> makeHttpPostRequestAndCreateServiceResponse(String uri, Object bodyObject, Class<T> resultType, Map<String, String> headers) {
        return this.makeHttpPostRequestAndCreateServiceResponse(uri, this.serialize(bodyObject), resultType, headers);
    }

    private <T> ServiceResponse<T> makeHttpPostRequestAndCreateServiceResponse(String uri, String body, Class<T> resultType) {
        return this.makeHttpPostRequestAndCreateServiceResponse(uri, body, resultType, new HashMap<String, String>());
    }

    private <T> ServiceResponse<T> makeHttpPostRequestAndCreateServiceResponse(String uri, String body, Class<T> resultType, Map<String, String> headers) {
        logger.debug("About to send POST request to '{}' with payload '{}'", (Object)uri, (Object)body);
        KieRemoteHttpRequest request = this.newRequest(uri).headers(headers).body((CharSequence)body).post();
        KieRemoteHttpResponse response = request.response();
        if (response.code() == Response.Status.OK.getStatusCode()) {
            ServiceResponse serviceResponse = this.deserialize(response.body(), ServiceResponse.class);
            this.checkResultType(serviceResponse, resultType);
            return serviceResponse;
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    private <T> T makeHttpPostRequestAndCreateCustomResponse(String uri, Object bodyObject, Class<T> resultType, Map<String, String> headers) {
        return this.makeHttpPostRequestAndCreateCustomResponse(uri, this.serialize(bodyObject), resultType, headers);
    }

    private <T> T makeHttpPostRequestAndCreateCustomResponse(String uri, Object bodyObject, Class<T> resultType) {
        return this.makeHttpPostRequestAndCreateCustomResponse(uri, this.serialize(bodyObject), resultType, new HashMap<String, String>());
    }

    private <T> T makeHttpPostRequestAndCreateCustomResponse(String uri, String body, Class<T> resultType, Map<String, String> headers) {
        logger.debug("About to send POST request to '{}' with payload '{}'", (Object)uri, (Object)body);
        KieRemoteHttpRequest request = this.newRequest(uri).headers(headers).body((CharSequence)body).post();
        KieRemoteHttpResponse response = request.response();
        if (response.code() == Response.Status.OK.getStatusCode() || response.code() == Response.Status.CREATED.getStatusCode()) {
            return this.deserialize(response.body(), resultType);
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    private <T> ServiceResponse<T> makeHttpPutRequestAndCreateServiceResponse(String uri, Object bodyObject, Class<T> resultType) {
        return this.makeHttpPutRequestAndCreateServiceResponse(uri, this.serialize(bodyObject), resultType);
    }

    private <T> ServiceResponse<T> makeHttpPutRequestAndCreateServiceResponse(String uri, String body, Class<T> resultType) {
        logger.debug("About to send PUT request to '{}' with payload '{}'", (Object)uri, (Object)body);
        KieRemoteHttpRequest request = this.newRequest(uri).body((CharSequence)body).put();
        KieRemoteHttpResponse response = request.response();
        if (response.code() == Response.Status.CREATED.getStatusCode() || response.code() == Response.Status.BAD_REQUEST.getStatusCode()) {
            ServiceResponse serviceResponse = this.deserialize(response.body(), ServiceResponse.class);
            this.checkResultType(serviceResponse, resultType);
            return serviceResponse;
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    private <T> T makeHttpPutRequestAndCreateCustomResponse(String uri, Object bodyObject, Class<T> resultType, Map<String, String> headers) {
        return this.makeHttpPutRequestAndCreateCustomResponse(uri, this.serialize(bodyObject), resultType, headers);
    }

    private <T> T makeHttpPutRequestAndCreateCustomResponse(String uri, String body, Class<T> resultType, Map<String, String> headers) {
        logger.debug("About to send PUT request to '{}' with payload '{}'", (Object)uri, (Object)body);
        KieRemoteHttpRequest request = this.newRequest(uri).headers(headers).body((CharSequence)body).put();
        KieRemoteHttpResponse response = request.response();
        if (response.code() == Response.Status.CREATED.getStatusCode() || response.code() == Response.Status.BAD_REQUEST.getStatusCode()) {
            T serviceResponse = this.deserialize(response.body(), resultType);
            return serviceResponse;
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    private <T> ServiceResponse<T> makeHttpDeleteRequestAndCreateServiceResponse(String uri, Class<T> resultType) {
        logger.debug("About to send DELETE request to '{}' ", (Object)uri);
        KieRemoteHttpRequest request = this.newRequest(uri).delete();
        KieRemoteHttpResponse response = request.response();
        if (response.code() == Response.Status.OK.getStatusCode()) {
            ServiceResponse serviceResponse = this.deserialize(response.body(), ServiceResponse.class);
            this.checkResultType(serviceResponse, resultType);
            return serviceResponse;
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    private <T> T makeHttpDeleteRequestAndCreateCustomResponse(String uri, Class<T> resultType) {
        logger.debug("About to send DELETE request to '{}' ", (Object)uri);
        KieRemoteHttpRequest request = this.newRequest(uri).delete();
        KieRemoteHttpResponse response = request.response();
        if (response.code() == Response.Status.OK.getStatusCode() || response.code() == Response.Status.NO_CONTENT.getStatusCode()) {
            if (resultType == null) {
                return null;
            }
            return this.deserialize(response.body(), resultType);
        }
        throw this.createExceptionForUnexpectedResponseCode(request, response);
    }

    private KieRemoteHttpRequest newRequest(String uri) {
        KieRemoteHttpRequest httpRequest = KieRemoteHttpRequest.newRequest((String)uri).followRedirects(true).timeout(this.config.getTimeout());
        httpRequest.accept(this.getMediaType(this.config.getMarshallingFormat()));
        httpRequest.header("X-KIE-ContentType", (Object)this.config.getMarshallingFormat().toString());
        if (this.config.getUserName() != null && this.config.getPassword() != null) {
            httpRequest.basicAuthorization(this.config.getUserName(), this.config.getPassword());
        }
        return httpRequest;
    }

    private ServiceResponsesList executeJmsCommand(CommandScript command) {
        return this.executeJmsCommand(command, null);
    }

    private ServiceResponsesList executeJmsCommand(CommandScript command, String classType) {
        ConnectionFactory factory = this.config.getConnectionFactory();
        Queue sendQueue = this.config.getRequestQueue();
        Queue responseQueue = this.config.getResponseQueue();
        Connection connection = null;
        Session session = null;
        ServiceResponsesList cmdResponse = null;
        String corrId = UUID.randomUUID().toString();
        String selector = "JMSCorrelationID = '" + corrId + "'";
        try {
            Message response;
            Marshaller marshaller;
            MessageConsumer consumer;
            MessageProducer producer;
            try {
                connection = this.config.getPassword() != null ? factory.createConnection(this.config.getUserName(), this.config.getPassword()) : factory.createConnection();
                session = connection.createSession(false, 1);
                producer = session.createProducer((Destination)sendQueue);
                consumer = session.createConsumer((Destination)responseQueue, selector);
                connection.start();
            }
            catch (JMSException jmse) {
                throw new KieServicesException("Unable to setup a JMS connection.", jmse);
            }
            try {
                marshaller = MarshallerFactory.getMarshaller(this.config.getExtraJaxbClasses(), (MarshallingFormat)this.config.getMarshallingFormat(), (ClassLoader)CommandScript.class.getClassLoader());
                String xmlStr = marshaller.marshall((Object)command);
                TextMessage textMsg = session.createTextMessage(xmlStr);
                textMsg.setJMSCorrelationID(corrId);
                textMsg.setIntProperty("serialization_format", this.config.getMarshallingFormat().getId());
                if (classType != null) {
                    textMsg.setStringProperty("kie_class_type", classType);
                }
                producer.send((Message)textMsg);
            }
            catch (JMSException jmse) {
                throw new KieServicesException("Unable to send a JMS message.", jmse);
            }
            try {
                response = consumer.receive(this.config.getTimeout());
            }
            catch (JMSException jmse) {
                jmse.printStackTrace();
                throw new KieServicesException("Unable to receive or retrieve the JMS response.", jmse);
            }
            if (response == null) {
                logger.warn("Response is empty");
                ServiceResponsesList jmse = null;
                return jmse;
            }
            assert (response != null) : "Response is empty.";
            try {
                String responseStr = ((TextMessage)response).getText();
                ServiceResponsesList serviceResponsesList = cmdResponse = (ServiceResponsesList)marshaller.unmarshall(responseStr, ServiceResponsesList.class);
                return serviceResponsesList;
            }
            catch (JMSException jmse) {
                throw new KieServicesException("Unable to extract " + ServiceResponsesList.class.getSimpleName() + " instance from JMS response.", jmse);
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                    if (session != null) {
                        session.close();
                    }
                }
                catch (JMSException jmse) {
                    logger.warn("Unable to close connection or session!", (Throwable)jmse);
                }
            }
        }
    }

    private String getMediaType(MarshallingFormat format) {
        switch (format) {
            case JAXB: {
                return "application/xml";
            }
            case JSON: {
                return "application/json";
            }
        }
        return "application/xml";
    }

    private String serialize(Object object) {
        if (object == null) {
            return "";
        }
        try {
            return this.marshaller.marshall(object);
        }
        catch (MarshallingException e) {
            throw new KieServicesException("Error while serializing request data!", e);
        }
    }

    private <T> T deserialize(String content, Class<T> type) {
        logger.debug("About to deserialize content: \n '{}' \n into type: '{}'", (Object)content, type);
        if (content == null || content.isEmpty()) {
            return null;
        }
        try {
            return (T)this.marshaller.unmarshall(content, type);
        }
        catch (MarshallingException e) {
            throw new KieServicesException("Error while deserializing data received from server!", e);
        }
    }

    private void checkResultType(ServiceResponse<?> serviceResponse, Class<?> expectedResultType) {
        Object actualResult = serviceResponse.getResult();
        if (actualResult != null && !expectedResultType.isInstance(actualResult)) {
            throw new KieServicesException("Error while creating service response! The actual result type " + serviceResponse.getResult().getClass() + " does not match the expected type " + expectedResultType + "!");
        }
    }

    private RuntimeException createExceptionForUnexpectedResponseCode(KieRemoteHttpRequest request, KieRemoteHttpResponse response) {
        String summaryMessage = "Unexpected HTTP response code when requesting URI '" + request.getUri() + "'! Error code: " + response.code() + ", message: " + response.message();
        logger.debug(summaryMessage + ", response body: " + response.body());
        return new KieServicesException(summaryMessage);
    }

    private String buildQueryString(String paramName, List<?> items) {
        StringBuilder builder = new StringBuilder("?");
        for (Object o : items) {
            builder.append(paramName).append("=").append(o).append("&");
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    private Map<String, String> getHeaders(Object object) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (object != null) {
            headers.put("X-KIE-ClassType", object.getClass().getName());
        }
        return headers;
    }

    private String getUserQueryStr(String userId) {
        if (BYPASS_AUTH_USER.booleanValue()) {
            return "?user=" + userId;
        }
        return "";
    }

    private String getUserAndPagingQueryString(String userId, Integer page, Integer pageSize) {
        StringBuilder queryString = new StringBuilder(this.getUserQueryStr(userId));
        if (queryString.length() == 0) {
            queryString.append("?");
        } else {
            queryString.append("&");
        }
        queryString.append("page=" + page).append("&pageSize=" + pageSize);
        return queryString.toString();
    }

    private String getUserAndAdditionalParam(String userId, String name, String value) {
        StringBuilder queryString = new StringBuilder(this.getUserQueryStr(userId));
        if (queryString.length() == 0) {
            queryString.append("?");
        } else {
            queryString.append("&");
        }
        queryString.append(name).append("=").append(value);
        return queryString.toString();
    }

    private String getUserAndAdditionalParams(String userId, String name, List<?> values) {
        StringBuilder queryString = new StringBuilder(this.getUserQueryStr(userId));
        if (values != null) {
            if (queryString.length() == 0) {
                queryString.append("?");
            } else {
                queryString.append("&");
            }
            for (Object value : values) {
                queryString.append(name).append("=").append(value).append("&");
            }
            queryString.deleteCharAt(queryString.length() - 1);
        }
        return queryString.toString();
    }

    private String getPagingQueryString(String inQueryString, Integer page, Integer pageSize) {
        StringBuilder queryString = new StringBuilder(inQueryString);
        if (queryString.length() == 0) {
            queryString.append("?");
        } else {
            queryString.append("&");
        }
        queryString.append("page=" + page).append("&pageSize=" + pageSize);
        return queryString.toString();
    }

    private String getAdditionalParams(String inQueryString, String name, List<?> values) {
        StringBuilder queryString = new StringBuilder(inQueryString);
        if (values != null) {
            if (queryString.length() == 0) {
                queryString.append("?");
            } else {
                queryString.append("&");
            }
            for (Object value : values) {
                queryString.append(name).append("=").append(value).append("&");
            }
            queryString.deleteCharAt(queryString.length() - 1);
        }
        return queryString.toString();
    }
}

