/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.commands.DescriptorCommand;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.Wrapped;
import org.kie.server.api.model.instance.DocumentInstance;
import org.kie.server.api.model.instance.DocumentInstanceList;
import org.kie.server.api.rest.RestURI;
import org.kie.server.client.DocumentServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.impl.AbstractKieServicesClientImpl;

public class DocumentServicesClientImpl
extends AbstractKieServicesClientImpl
implements DocumentServicesClient {
    public DocumentServicesClientImpl(KieServicesConfiguration config) {
        super(config);
    }

    public DocumentServicesClientImpl(KieServicesConfiguration config, ClassLoader classLoader) {
        super(config, classLoader);
    }

    @Override
    public String getDocumentLink(String identifier) {
        return this.loadBalancer.getUrl() + "/" + "documents" + "/" + identifier + "/content";
    }

    @Override
    public DocumentInstance getDocument(String identifier) {
        DocumentInstance result = null;
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("documentId", identifier);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"documents/{documentId}", valuesMap), DocumentInstance.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("DocumentService", "getDocument", new Object[]{identifier})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = (DocumentInstance)response.getResult();
        }
        return result;
    }

    @Override
    public String createDocument(DocumentInstance documentInstance) {
        Object result = null;
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            result = this.makeHttpPostRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"documents", valuesMap), documentInstance, Object.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("DocumentService", "storeDocument", this.serialize(documentInstance), this.marshaller.getFormat().getType(), new Object[0])));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = response.getResult();
        }
        if (result instanceof Wrapped) {
            return (String)((Wrapped)result).unwrap();
        }
        return (String)result;
    }

    @Override
    public void updateDocument(DocumentInstance documentInstance) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("documentId", documentInstance.getIdentifier());
            this.makeHttpPutRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"documents/{documentId}", valuesMap), documentInstance, Object.class, new HashMap<String, String>());
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("DocumentService", "updateDocument", this.serialize(documentInstance), this.marshaller.getFormat().getType(), new Object[]{documentInstance.getIdentifier()})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public void deleteDocument(String identifier) {
        if (this.config.isRest()) {
            HashMap<String, String> valuesMap = new HashMap<String, String>();
            valuesMap.put("documentId", identifier);
            this.makeHttpDeleteRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"documents/{documentId}", valuesMap), Object.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("DocumentService", "deleteDocument", new Object[]{identifier})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
        }
    }

    @Override
    public List<DocumentInstance> listDocuments(Integer page, Integer pageSize) {
        DocumentInstanceList result = null;
        if (this.config.isRest()) {
            HashMap valuesMap = new HashMap();
            String queryString = this.getPagingQueryString("", page, pageSize);
            result = this.makeHttpGetRequestAndCreateCustomResponse(RestURI.build((String)this.loadBalancer.getUrl(), (String)"documents", valuesMap) + queryString, DocumentInstanceList.class);
        } else {
            CommandScript script = new CommandScript(Collections.singletonList(new DescriptorCommand("DocumentService", "listDocuments", new Object[]{page, pageSize})));
            ServiceResponse response = (ServiceResponse)this.executeJmsCommand(script, DescriptorCommand.class.getName(), "BPM").getResponses().get(0);
            this.throwExceptionOnFailure(response);
            if (this.shouldReturnWithNullResponse(response)) {
                return null;
            }
            result = (DocumentInstanceList)response.getResult();
        }
        return result.getItems();
    }
}

